/*
 * Decompiled with CFR 0.152.
 */
package serverutils.events.chunks;

import cpw.mods.fml.common.eventhandler.Cancelable;
import javax.annotation.Nullable;
import serverutils.data.ClaimedChunk;
import serverutils.events.ServerUtilitiesEvent;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.math.ChunkDimPos;

public abstract class ChunkModifiedEvent
extends ServerUtilitiesEvent {
    private final ClaimedChunk chunk;
    private final ForgePlayer player;

    public ChunkModifiedEvent(ClaimedChunk c, @Nullable ForgePlayer p) {
        this.chunk = c;
        this.player = p;
    }

    public ClaimedChunk getChunk() {
        return this.chunk;
    }

    @Nullable
    public ForgePlayer getPlayer() {
        return this.player;
    }

    public static class Unloaded
    extends ChunkModifiedEvent {
        public Unloaded(ClaimedChunk c, @Nullable ForgePlayer p) {
            super(c, p);
        }
    }

    public static class Loaded
    extends ChunkModifiedEvent {
        public Loaded(ClaimedChunk c, @Nullable ForgePlayer p) {
            super(c, p);
        }
    }

    public static class Unclaimed
    extends ChunkModifiedEvent {
        public Unclaimed(ClaimedChunk c, @Nullable ForgePlayer p) {
            super(c, p);
        }
    }

    public static class Claimed
    extends ChunkModifiedEvent {
        public Claimed(ClaimedChunk c, @Nullable ForgePlayer p) {
            super(c, p);
        }
    }

    @Cancelable
    public static class Claim
    extends ServerUtilitiesEvent {
        private final ChunkDimPos chunkDimPos;
        private final ForgePlayer player;

        public Claim(ChunkDimPos c, ForgePlayer p) {
            this.chunkDimPos = c;
            this.player = p;
        }

        public ChunkDimPos getChunkDimPos() {
            return this.chunkDimPos;
        }

        public ForgePlayer getPlayer() {
            return this.player;
        }
    }
}

