/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.block;

import java.util.Collections;
import java.util.List;
import minetweaker.api.block.BlockPatternOr;
import minetweaker.api.block.IBlock;
import minetweaker.api.block.IBlockDefinition;
import minetweaker.api.block.IBlockPattern;
import minetweaker.api.data.IData;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.block.Block;

public class MCSpecificBlock
implements IBlock {
    private final Block block;
    private final int meta;

    public MCSpecificBlock(Block block, int meta) {
        this.block = block;
        this.meta = meta;
    }

    @Override
    public IBlockDefinition getDefinition() {
        return MineTweakerMC.getBlockDefinition(this.block);
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    @Override
    public IData getTileData() {
        return null;
    }

    @Override
    public List<IBlock> getBlocks() {
        return Collections.singletonList(this);
    }

    @Override
    public boolean matches(IBlock block) {
        return block.getDefinition() == this.getDefinition() && (this.meta == Short.MAX_VALUE || block.getMeta() == this.meta);
    }

    @Override
    public IBlockPattern or(IBlockPattern pattern) {
        return new BlockPatternOr(this, pattern);
    }

    @Override
    public String getDisplayName() {
        return this.block.func_149732_F();
    }

    public String toString() {
        return "<block:" + MCSpecificBlock.getBlockId(this.block) + ":" + (this.meta == Short.MAX_VALUE ? 42 : this.meta) + ">";
    }

    private static String getBlockId(Block block) {
        return Block.field_149771_c.func_148750_c((Object)block);
    }
}

