/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import openmods.gui.component.GuiComponentSprite;
import openmods.utils.CollectionUtils;
import org.lwjgl.opengl.GL11;

public class GuiComponentCraftingGrid
extends GuiComponentSprite {
    private static final int UPDATE_DELAY = 20;
    private static final Random rnd = new Random();
    private static final Function<ItemStack, ItemStack[]> EXPAND_TRANSFORM = new Function<ItemStack, ItemStack[]>(){

        @Nullable
        public ItemStack[] apply(@Nullable ItemStack input) {
            ItemStack[] itemStackArray;
            if (input != null) {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = input.func_77946_l();
            } else {
                itemStackArray = null;
            }
            return itemStackArray;
        }
    };
    private final ItemStack[][] items;
    private final ItemStack[] selectedItems;
    private int changeCountdown = 20;

    public GuiComponentCraftingGrid(int x, int y, ItemStack[] items, IIcon background, ResourceLocation backgroundTexture) {
        this(x, y, CollectionUtils.transform(items, EXPAND_TRANSFORM), background, backgroundTexture);
    }

    public GuiComponentCraftingGrid(int x, int y, ItemStack[][] items, IIcon icon, ResourceLocation texture) {
        super(x, y, icon, texture);
        Preconditions.checkNotNull((Object)items, (Object)"No items in grid");
        this.items = items;
        this.selectedItems = new ItemStack[items.length];
        this.selectItems();
    }

    @Override
    public boolean isTicking() {
        return true;
    }

    @Override
    public void tick() {
        if (this.changeCountdown-- <= 0) {
            this.selectItems();
            this.changeCountdown = 20;
        }
    }

    @Override
    public void render(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.render(minecraft, offsetX, offsetY, mouseX, mouseY);
        boolean gridOffsetX = true;
        boolean gridOffsetY = true;
        int itemBoxSize = 19;
        for (int i = 0; i < this.items.length; ++i) {
            ItemStack input = this.selectedItems[i];
            if (input == null) continue;
            int row = i % 3;
            int column = i / 3;
            int itemX = offsetX + 1 + row * 19;
            int itemY = offsetY + 1 + column * 19;
            this.drawItemStack(input, this.x + itemX, this.y + itemY, "");
        }
    }

    private void selectItems() {
        for (int i = 0; i < this.items.length; ++i) {
            ItemStack[] slotItems = this.items[i];
            if (slotItems.length == 0) {
                this.selectedItems[i] = null;
                continue;
            }
            int choice = rnd.nextInt(slotItems.length);
            this.selectedItems[i] = slotItems[choice];
        }
    }

    @Override
    public void renderOverlay(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.renderOverlay(minecraft, offsetX, offsetY, mouseX, mouseY);
        int relativeMouseX = mouseX + offsetX - this.x;
        int relativeMouseY = mouseY + offsetY - this.y;
        boolean gridOffsetX = true;
        boolean gridOffsetY = true;
        int itemBoxSize = 19;
        if (this.isMouseOver(mouseX, mouseY)) {
            ItemStack tooltip = null;
            for (int i = 0; i < this.selectedItems.length; ++i) {
                int row = i % 3;
                int column = i / 3;
                int itemX = offsetX + 1 + row * 19;
                int itemY = offsetY + 1 + column * 19;
                if (relativeMouseX <= itemX - 2 || relativeMouseX >= itemX - 2 + 19 || relativeMouseY <= itemY - 2 || relativeMouseY >= itemY - 2 + 19) continue;
                tooltip = this.selectedItems[i];
                break;
            }
            if (tooltip != null) {
                this.drawItemStackTooltip(tooltip, relativeMouseX + 25, relativeMouseY + 30);
            }
        }
    }

    protected void drawItemStackTooltip(ItemStack stack, int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = (FontRenderer)Objects.firstNonNull((Object)stack.func_77973_b().getFontRenderer(stack), (Object)mc.field_71466_p);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        List list = stack.func_82840_a((EntityPlayer)mc.field_71439_g, mc.field_71474_y.field_82882_x);
        ArrayList colored = Lists.newArrayListWithCapacity((int)list.size());
        Iterator it = list.iterator();
        colored.add(GuiComponentCraftingGrid.getRarityColor(stack) + (String)it.next());
        while (it.hasNext()) {
            colored.add(EnumChatFormatting.GRAY + (String)it.next());
        }
        this.drawHoveringText(colored, x, y, font);
    }

    private static EnumChatFormatting getRarityColor(ItemStack stack) {
        return stack.func_77953_t().field_77937_e;
    }
}

