/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.config;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import tonius.neiintegration.IntegrationBase;
import tonius.neiintegration.NEIIntegration;
import tonius.neiintegration.config.Section;

public class Config {
    public static Configuration config;
    public static List<Section> configSections;
    public static final Section sectionIntegrations;
    public static final Section sectionHandlers;
    public static final Section sectionTooltips;
    public static boolean handlerFluidRegistry;
    public static boolean handlerOreDictionary;
    public static boolean tooltipUnlocalizedName;
    public static boolean tooltipUnlocalizedNameShift;
    public static boolean tooltipUnlocalizedNameAdvanced;
    public static boolean tooltipInternalName;
    public static boolean tooltipInternalNameShift;
    public static boolean tooltipInternalNameAdvanced;
    public static boolean tooltipMaxStack;
    public static boolean tooltipMaxStackShift;
    public static boolean tooltipMaxStackAdvanced;
    public static boolean tooltipBurnTime;
    public static boolean tooltipBurnTimeShift;
    public static boolean tooltipBurnTimeAdvanced;
    public static boolean tooltipOreDictNames;
    public static boolean tooltipOreDictNamesShift;
    public static boolean tooltipOreDictNamesAdvanced;
    public static boolean tooltipFluidRegInfo;
    public static boolean tooltipFluidRegInfoShift;
    public static boolean tooltipFluidRegInfoAdvanced;

    public static void preInit(FMLPreInitializationEvent evt) {
        FMLCommonHandler.instance().bus().register((Object)new Config());
        config = new Configuration(new File(evt.getModConfigurationDirectory(), "neiintegration.cfg"));
        Config.syncConfig();
    }

    public static void syncConfig() {
        NEIIntegration.log.info("Loading configuration files");
        try {
            Config.processConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent evt) {
        if (evt.modID.equals("neiintegration")) {
            Config.syncConfig();
        }
    }

    public static void processConfig() {
        Iterator<IntegrationBase> itr = NEIIntegration.integrations.iterator();
        while (itr.hasNext()) {
            IntegrationBase integration = itr.next();
            String name = integration.getName();
            boolean enabledByDefault = integration.isEnabledByDefault();
            if (!integration.isValid()) {
                itr.remove();
                continue;
            }
            if (config.get(Config.sectionIntegrations.name, name, enabledByDefault, String.format("Whether to enable %s integration. Disable if this part of the mod causes crashes.", name)).setRequiresMcRestart(true).getBoolean(enabledByDefault)) continue;
            itr.remove();
        }
        handlerFluidRegistry = config.get(Config.sectionHandlers.name, "Fluid Registry", false, "Shows information about registered fluids when looking them or related items up.").getBoolean(false);
        handlerOreDictionary = config.get(Config.sectionHandlers.name, "Ore Dictionary", false, "Shows information about items registered in the Ore Dictionary when looking up item usage.").getBoolean(false);
        tooltipUnlocalizedName = config.get(Config.sectionTooltips.name, "Unlocalized Name", false, "Show the unlocalized name (example: 'tile.stone') of items.").getBoolean(false);
        tooltipUnlocalizedNameShift = config.get(Config.sectionTooltips.name, "Unlocalized Name Shift", false, "If unlocalized names are enabled, they will only be shown if the Shift key is held. Effect stacks with Advanced if enabled.").getBoolean(false);
        tooltipUnlocalizedNameAdvanced = config.get(Config.sectionTooltips.name, "Unlocalized Name Advanced", false, "If unlocalized names are enabled, they will only be shown in advanced (F3+H) tooltips. Effect stacks with Shift if enabled.").getBoolean(false);
        tooltipInternalName = config.get(Config.sectionTooltips.name, "Internal Name", false, "Show the internal name (example: 'minecraft:stone') of items.").getBoolean(false);
        tooltipInternalNameShift = config.get(Config.sectionTooltips.name, "Internal Name Shift", false, "If internal names are enabled, they will only be shown if the Shift key is held. Effect stacks with Advanced if enabled.").getBoolean(false);
        tooltipInternalNameAdvanced = config.get(Config.sectionTooltips.name, "Internal Name Advanced", false, "If internal names are enabled, they will only be shown in advanced (F3+H) tooltips. Effect stacks with Shift if enabled.").getBoolean(false);
        tooltipMaxStack = config.get(Config.sectionTooltips.name, "Maximum Stack Size", false, "Show the maximum stack size of items.").getBoolean(false);
        tooltipMaxStackShift = config.get(Config.sectionTooltips.name, "Maximum Stack Size Shift", false, "If maximum stack sizes are enabled, they will only be shown if the Shift key is held. Effect stacks with Advanced if enabled.").getBoolean(false);
        tooltipMaxStackAdvanced = config.get(Config.sectionTooltips.name, "Maximum Stack Size Advanced", false, "If maximum stack sizes are enabled, they will only be shown in advanced (F3+H) tooltips. Effect stacks with Shift if enabled.").getBoolean(false);
        tooltipBurnTime = config.get(Config.sectionTooltips.name, "Burn Time", false, "Show the burn time of items when used as furnace fuel.").getBoolean(false);
        tooltipBurnTimeShift = config.get(Config.sectionTooltips.name, "Burn Time Shift", false, "If burn times are enabled, they will only be shown if the Shift key is held. Effect stacks with Advanced if enabled.").getBoolean(false);
        tooltipBurnTimeAdvanced = config.get(Config.sectionTooltips.name, "Burn Time Advanced", false, "If burn times are enabled, they will only be shown in advanced (F3+H) tooltips. Effect stacks with Shift if enabled.").getBoolean(false);
        tooltipOreDictNames = config.get(Config.sectionTooltips.name, "Ore Dictionary Names", false, "Show the Ore Dictionary names of items.").getBoolean(false);
        tooltipOreDictNamesShift = config.get(Config.sectionTooltips.name, "Ore Dictionary Names Shift", false, "If Ore Dictionary names are enabled, they will only be shown if the Shift key is held. Effect stacks with Advanced if enabled.").getBoolean(false);
        tooltipOreDictNamesAdvanced = config.get(Config.sectionTooltips.name, "Ore Dictionary Names Advanced", false, "If Ore Dictionary names are enabled, they will only be shown in advanced (F3+H) tooltips. Effect stacks with Shift if enabled.").getBoolean(false);
        tooltipFluidRegInfo = config.get(Config.sectionTooltips.name, "Fluid Registry Info", false, "Show some fluid info on fluid-related items.").getBoolean(false);
        tooltipFluidRegInfoShift = config.get(Config.sectionTooltips.name, "Fluid Registry Info Shift", false, "If fluid registry info is enabled, it will only be shown if the Shift key is held. Effect stacks with Advanced if enabled.").getBoolean(false);
        tooltipFluidRegInfoAdvanced = config.get(Config.sectionTooltips.name, "Fluid Registry Info Advanced", false, "If fluid registry info is enabled, it will only be shown in advanced (F3+H) tooltips. Effect stacks with Shift if enabled.").getBoolean(false);
    }

    static {
        configSections = new ArrayList<Section>();
        sectionIntegrations = new Section("Integrations", "integrations");
        sectionHandlers = new Section("Handlers", "handlers");
        sectionTooltips = new Section("Tooltips", "tooltips");
        handlerFluidRegistry = false;
        handlerOreDictionary = false;
        tooltipUnlocalizedName = false;
        tooltipUnlocalizedNameShift = false;
        tooltipUnlocalizedNameAdvanced = false;
        tooltipInternalName = false;
        tooltipInternalNameShift = false;
        tooltipInternalNameAdvanced = false;
        tooltipMaxStack = false;
        tooltipMaxStackShift = false;
        tooltipMaxStackAdvanced = false;
        tooltipBurnTime = false;
        tooltipBurnTimeShift = false;
        tooltipBurnTimeAdvanced = false;
        tooltipOreDictNames = false;
        tooltipOreDictNamesShift = false;
        tooltipOreDictNamesAdvanced = false;
        tooltipFluidRegInfo = false;
        tooltipFluidRegInfoShift = false;
        tooltipFluidRegInfoAdvanced = false;
    }
}

