/*
 * Decompiled with CFR 0.152.
 */
package squeek.tictooltips.helpers;

import java.util.TreeMap;

public class RomanNumeralHelper {
    private static final TreeMap<Character, Integer> RomanNumberDictionary = new TreeMap();
    private static final TreeMap<Integer, String> NumberRomanDictionary;

    public static String toRoman(int number) {
        int key = NumberRomanDictionary.floorKey(number);
        if (number == key) {
            return NumberRomanDictionary.get(key);
        }
        return NumberRomanDictionary.get(key) + RomanNumeralHelper.toRoman(number - key);
    }

    public static int fromRoman(String roman) {
        int total = 0;
        int previous = 0;
        char previousRoman = '\u0000';
        for (int i = 0; i < roman.length(); ++i) {
            char currentRoman = roman.charAt(i);
            previous = previousRoman != '\u0000' ? RomanNumberDictionary.get(Character.valueOf(previousRoman)) : 0;
            int current = RomanNumberDictionary.get(Character.valueOf(currentRoman));
            total = previous != 0 && current > previous ? total - 2 * previous + current : (total += current);
            previousRoman = currentRoman;
        }
        return total;
    }

    static {
        RomanNumberDictionary.put(Character.valueOf('I'), 1);
        RomanNumberDictionary.put(Character.valueOf('V'), 5);
        RomanNumberDictionary.put(Character.valueOf('X'), 10);
        RomanNumberDictionary.put(Character.valueOf('L'), 50);
        RomanNumberDictionary.put(Character.valueOf('C'), 100);
        RomanNumberDictionary.put(Character.valueOf('D'), 500);
        RomanNumberDictionary.put(Character.valueOf('M'), 1000);
        NumberRomanDictionary = new TreeMap();
        NumberRomanDictionary.put(1000, "M");
        NumberRomanDictionary.put(900, "CM");
        NumberRomanDictionary.put(500, "D");
        NumberRomanDictionary.put(400, "CD");
        NumberRomanDictionary.put(100, "C");
        NumberRomanDictionary.put(50, "L");
        NumberRomanDictionary.put(40, "XL");
        NumberRomanDictionary.put(10, "X");
        NumberRomanDictionary.put(9, "IX");
        NumberRomanDictionary.put(5, "V");
        NumberRomanDictionary.put(4, "IV");
        NumberRomanDictionary.put(1, "I");
    }
}

