/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.naming;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import stevesaddons.naming.BlockCoord;
import stevesaddons.naming.NameData;
import stevesaddons.network.MessageHandler;
import stevesaddons.network.message.FullDataSyncMessage;
import stevesaddons.network.message.NameDataUpdateMessage;
import stevesaddons.network.message.WorldDataSyncMessage;

public class NameRegistry {
    public static NameRegistry instance = new NameRegistry();
    private Map<Integer, NameData> nameMapping = new HashMap<Integer, NameData>();

    public static String getSavedName(World world, int x, int y, int z) {
        NameData data = NameRegistry.instance.nameMapping.get(world.field_73011_w.field_76574_g);
        if (data == null) {
            return null;
        }
        return data.get(new BlockCoord(x, y, z));
    }

    public static String getSavedName(int dimensionId, BlockCoord coord) {
        NameData data = NameRegistry.instance.nameMapping.get(dimensionId);
        if (data == null) {
            return null;
        }
        return data.get(coord);
    }

    public static void saveName(World world, int x, int y, int z, String name) {
        BlockCoord coord = new BlockCoord(x, y, z, name);
        if (world.field_72995_K) {
            MessageHandler.INSTANCE.sendToServer((IMessage)new NameDataUpdateMessage(world.field_73011_w.field_76574_g, coord));
        } else {
            if (!NameRegistry.instance.nameMapping.containsKey(world.field_73011_w.field_76574_g)) {
                NameRegistry.instance.nameMapping.put(world.field_73011_w.field_76574_g, new NameData());
            }
            NameData data = NameRegistry.instance.nameMapping.get(world.field_73011_w.field_76574_g);
            data.func_76185_a();
            MessageHandler.INSTANCE.sendToAll((IMessage)new NameDataUpdateMessage(world.field_73011_w.field_76574_g, coord));
        }
    }

    public static void saveName(NameDataUpdateMessage message) {
        if (!NameRegistry.instance.nameMapping.containsKey(message.dimId)) {
            NameRegistry.instance.nameMapping.put(message.dimId, new NameData());
        }
        NameData data = NameRegistry.instance.nameMapping.get(message.dimId);
        data.put(message.blockCoord);
    }

    public static boolean removeName(World world, int x, int y, int z) {
        BlockCoord coord = new BlockCoord(x, y, z, "");
        if (!NameRegistry.instance.nameMapping.containsKey(world.field_73011_w.field_76574_g)) {
            return false;
        }
        NameData data = NameRegistry.instance.nameMapping.get(world.field_73011_w.field_76574_g);
        if (!data.names.containsKey(coord)) {
            return false;
        }
        if (world.field_72995_K) {
            MessageHandler.INSTANCE.sendToServer((IMessage)new NameDataUpdateMessage(world.field_73011_w.field_76574_g, coord, true));
        } else {
            data.remove(coord);
            data.func_76185_a();
            MessageHandler.INSTANCE.sendToAll((IMessage)new NameDataUpdateMessage(world.field_73011_w.field_76574_g, coord, true));
        }
        return true;
    }

    public static void removeName(NameDataUpdateMessage message) {
        if (!NameRegistry.instance.nameMapping.containsKey(message.dimId)) {
            return;
        }
        NameData data = NameRegistry.instance.nameMapping.get(message.dimId);
        data.func_76185_a();
        data.remove(message.blockCoord);
    }

    public static void setWorldData(int dim, NameData data) {
        NameRegistry.instance.nameMapping.put(dim, data);
        MessageHandler.INSTANCE.sendToAll((IMessage)new WorldDataSyncMessage(dim, data));
    }

    public static void setWorldData(WorldDataSyncMessage message) {
        NameData nameData = new NameData();
        nameData.func_76184_a(message.tagCompound);
        NameRegistry.setWorldData(message.dimId, nameData);
    }

    public static NameData getWorldData(int dim, boolean unload) {
        NameData data = NameRegistry.instance.nameMapping.get(dim);
        if (unload) {
            NameRegistry.instance.nameMapping.remove(dim);
        }
        return data;
    }

    public static void setNameData(Map<Integer, NameData> nameMapping) {
        NameRegistry.instance.nameMapping.putAll(nameMapping);
    }

    public static void syncNameData(EntityPlayerMP player) {
        MessageHandler.INSTANCE.sendTo((IMessage)new FullDataSyncMessage(NameRegistry.instance.nameMapping), player);
    }
}

