/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.ticks;

import java.util.concurrent.PriorityBlockingQueue;
import logisticspipes.config.Configs;

public class RoutingTableUpdateThread
extends Thread {
    private static final PriorityBlockingQueue<Runnable> updateCalls = new PriorityBlockingQueue();
    private static Long average = 0L;

    public RoutingTableUpdateThread(int i) {
        super("LogisticsPipes RoutingTableUpdateThread #" + i);
        this.setDaemon(true);
        this.setPriority(Configs.MULTI_THREAD_PRIORITY);
        this.start();
    }

    public static void add(Runnable run) {
        updateCalls.add(run);
    }

    public static boolean remove(Runnable run) {
        return updateCalls.remove(run);
    }

    public static int size() {
        return updateCalls.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getAverage() {
        Long l = average;
        synchronized (l) {
            return average;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            Runnable item;
            while ((item = updateCalls.take()) != null) {
                long starttime = System.nanoTime();
                item.run();
                long took = System.nanoTime() - starttime;
                Long l = average;
                synchronized (l) {
                    average = average == 0L ? Long.valueOf(took) : Long.valueOf((average * 999L + took) / 1000L);
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

