/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.request.BaseCraftingTemplate;
import logisticspipes.request.IExtraPromise;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ItemResource;
import logisticspipes.routing.LogisticsExtraPromise;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.utils.item.ItemIdentifierStack;

public class ItemCraftingTemplate
extends BaseCraftingTemplate {
    protected ItemIdentifierStack _result;
    protected ICraftItems _crafter;
    protected ArrayList<ItemIdentifierStack> _byproduct = new ArrayList(9);

    public ItemCraftingTemplate(ItemIdentifierStack result, ICraftItems crafter, int priority) {
        super(9, priority);
        this._result = result;
        this._crafter = crafter;
    }

    @Override
    public void addByproduct(ItemIdentifierStack stack) {
        for (ItemIdentifierStack i : this._byproduct) {
            if (!i.getItem().equals(stack.getItem())) continue;
            i.setStackSize(i.getStackSize() + stack.getStackSize());
            return;
        }
        this._byproduct.add(stack);
    }

    @Override
    public LogisticsPromise generatePromise(int nResultSets) {
        return new LogisticsPromise(this._result.getItem(), this._result.getStackSize() * nResultSets, this._crafter, IOrderInfoProvider.ResourceType.CRAFTING);
    }

    @Override
    public ICraftItems getCrafter() {
        return this._crafter;
    }

    @Override
    public boolean canCraft(IResource type) {
        if (type instanceof ItemResource) {
            return ((ItemResource)type).getItem().equals(this._result.getItem());
        }
        if (type instanceof DictResource) {
            return type.matches(this._result.getItem(), IResource.MatchSettings.NORMAL);
        }
        return false;
    }

    @Override
    public IResource getResultResource() {
        return new ItemResource(this._result, null);
    }

    @Override
    public ItemIdentifierStack getResultStack() {
        return this._result;
    }

    @Override
    public List<IExtraPromise> getByproducts(int workSets) {
        ArrayList<IExtraPromise> list = new ArrayList<IExtraPromise>();
        for (ItemIdentifierStack stack : this._byproduct) {
            list.add(new LogisticsExtraPromise(stack.getItem(), stack.getStackSize() * workSets, (IProvideItems)this.getCrafter(), false));
        }
        return list;
    }
}

