/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import logisticspipes.gui.modules.ModuleBaseGui;
import logisticspipes.modules.ModuleApiaristSink;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.module.BeeModuleSetBeePacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.IItemTextureRenderSlot;
import logisticspipes.utils.gui.ISmallColorRenderSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class GuiApiaristSink
extends ModuleBaseGui {
    private final ModuleApiaristSink module;

    public GuiApiaristSink(ModuleApiaristSink module, EntityPlayer player) {
        super(new DummyContainer((IInventory)player.field_71071_by, null), module);
        this.module = module;
        for (int i = 0; i < 6; ++i) {
            ModuleApiaristSink.SinkSetting filter = module.filter[i];
            this.addRenderSlot(new TypeSlot(20, 20 + i * 18, filter, i));
            this.addRenderSlot(new GroupSlot(this.field_147003_i + 45, this.field_147009_r + 25 + i * 18, filter, i));
            this.addRenderSlot(new BeeSlot(60, 20 + i * 18, filter, 0, i));
            this.addRenderSlot(new BeeSlot(78, 20 + i * 18, filter, 1, i));
        }
        this.field_146999_f = 120;
        this.field_147000_g = 150;
    }

    public void renderForestryBeeAt(Minecraft mc, int x, int y, float zLevel, String id) {
        GL11.glDisable((int)2896);
        mc.field_71446_o.func_110577_a(TextureMap.field_110576_c);
        for (int i = 0; i < SimpleServiceLocator.forestryProxy.getRenderPassesForAlleleId(id); ++i) {
            IIcon icon = SimpleServiceLocator.forestryProxy.getIconIndexForAlleleId(id, i);
            if (icon == null) continue;
            int color = SimpleServiceLocator.forestryProxy.getColorForAlleleId(id, i);
            float colorR = (float)(color >> 16 & 0xFF) / 255.0f;
            float colorG = (float)(color >> 8 & 0xFF) / 255.0f;
            float colorB = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
            Tessellator var9 = Tessellator.field_78398_a;
            var9.func_78382_b();
            var9.func_78374_a((double)x, (double)(y + 16), (double)zLevel, (double)icon.func_94209_e(), (double)icon.func_94210_h());
            var9.func_78374_a((double)(x + 16), (double)(y + 16), (double)zLevel, (double)icon.func_94212_f(), (double)icon.func_94210_h());
            var9.func_78374_a((double)(x + 16), (double)y, (double)zLevel, (double)icon.func_94212_f(), (double)icon.func_94206_g());
            var9.func_78374_a((double)x, (double)y, (double)zLevel, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            var9.func_78381_a();
        }
        GL11.glEnable((int)2896);
    }

    @Override
    protected void func_146976_a(float var1, int var2, int var3) {
        GuiGraphics.drawGuiBackGround(this.field_146297_k, this.field_147003_i, this.field_147009_r, this.right, this.bottom, this.field_73735_i, true);
    }

    private class TypeSlot
    extends IItemTextureRenderSlot {
        private final int xPos;
        private final int yPos;
        private final ModuleApiaristSink.SinkSetting setting;
        private final int row;

        private TypeSlot(int xPos, int yPos, ModuleApiaristSink.SinkSetting setting, int row) {
            this.xPos = xPos;
            this.yPos = yPos;
            this.setting = setting;
            this.row = row;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IIcon getTextureIcon() {
            if (this.setting.filterType == null) {
                return null;
            }
            return SimpleServiceLocator.forestryProxy.getIconFromTextureManager("analyzer/" + this.setting.filterType.icon);
        }

        @Override
        public void mouseClicked(int button) {
            if (button == 2) {
                this.setting.FilterTypeReset();
            }
            if (button == 0) {
                this.setting.FilterTypeUp();
            }
            if (button == 1) {
                this.setting.FilterTypeDown();
            }
            MainProxy.sendPacketToServer(PacketHandler.getPacket(BeeModuleSetBeePacket.class).setInteger2(this.row).setInteger3(3).setInteger4(this.setting.filterType.ordinal()).setModulePos(GuiApiaristSink.this.module));
        }

        @Override
        public boolean drawSlotBackground() {
            return true;
        }

        @Override
        public int getXPos() {
            return this.xPos;
        }

        @Override
        public int getYPos() {
            return this.yPos;
        }

        @Override
        public boolean drawSlotIcon() {
            return true;
        }

        @Override
        public String getToolTipText() {
            if (this.setting.filterType == null) {
                return "";
            }
            return SimpleServiceLocator.forestryProxy.getForestryTranslation(this.setting.filterType.path);
        }

        @Override
        public boolean displayToolTip() {
            return this.setting.filterType != ModuleApiaristSink.FilterType.Null;
        }

        @Override
        public boolean customRender(Minecraft mc, float zLevel) {
            return false;
        }
    }

    private class GroupSlot
    extends ISmallColorRenderSlot {
        private final int xPos;
        private final int yPos;
        private final ModuleApiaristSink.SinkSetting setting;
        private final int row;

        private GroupSlot(int xPos, int yPos, ModuleApiaristSink.SinkSetting setting, int row) {
            this.xPos = xPos;
            this.yPos = yPos;
            this.setting = setting;
            this.row = row;
        }

        @Override
        public void mouseClicked(int button) {
            if (button == 2) {
                this.setting.filterGroupReset();
            }
            if (button == 0) {
                this.setting.filterGroupUp();
            }
            if (button == 1) {
                this.setting.filterGroupDown();
            }
            MainProxy.sendPacketToServer(PacketHandler.getPacket(BeeModuleSetBeePacket.class).setInteger2(this.row).setInteger3(2).setInteger4(this.setting.filterGroup).setModulePos(GuiApiaristSink.this.module));
        }

        @Override
        public boolean drawSlotBackground() {
            return this.setting.filterType != ModuleApiaristSink.FilterType.Null;
        }

        @Override
        public int getXPos() {
            return this.xPos;
        }

        @Override
        public int getYPos() {
            return this.yPos;
        }

        @Override
        public String getToolTipText() {
            switch (this.setting.filterGroup) {
                case 1: {
                    return "GroupColor: RED";
                }
                case 2: {
                    return "GroupColor: Green";
                }
                case 3: {
                    return "GroupColor: Blue";
                }
                case 4: {
                    return "GroupColor: Yellow";
                }
                case 5: {
                    return "GroupColor: Cyan";
                }
                case 6: {
                    return "GroupColor: Purple";
                }
            }
            return "No Group";
        }

        @Override
        public boolean displayToolTip() {
            return this.drawSlotBackground();
        }

        @Override
        public int getColor() {
            switch (this.setting.filterGroup) {
                case 1: {
                    return -65536;
                }
                case 2: {
                    return -16711936;
                }
                case 3: {
                    return -16776961;
                }
                case 4: {
                    return -256;
                }
                case 5: {
                    return -16711681;
                }
                case 6: {
                    return -65281;
                }
            }
            return 0;
        }

        @Override
        public boolean drawColor() {
            return this.drawSlotBackground();
        }
    }

    private class BeeSlot
    extends IItemTextureRenderSlot {
        private final int xPos;
        private final int yPos;
        private final ModuleApiaristSink.SinkSetting setting;
        private final int slotNumber;
        private final int row;

        private BeeSlot(int xPos, int yPos, ModuleApiaristSink.SinkSetting setting, int slotNumber, int row) {
            this.xPos = xPos;
            this.yPos = yPos;
            this.setting = setting;
            this.slotNumber = slotNumber;
            this.row = row;
        }

        @Override
        public void mouseClicked(int button) {
            if (button == 2) {
                if (this.slotNumber == 0) {
                    this.setting.firstBeeReset();
                } else {
                    this.setting.secondBeeReset();
                }
            }
            if (button == 0) {
                if (this.slotNumber == 0) {
                    this.setting.firstBeeUp();
                } else {
                    this.setting.secondBeeUp();
                }
            }
            if (button == 1) {
                if (this.slotNumber == 0) {
                    this.setting.firstBeeDown();
                } else {
                    this.setting.secondBeeDown();
                }
            }
            MainProxy.sendPacketToServer(PacketHandler.getPacket(BeeModuleSetBeePacket.class).setInteger2(this.row).setInteger3(this.slotNumber).setString1(this.slotNumber == 0 ? this.setting.firstBee : this.setting.secondBee).setModulePos(GuiApiaristSink.this.module));
        }

        @Override
        public boolean drawSlotBackground() {
            return this.setting.filterType.secondSlots > this.slotNumber;
        }

        @Override
        public int getXPos() {
            return this.xPos;
        }

        @Override
        public int getYPos() {
            return this.yPos;
        }

        @Override
        public boolean drawSlotIcon() {
            return this.drawSlotBackground() && !(this.slotNumber == 0 ? this.setting.firstBee : this.setting.secondBee).isEmpty();
        }

        @Override
        public String getToolTipText() {
            return SimpleServiceLocator.forestryProxy.getAlleleName(this.slotNumber == 0 ? this.setting.firstBee : this.setting.secondBee);
        }

        @Override
        public boolean displayToolTip() {
            if (this.slotNumber == 0) {
                return !this.setting.firstBee.isEmpty() && this.drawSlotBackground();
            }
            return !this.setting.secondBee.isEmpty() && this.drawSlotBackground();
        }

        @Override
        public boolean customRender(Minecraft mc, float zLevel) {
            if (this.slotNumber == 0) {
                GuiApiaristSink.this.renderForestryBeeAt(mc, this.xPos + 1, this.yPos + 1, zLevel, this.setting.firstBee);
            } else {
                GuiApiaristSink.this.renderForestryBeeAt(mc, this.xPos + 1, this.yPos + 1, zLevel, this.setting.secondBee);
            }
            return true;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IIcon getTextureIcon() {
            return null;
        }
    }
}

