/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks.stats;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.blocks.LogisticsSolidTileEntity;
import logisticspipes.blocks.stats.TrackingTask;
import logisticspipes.interfaces.IGuiTileEntity;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.abstractguis.CoordinatesGuiProvider;
import logisticspipes.network.guis.block.StatisticsGui;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.WorldUtil;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class LogisticsStatisticsTileEntity
extends LogisticsSolidTileEntity
implements IGuiTileEntity {
    public List<TrackingTask> tasks = new ArrayList<TrackingTask>();
    private int tickCount;
    private CoreRoutedPipe cachedConnectedPipe;

    @Override
    public void notifyOfBlockChange() {
        this.cachedConnectedPipe = null;
    }

    @Override
    public void func_145845_h() {
        if (MainProxy.isClient(this.field_145850_b)) {
            return;
        }
        ++this.tickCount;
        if (this.getConnectedPipe() == null) {
            return;
        }
        for (TrackingTask task : this.tasks) {
            task.tick(this.tickCount, this.getConnectedPipe());
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int size = nbt.func_74762_e("taskSize");
        for (int i = 0; i < size; ++i) {
            NBTTagCompound tag = (NBTTagCompound)nbt.func_74781_a("Task_" + i);
            TrackingTask task = new TrackingTask();
            task.readFromNBT(tag);
            this.tasks.add(task);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("taskSize", this.tasks.size());
        int count = 0;
        for (TrackingTask task : this.tasks) {
            NBTTagCompound tag = new NBTTagCompound();
            task.writeToNBT(tag);
            nbt.func_74782_a("Task_" + count, (NBTBase)tag);
            ++count;
        }
    }

    @Override
    public CoordinatesGuiProvider getGuiProvider() {
        return NewGuiHandler.getGui(StatisticsGui.class).setTrackingList(this.tasks);
    }

    public CoreRoutedPipe getConnectedPipe() {
        if (this.cachedConnectedPipe == null) {
            WorldUtil util = new WorldUtil(this);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = util.getAdjacentTileEntitie(dir);
                if (!(tile instanceof LogisticsTileGenericPipe) || !(((LogisticsTileGenericPipe)tile).pipe instanceof CoreRoutedPipe)) continue;
                this.cachedConnectedPipe = (CoreRoutedPipe)((LogisticsTileGenericPipe)tile).pipe;
            }
        }
        return this.cachedConnectedPipe;
    }
}

