/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.navigator.api.util;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class DrawUtils {
    public static void drawGradientRect(double minPixelX, double minPixelY, double maxPixelX, double maxPixelY, double z, int colorA, int colorB) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        float alpha = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float red = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float green = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colorA & 0xFF) / 255.0f;
        tessellator.func_78369_a(red, green, blue, alpha);
        tessellator.func_78377_a(maxPixelX, minPixelY, z);
        tessellator.func_78377_a(minPixelX, minPixelY, z);
        alpha = (float)(colorB >> 24 & 0xFF) / 255.0f;
        red = (float)(colorB >> 16 & 0xFF) / 255.0f;
        green = (float)(colorB >> 8 & 0xFF) / 255.0f;
        blue = (float)(colorB & 0xFF) / 255.0f;
        tessellator.func_78369_a(red, green, blue, alpha);
        tessellator.func_78377_a(minPixelX, maxPixelY, z);
        tessellator.func_78377_a(maxPixelX, maxPixelY, z);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawGradientRect(double minPixelX, double minPixelY, double maxPixelX, double maxPixelY, int colorA, int colorB) {
        DrawUtils.drawGradientRect(minPixelX, minPixelY, maxPixelX, maxPixelY, 300.0, colorA, colorB);
    }

    public static void drawQuad(ResourceLocation texture, double x, double y, double width, double height, int color, int alpha) {
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glEnable((int)3553);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        DrawUtils.addRectToBufferWithUV(tessellator, x, y, width, height, color, alpha, 0.0, 0.0, 1.0, 1.0);
        tessellator.func_78381_a();
    }

    public static void drawQuad(ResourceLocation texture, double x, double y, double width, double height, int color, float alpha) {
        DrawUtils.drawQuad(texture, x, y, width, height, color, (int)alpha);
    }

    public static void drawQuad(IIcon icon, double x, double y, double width, double height, int color, int alpha) {
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glEnable((int)3553);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        DrawUtils.addRectToBufferWithUV(tessellator, x, y, width, height, color, alpha, icon.func_94209_e(), icon.func_94206_g(), icon.func_94212_f(), icon.func_94210_h());
        tessellator.func_78381_a();
    }

    public static void drawQuad(IIcon icon, double x, double y, double width, double height, int color, float alpha) {
        DrawUtils.drawQuad(icon, x, y, width, height, color, (int)alpha);
    }

    public static void addRectToBuffer(Tessellator tessellator, double x, double y, double w, double h, int color, int alpha) {
        int[] c = DrawUtils.ints(color, alpha);
        tessellator.func_78370_a(c[0], c[1], c[2], c[3]);
        tessellator.func_78377_a(x, y + h, 0.0);
        tessellator.func_78377_a(x + w, y + h, 0.0);
        tessellator.func_78377_a(x + w, y, 0.0);
        tessellator.func_78377_a(x, y, 0.0);
    }

    public static void addRectToBufferWithUV(Tessellator tessellator, double x, double y, double w, double h, int color, int alpha, double u0, double v0, double u1, double v1) {
        int[] c = DrawUtils.ints(color, alpha);
        tessellator.func_78370_a(c[0], c[1], c[2], c[3]);
        tessellator.func_78374_a(x, y + h, 0.0, u0, v1);
        tessellator.func_78374_a(x + w, y + h, 0.0, u1, v1);
        tessellator.func_78374_a(x + w, y, 0.0, u1, v0);
        tessellator.func_78374_a(x, y, 0.0, u0, v0);
    }

    public static void drawRect(double x, double y, double w, double h, int color, int alpha) {
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        DrawUtils.addRectToBuffer(tessellator, x, y, w, h, color, alpha);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
    }

    public static void setupDrawing() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
    }

    public static void drawSimpleLabel(GuiScreen gui, String text, double textX, double textY, int fontColor, int bgColor, boolean centered) {
        GL11.glPushMatrix();
        double textWidth = gui.field_146297_k.field_71466_p.func_78256_a(text);
        double xOffsetL = centered ? -textWidth / 2.0 - 2.0 : -2.0;
        double xOffsetR = centered ? textWidth / 2.0 + 2.0 : textWidth + 2.0;
        DrawUtils.drawRect(textX + xOffsetL, textY - 2.0, xOffsetR, gui.field_146297_k.field_71466_p.field_78288_b + 2, bgColor, 180);
        if (centered) {
            gui.func_73732_a(gui.field_146297_k.field_71466_p, text, (int)textX, (int)textY, fontColor);
        } else {
            gui.func_73731_b(gui.field_146297_k.field_71466_p, text, (int)textX, (int)textY, fontColor);
        }
        GL11.glPopMatrix();
    }

    public static void drawSimpleLabel(String text, double textX, double textY, int fontColor, int bgColor, boolean centered) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = mc.field_71466_p;
        GL11.glPushMatrix();
        double dTextX = textX - (double)((int)textX);
        double dTextY = textY - (double)((int)textY);
        double textWidth = fontRenderer.func_78256_a(text);
        double xOffsetL = centered ? -textWidth / 2.0 - 2.0 : -2.0;
        double xOffsetR = centered ? textWidth / 2.0 + 2.0 : textWidth + 2.0;
        GL11.glTranslated((double)dTextX, (double)dTextY, (double)0.0);
        DrawUtils.drawRect(textX + xOffsetL, textY - 2.0, xOffsetR, fontRenderer.field_78288_b + 2, bgColor, 180);
        if (centered) {
            fontRenderer.func_78261_a(text, (int)(textX - textWidth / 2.0), (int)textY, fontColor);
        } else {
            fontRenderer.func_78276_b(text, (int)textX, (int)textY, fontColor);
        }
        GL11.glPopMatrix();
    }

    public static void drawHollowRect(double x, double y, double w, double h, int col, int alpha) {
        DrawUtils.drawHollowRect(x, y, w, h, col, alpha, 1.0);
    }

    public static void drawHollowRect(double x, double y, double w, double h, int col, int alpha, double thickness) {
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        DrawUtils.addRectToBuffer(tessellator, x, y + thickness, thickness, h - 1.0 - thickness, col, alpha);
        DrawUtils.addRectToBuffer(tessellator, x + w - thickness, y + thickness, thickness, h - 1.0 - thickness, col, alpha);
        DrawUtils.addRectToBuffer(tessellator, x, y, w, thickness, col, alpha);
        DrawUtils.addRectToBuffer(tessellator, x, y + h - thickness, w, thickness, col, alpha);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
    }

    public static void drawSimpleTooltip(GuiScreen gui, List<String> text, double x, double y, int fontColor, int bgColor) {
        if (text.isEmpty()) {
            return;
        }
        int maxTextWidth = 0;
        for (String str : text) {
            int strWidth = gui.field_146297_k.field_71466_p.func_78256_a(str);
            if (strWidth <= maxTextWidth) continue;
            maxTextWidth = strWidth;
        }
        int boxWidth = maxTextWidth + 6;
        int boxHeight = text.size() * (gui.field_146297_k.field_71466_p.field_78288_b + 2) + 6;
        double dx = x - (double)((int)x);
        double dy = y - (double)((int)y);
        GL11.glPushMatrix();
        DrawUtils.drawRect(x, y, boxWidth, boxHeight, bgColor, 180);
        GL11.glTranslated((double)dx, (double)dy, (double)301.0);
        for (int i = 0; i < text.size(); ++i) {
            gui.func_73731_b(gui.field_146297_k.field_71466_p, text.get(i), (int)x + 3, (int)y + 3 + i * (gui.field_146297_k.field_71466_p.field_78288_b + 2), fontColor);
        }
        GL11.glPopMatrix();
    }

    public static void drawLabel(String text, double textX, double textY, int fontColor, int bgColor, boolean centered) {
        DrawUtils.drawLabel(text, textX, textY, fontColor, bgColor, centered, 1.0);
    }

    public static void drawLabel(String text, double textX, double textY, int fontColor, int bgColor, boolean centered, double fontScale) {
        DrawUtils.drawLabel(text, textX, textY, fontColor, bgColor, centered, true, fontScale);
    }

    public static void drawLabel(String text, double textX, double textY, int fontColor, int bgColor, boolean centered, boolean fontShadow, double fontScale) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        GL11.glPushMatrix();
        if (fontScale != 1.0) {
            textX /= fontScale;
            textY /= fontScale;
            GL11.glScaled((double)fontScale, (double)fontScale, (double)0.0);
        }
        double dTextX = textX - (double)((int)textX);
        double dTextY = textY - (double)((int)textY);
        double textWidth = fontRenderer.func_78256_a(text);
        double xOffsetL = centered ? -textWidth / 2.0 - 2.0 : -2.0;
        GL11.glTranslated((double)dTextX, (double)dTextY, (double)0.0);
        DrawUtils.drawRect(textX + xOffsetL, textY - 2.0, textWidth + 2.0, fontRenderer.field_78288_b + 2, bgColor, 180);
        if (fontShadow) {
            fontRenderer.func_78261_a(text, centered ? (int)(textX - textWidth / 2.0) : (int)textX, (int)textY, fontColor);
        } else {
            fontRenderer.func_78276_b(text, centered ? (int)(textX - textWidth / 2.0) : (int)textX, (int)textY, fontColor);
        }
        GL11.glPopMatrix();
    }

    public static float[] floats(int rgb) {
        return new float[]{(float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f};
    }

    public static int[] ints(int rgb, int alpha) {
        return new int[]{rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, alpha & 0xFF};
    }
}

