/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe.chain;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemSorter;
import codechicken.nei.ItemStackAmount;
import codechicken.nei.ItemsTooltipLineHandler;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.bookmark.BookmarkItem;
import codechicken.nei.recipe.AutoCraftingManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.recipe.chain.RecipeChainMath;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class RecipeChainTooltipLineHandler
implements GuiDraw.ITooltipLineHandler {
    public final int groupId;
    public final boolean crafting;
    protected final RecipeChainMath math;
    protected final List<BookmarkItem> initialItems;
    protected final Map<Recipe.RecipeId, Long> outputRecipes;
    protected ItemsTooltipLineHandler available;
    protected ItemsTooltipLineHandler inputs;
    protected ItemsTooltipLineHandler outputs;
    protected ItemsTooltipLineHandler remainder;
    protected boolean lastShiftKey = false;
    protected boolean lastControlKey = false;
    protected Dimension size = new Dimension();

    public RecipeChainTooltipLineHandler(int groupId, boolean crafting, RecipeChainMath math) {
        this.groupId = groupId;
        this.crafting = crafting;
        this.math = math;
        this.initialItems = new ArrayList<BookmarkItem>(this.math.initialItems);
        this.outputRecipes = new HashMap<Recipe.RecipeId, Long>(this.math.outputRecipes);
    }

    private void onUpdate() {
        ArrayList<ItemStack> available = new ArrayList<ItemStack>();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> remainder = new ArrayList<ItemStack>();
        ItemStackAmount inventory = new ItemStackAmount();
        GuiContainer currentGui = NEIClientUtils.getGuiContainer();
        if (this.lastShiftKey && !(currentGui instanceof GuiRecipe)) {
            inventory.putAll(AutoCraftingManager.getInventoryItems(currentGui));
        }
        if (!this.math.outputRecipes.isEmpty()) {
            this.math.initialItems.clear();
            this.math.outputRecipes.clear();
            this.math.outputRecipes.putAll(this.outputRecipes);
            if (this.lastShiftKey) {
                if (!this.lastControlKey) {
                    List<ItemStack> items = inventory.values();
                    for (BookmarkItem item : this.math.recipeResults) {
                        if (item.factor <= 0L || !this.math.outputRecipes.containsKey(item.recipeId)) continue;
                        long amount = 0L;
                        for (ItemStack stack2 : items) {
                            if (stack2 == null || !NEIClientUtils.areStacksSameTypeCraftingWithNBT(stack2, item.itemStack)) continue;
                            amount += (long)StackInfo.getAmount(stack2);
                        }
                        if (amount < item.amount) continue;
                        long itemAmount = item.factor * this.math.outputRecipes.get(item.recipeId);
                        if (itemAmount > 0L) {
                            amount += itemAmount - amount % itemAmount;
                        }
                        this.math.outputRecipes.put(item.recipeId, Math.max(this.math.outputRecipes.get(item.recipeId), amount / item.factor));
                    }
                }
                for (ItemStack stack3 : inventory.values()) {
                    this.math.initialItems.add(BookmarkItem.of(-1, stack3.func_77946_l()));
                }
            } else {
                this.math.initialItems.addAll(this.initialItems);
            }
            this.math.refresh();
            for (BookmarkItem item : this.math.initialItems) {
                long amount = this.math.requiredAmount.getOrDefault(item, 0L);
                if (amount <= 0L) continue;
                if (this.lastShiftKey) {
                    available.add(item.getItemStack(amount));
                    continue;
                }
                inputs.add(item.getItemStack(amount));
            }
            for (BookmarkItem item : this.math.recipeIngredients) {
                long amount = this.math.requiredAmount.containsKey(this.math.preferredItems.get(item)) ? 0L : this.math.requiredAmount.getOrDefault(item, item.amount);
                if (amount <= 0L) continue;
                inputs.add(item.getItemStack(amount));
            }
            for (BookmarkItem item : this.math.recipeResults) {
                long amount = item.amount - this.math.requiredAmount.getOrDefault(item, 0L);
                if (amount <= 0L) continue;
                if (this.math.outputRecipes.containsKey(item.recipeId)) {
                    outputs.add(item.getItemStack(amount));
                    continue;
                }
                if (!this.lastShiftKey) continue;
                remainder.add(item.getItemStack(amount));
            }
            if (this.lastShiftKey) {
                for (ItemStack stack3 : this.math.containerItems) {
                    if (stack3 == null) continue;
                    remainder.add(stack3.func_77946_l());
                }
            }
        } else if (this.lastShiftKey) {
            for (BookmarkItem item : this.math.initialItems) {
                if (inventory.contains(item.itemStack)) {
                    long invAmount = inventory.get(item.itemStack) * (long)item.fluidCellAmount;
                    if (item.amount - invAmount > 0L) {
                        inputs.add(item.getItemStack(item.amount - invAmount));
                    }
                    if (Math.min(item.amount, invAmount) <= 0L) continue;
                    available.add(item.getItemStack(Math.min(item.amount, invAmount)));
                    continue;
                }
                inputs.add(item.getItemStack());
            }
        }
        inputs.sort(Comparator.comparing(stack -> StackInfo.getFluid(stack) != null).thenComparingInt(stack -> -1 * stack.field_77994_a).thenComparing(ItemSorter.instance));
        outputs.sort(Comparator.comparing(stack -> StackInfo.getFluid(stack) != null).thenComparingInt(stack -> -1 * stack.field_77994_a).thenComparing(ItemSorter.instance));
        remainder.sort(Comparator.comparing(stack -> StackInfo.getFluid(stack) != null).thenComparingInt(stack -> -1 * stack.field_77994_a).thenComparing(ItemSorter.instance));
        this.inputs = new ItemsTooltipLineHandler(this.lastShiftKey ? NEIClientUtils.translate("bookmark.crafting_chain.missing", new Object[0]) : NEIClientUtils.translate("bookmark.crafting_chain.input", new Object[0]), inputs, true, Integer.MAX_VALUE);
        this.available = new ItemsTooltipLineHandler(NEIClientUtils.translate("bookmark.crafting_chain.available", new Object[0]), available, true, Integer.MAX_VALUE);
        this.outputs = new ItemsTooltipLineHandler(NEIClientUtils.translate("bookmark.crafting_chain.output", new Object[0]), outputs, true, Integer.MAX_VALUE);
        this.remainder = new ItemsTooltipLineHandler(NEIClientUtils.translate("bookmark.crafting_chain.remainder", new Object[0]), remainder, true, Integer.MAX_VALUE);
        if (this.lastShiftKey) {
            this.inputs.setLabelColor(EnumChatFormatting.RED);
            this.available.setLabelColor(EnumChatFormatting.GREEN);
        }
        if (!(this.inputs.isEmpty() && this.outputs.isEmpty() && this.remainder.isEmpty() && this.available.isEmpty())) {
            if (!this.math.outputRecipes.isEmpty()) {
                this.size.height = 2 + GuiDraw.fontRenderer.field_78288_b;
            }
            this.size.width = Math.max(this.inputs.getSize().width, Math.max(this.outputs.getSize().width, Math.max(this.remainder.getSize().width, this.available.getSize().width)));
            this.size.height += this.inputs.getSize().height + this.outputs.getSize().height + this.remainder.getSize().height + this.available.getSize().height;
        } else {
            this.size.width = 0;
            this.size.height = 0;
        }
    }

    public Dimension getSize() {
        boolean update = this.outputs == null;
        this.lastShiftKey = NEIClientUtils.shiftKey();
        update = this.lastShiftKey != this.lastShiftKey || update;
        this.lastControlKey = NEIClientUtils.controlKey();
        boolean bl = update = this.lastControlKey != this.lastControlKey || update;
        if (update) {
            this.onUpdate();
        }
        return this.size;
    }

    public void draw(int x, int y) {
        if (this.size.height == 0) {
            return;
        }
        if (!this.math.outputRecipes.isEmpty()) {
            GuiDraw.fontRenderer.func_78261_a(EnumChatFormatting.AQUA + NEIClientUtils.translate("bookmark.crafting_chain", new Object[0]), x, y + 2, -296397483);
            y += 2 + GuiDraw.fontRenderer.field_78288_b;
        }
        if (NEIClientConfig.recipeChainDir() == 0) {
            if (!this.inputs.isEmpty()) {
                this.inputs.draw(x, y);
                y += this.inputs.getSize().height;
            }
            if (!this.available.isEmpty()) {
                this.available.draw(x, y);
                y += this.available.getSize().height;
            }
            if (!this.outputs.isEmpty()) {
                this.outputs.draw(x, y);
                y += this.outputs.getSize().height;
            }
        } else {
            if (!this.outputs.isEmpty()) {
                this.outputs.draw(x, y);
                y += this.outputs.getSize().height;
            }
            if (!this.inputs.isEmpty()) {
                this.inputs.draw(x, y);
                y += this.inputs.getSize().height;
            }
            if (!this.available.isEmpty()) {
                this.available.draw(x, y);
                y += this.available.getSize().height;
            }
        }
        if (!this.remainder.isEmpty()) {
            this.remainder.draw(x, y);
        }
    }
}

