/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.math.MathHelper;
import codechicken.nei.KeyManager;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIModContainer;
import cpw.mods.fml.relauncher.ReflectionHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.opengl.GL11;

public class WorldOverlayRenderer
implements KeyManager.IKeyStateTracker {
    public static int chunkOverlay = 0;
    public static int mobOverlay = 0;
    private static byte[] mobSpawnCache;
    private static long mobOverlayUpdateTime;
    private static String oregenPatternName;
    private static final Entity dummyEntity;
    private static final AxisAlignedBB aabb;

    public static void reset() {
        mobOverlay = 0;
        chunkOverlay = 0;
        oregenPatternName = null;
    }

    @Override
    public void tickKeyStates() {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        if (KeyManager.keyStates.get((Object)"world.moboverlay").down) {
            mobOverlay = (mobOverlay + 1) % 2;
            NEIClientUtils.printChatMessage((IChatComponent)new ChatComponentText(NEIClientUtils.translate("chat.moboverlay." + mobOverlay, new Object[0])));
        }
        if (KeyManager.keyStates.get((Object)"world.chunkoverlay").down) {
            chunkOverlay = (chunkOverlay + 1) % (NEIModContainer.isGT5Loaded() ? 4 : 3);
            NEIClientUtils.printChatMessage((IChatComponent)new ChatComponentText(NEIClientUtils.translate("chat.chunkoverlay." + chunkOverlay, new Object[0])));
        }
    }

    public static void render(float frame) {
        GL11.glPushMatrix();
        EntityLivingBase entity = Minecraft.func_71410_x().field_71451_h;
        double interpPosX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)frame;
        double interpPosY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)frame;
        double interpPosZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)frame;
        int intOffsetX = (int)interpPosX;
        int intOffsetY = (int)interpPosY;
        int intOffsetZ = (int)interpPosZ;
        GL11.glTranslated((double)(-interpPosX + (double)intOffsetX), (double)(-interpPosY + (double)intOffsetY), (double)(-interpPosZ + (double)intOffsetZ));
        WorldOverlayRenderer.renderChunkBounds((Entity)entity, intOffsetX, intOffsetY, intOffsetZ);
        WorldOverlayRenderer.renderMobSpawnOverlay((Entity)entity, intOffsetX, intOffsetY, intOffsetZ);
        GL11.glPopMatrix();
    }

    private static void buildMobSpawnOverlay(Entity entity) {
        if (mobSpawnCache == null) {
            mobSpawnCache = new byte[35937];
        }
        World world = entity.field_70170_p;
        int worldHeight = world.func_72800_K();
        int x1 = (int)entity.field_70165_t;
        int z1 = (int)entity.field_70161_v;
        int y1 = (int)MathHelper.clip((double)entity.field_70163_u, (double)16.0, (double)(worldHeight - 16));
        for (int i = 0; i <= 32; ++i) {
            int x = x1 - 16 + i;
            block1: for (int j = 0; j <= 32; ++j) {
                int z = z1 - 16 + j;
                int bufIndex = (i * 33 + j) * 33;
                Chunk chunk = world.func_72938_d(x, z);
                BiomeGenBase biome = world.func_72807_a(x, z);
                if (biome.func_76747_a(EnumCreatureType.monster).isEmpty() || biome.func_76741_f() <= 0.0f) {
                    WorldOverlayRenderer.mobSpawnCache[bufIndex] = -1;
                    continue;
                }
                int maxHeight = chunk.field_76637_e.func_72976_f(x, z);
                for (int k = 0; k <= 32; ++k) {
                    int y = y1 - 16 + k;
                    if (y >= worldHeight) {
                        WorldOverlayRenderer.mobSpawnCache[bufIndex + k] = -1;
                        continue;
                    }
                    if (y > maxHeight) {
                        WorldOverlayRenderer.mobSpawnCache[bufIndex + k] = -1;
                        continue block1;
                    }
                    WorldOverlayRenderer.mobSpawnCache[bufIndex + k] = WorldOverlayRenderer.getSpawnMode(chunk, x, y, z);
                }
            }
        }
    }

    private static void renderMobSpawnOverlay(Entity entity, int intOffsetX, int intOffsetY, int intOffsetZ) {
        if (mobOverlay == 0) {
            if (mobSpawnCache != null) {
                mobSpawnCache = null;
            }
            return;
        }
        long worldTime = entity.field_70170_p.func_82737_E();
        if (mobSpawnCache == null || mobOverlayUpdateTime != worldTime) {
            mobOverlayUpdateTime = worldTime;
            WorldOverlayRenderer.buildMobSpawnOverlay(entity);
        }
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glLineWidth((float)1.5f);
        byte curSpawnMode = 2;
        World world = entity.field_70170_p;
        int x1 = (int)entity.field_70165_t - intOffsetX;
        int z1 = (int)entity.field_70161_v - intOffsetZ;
        int y1 = (int)MathHelper.clip((double)entity.field_70163_u, (double)16.0, (double)(world.func_72800_K() - 16)) - intOffsetY;
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78371_b(1);
        tess.func_78376_a(255, 0, 0);
        for (int i = 0; i <= 32; ++i) {
            int x = x1 - 16 + i;
            block1: for (int j = 0; j <= 32; ++j) {
                int z = z1 - 16 + j;
                int cacheIndex = (i * 33 + j) * 33;
                for (int k = 0; k <= 32; ++k) {
                    int y = y1 - 16 + k;
                    byte spawnMode = mobSpawnCache[cacheIndex + k];
                    if (spawnMode == 0) continue;
                    if (spawnMode == -1) continue block1;
                    if (spawnMode != curSpawnMode) {
                        if (spawnMode == 1) {
                            tess.func_78376_a(255, 255, 0);
                        } else {
                            tess.func_78376_a(255, 0, 0);
                        }
                        curSpawnMode = spawnMode;
                    }
                    tess.func_78377_a((double)x, (double)y + 0.02, (double)z);
                    tess.func_78377_a((double)(x + 1), (double)y + 0.02, (double)(z + 1));
                    tess.func_78377_a((double)(x + 1), (double)y + 0.02, (double)z);
                    tess.func_78377_a((double)x, (double)y + 0.02, (double)(z + 1));
                }
            }
        }
        tess.func_78381_a();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private static byte getSpawnMode(Chunk chunk, int x, int y, int z) {
        if (y >= chunk.field_76637_e.func_72800_K()) {
            return 0;
        }
        if (chunk.func_76614_a(EnumSkyBlock.Block, x & 0xF, y, z & 0xF) >= 8 || !SpawnerAnimals.func_77190_a((EnumCreatureType)EnumCreatureType.monster, (World)chunk.field_76637_e, (int)x, (int)y, (int)z)) {
            return 0;
        }
        WorldOverlayRenderer.aabb.field_72340_a = (double)x + 0.2;
        WorldOverlayRenderer.aabb.field_72336_d = (double)x + 0.8;
        WorldOverlayRenderer.aabb.field_72338_b = (double)y + 0.01;
        WorldOverlayRenderer.aabb.field_72337_e = (double)y + 1.8;
        WorldOverlayRenderer.aabb.field_72339_c = (double)z + 0.2;
        WorldOverlayRenderer.aabb.field_72334_f = (double)z + 0.8;
        if (!chunk.field_76637_e.func_72945_a(dummyEntity, aabb).isEmpty() || chunk.field_76637_e.func_72953_d(aabb)) {
            return 0;
        }
        return (byte)(chunk.func_76614_a(EnumSkyBlock.Sky, x & 0xF, y, z & 0xF) >= 8 ? 1 : 2);
    }

    private static void renderChunkBounds(Entity entity, int intOffsetX, int intOffsetY, int intOffsetZ) {
        if (chunkOverlay == 0) {
            return;
        }
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glLineWidth((float)1.5f);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78371_b(1);
        for (int cx = -4; cx <= 4; ++cx) {
            for (int cz = -4; cz <= 4; ++cz) {
                int gz1;
                int gx1;
                double x1 = (entity.field_70176_ah + cx << 4) - intOffsetX;
                double z1 = (entity.field_70164_aj + cz << 4) - intOffsetZ;
                double x2 = x1 + 16.0;
                double z2 = z1 + 16.0;
                double dy = 128.0;
                double y1 = Math.floor(entity.field_70163_u - dy / 2.0);
                double y2 = y1 + dy;
                if (y1 < 0.0) {
                    y1 = 0.0;
                    y2 = dy;
                }
                if (y1 > (double)entity.field_70170_p.func_72800_K()) {
                    y2 = entity.field_70170_p.func_72800_K();
                    y1 = y2 - dy;
                }
                y1 -= (double)intOffsetY;
                y2 -= (double)intOffsetY;
                double dist = Math.pow(1.5, -(cx * cx + cz * cz));
                tess.func_78369_a(0.9f, 0.0f, 0.0f, (float)dist);
                if (cx >= 0 && cz >= 0) {
                    tess.func_78377_a(x2, y1, z2);
                    tess.func_78377_a(x2, y2, z2);
                }
                if (cx >= 0 && cz <= 0) {
                    tess.func_78377_a(x2, y1, z1);
                    tess.func_78377_a(x2, y2, z1);
                }
                if (cx <= 0 && cz >= 0) {
                    tess.func_78377_a(x1, y1, z2);
                    tess.func_78377_a(x1, y2, z2);
                }
                if (cx <= 0 && cz <= 0) {
                    tess.func_78377_a(x1, y1, z1);
                    tess.func_78377_a(x1, y2, z1);
                }
                if (cx != 0 || cz != 0) continue;
                if (chunkOverlay == 2) {
                    dy = 32.0;
                    y1 = Math.floor(entity.field_70163_u - dy / 2.0);
                    y2 = y1 + dy;
                    if (y1 < 0.0) {
                        y1 = 0.0;
                        y2 = dy;
                    }
                    if (y1 > (double)entity.field_70170_p.func_72800_K()) {
                        y2 = entity.field_70170_p.func_72800_K();
                        y1 = y2 - dy;
                    }
                    y2 -= (double)intOffsetY;
                    tess.func_78369_a(0.0f, 0.9f, 0.0f, 0.4f);
                    for (double y = (double)((int)(y1 -= (double)intOffsetY)); y <= y2; y += 1.0) {
                        tess.func_78377_a(x2, y, z1);
                        tess.func_78377_a(x2, y, z2);
                        tess.func_78377_a(x1, y, z1);
                        tess.func_78377_a(x1, y, z2);
                        tess.func_78377_a(x1, y, z2);
                        tess.func_78377_a(x2, y, z2);
                        tess.func_78377_a(x1, y, z1);
                        tess.func_78377_a(x2, y, z1);
                    }
                    for (double h = 1.0; h <= 15.0; h += 1.0) {
                        tess.func_78377_a(x1 + h, y1, z1);
                        tess.func_78377_a(x1 + h, y2, z1);
                        tess.func_78377_a(x1 + h, y1, z2);
                        tess.func_78377_a(x1 + h, y2, z2);
                        tess.func_78377_a(x1, y1, z1 + h);
                        tess.func_78377_a(x1, y2, z1 + h);
                        tess.func_78377_a(x2, y1, z1 + h);
                        tess.func_78377_a(x2, y2, z1 + h);
                    }
                    continue;
                }
                if (chunkOverlay != 3) continue;
                if (WorldOverlayRenderer.getOregenPatternName().equals("EQUAL_SPACING")) {
                    gx1 = (Math.floorDiv(entity.field_70176_ah, 3) * 3 << 4) - intOffsetX;
                    gz1 = (Math.floorDiv(entity.field_70164_aj, 3) * 3 << 4) - intOffsetZ;
                } else {
                    gx1 = ((entity.field_70176_ah < 0 ? entity.field_70176_ah - 3 : entity.field_70176_ah) / 3 * 3 << 4) - intOffsetX;
                    gz1 = ((entity.field_70164_aj < 0 ? entity.field_70164_aj - 3 : entity.field_70164_aj) / 3 * 3 << 4) - intOffsetZ;
                    if (entity.field_70176_ah < 0) {
                        gx1 += 16;
                    }
                    if (entity.field_70164_aj < 0) {
                        gz1 += 16;
                    }
                }
                int gx2 = gx1 + 48;
                int gz2 = gz1 + 48;
                tess.func_78369_a(0.0f, 0.9f, 0.0f, 0.4f);
                for (double y = (double)((int)y1); y <= y2; y += 1.0) {
                    tess.func_78377_a((double)gx2, y, (double)gz1);
                    tess.func_78377_a((double)gx2, y, (double)gz2);
                    tess.func_78377_a((double)gx1, y, (double)gz1);
                    tess.func_78377_a((double)gx1, y, (double)gz2);
                    tess.func_78377_a((double)gx1, y, (double)gz2);
                    tess.func_78377_a((double)gx2, y, (double)gz2);
                    tess.func_78377_a((double)gx1, y, (double)gz1);
                    tess.func_78377_a((double)gx2, y, (double)gz1);
                }
                for (double h = 4.0; h <= 44.0; h += 4.0) {
                    if (h % 16.0 == 0.0) continue;
                    tess.func_78377_a((double)gx1 + h, y1, (double)gz1);
                    tess.func_78377_a((double)gx1 + h, y2, (double)gz1);
                    tess.func_78377_a((double)gx1 + h, y1, (double)gz2);
                    tess.func_78377_a((double)gx1 + h, y2, (double)gz2);
                    tess.func_78377_a((double)gx1, y1, (double)gz1 + h);
                    tess.func_78377_a((double)gx1, y2, (double)gz1 + h);
                    tess.func_78377_a((double)gx2, y1, (double)gz1 + h);
                    tess.func_78377_a((double)gx2, y2, (double)gz1 + h);
                }
                tess.func_78369_a(0.0f, 0.0f, 0.9f, 0.4f);
                gx2 = (gx1 += 23) + 1;
                gz2 = (gz1 += 23) + 1;
                tess.func_78377_a((double)gx1, y1, (double)gz1);
                tess.func_78377_a((double)gx1, y2, (double)gz1);
                tess.func_78377_a((double)gx2, y1, (double)gz1);
                tess.func_78377_a((double)gx2, y2, (double)gz1);
                tess.func_78377_a((double)gx1, y1, (double)gz2);
                tess.func_78377_a((double)gx1, y2, (double)gz2);
                tess.func_78377_a((double)gx2, y1, (double)gz2);
                tess.func_78377_a((double)gx2, y2, (double)gz2);
            }
        }
        tess.func_78381_a();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private static String getOregenPatternName() {
        if (oregenPatternName == null) {
            try {
                ClassLoader loader = WorldOverlayRenderer.class.getClassLoader();
                Class gtWorldGenerator = ReflectionHelper.getClass((ClassLoader)loader, (String[])new String[]{"gregtech.common.GTWorldgenerator", "gregtech.common.GT_Worldgenerator"});
                oregenPatternName = ((Enum)gtWorldGenerator.getDeclaredField("oregenPattern").get(null)).name();
            }
            catch (Exception ignored) {
                oregenPatternName = "AXISSYMMETRICAL";
            }
        }
        return oregenPatternName;
    }

    public static void load() {
        KeyManager.trackers.add(new WorldOverlayRenderer());
    }

    static {
        dummyEntity = new EntityPig(null);
        aabb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }
}

