/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api.widget;

import com.cleanroommc.modularui.screen.ModularScreen;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;

public interface Interactable {
    public static final ResourceLocation PRESS_SOUND = new ResourceLocation("gui.button.press");

    @NotNull
    default public Result onMousePressed(int mouseButton) {
        return Result.ACCEPT;
    }

    default public boolean onMouseRelease(int mouseButton) {
        return false;
    }

    @NotNull
    default public Result onMouseTapped(int mouseButton) {
        return Result.IGNORE;
    }

    @NotNull
    default public Result onKeyPressed(char typedChar, int keyCode) {
        return Result.IGNORE;
    }

    default public boolean onKeyRelease(char typedChar, int keyCode) {
        return false;
    }

    @NotNull
    default public Result onKeyTapped(char typedChar, int keyCode) {
        return Result.IGNORE;
    }

    default public boolean onMouseScroll(ModularScreen.UpOrDown scrollDirection, int amount) {
        return false;
    }

    default public void onMouseDrag(int mouseButton, long timeSinceClick) {
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean hasControlDown() {
        return GuiScreen.func_146271_m();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean hasShiftDown() {
        return GuiScreen.func_146272_n();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean hasAltDown() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }

    public static boolean isKeyComboCtrlX(int keyID) {
        return keyID == 45 && Interactable.hasControlDown() && !Interactable.hasShiftDown() && !Interactable.hasAltDown();
    }

    public static boolean isKeyComboCtrlV(int keyID) {
        return keyID == 47 && Interactable.hasControlDown() && !Interactable.hasShiftDown() && !Interactable.hasAltDown();
    }

    public static boolean isKeyComboCtrlC(int keyID) {
        return keyID == 46 && Interactable.hasControlDown() && !Interactable.hasShiftDown() && !Interactable.hasAltDown();
    }

    public static boolean isKeyComboCtrlA(int keyID) {
        return keyID == 30 && Interactable.hasControlDown() && !Interactable.hasShiftDown() && !Interactable.hasAltDown();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isKeyPressed(int key) {
        return Keyboard.isKeyDown((int)key);
    }

    @SideOnly(value=Side.CLIENT)
    public static void playButtonClickSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)PRESS_SOUND, (float)1.0f));
    }

    public static enum Result {
        IGNORE(false, false),
        ACCEPT(true, false),
        STOP(false, true),
        SUCCESS(true, true);

        public final boolean accepts;
        public final boolean stops;

        private Result(boolean accepts, boolean stops) {
            this.accepts = accepts;
            this.stops = stops;
        }
    }
}

