/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.optimization.transformerproxy;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import makamys.coretweaks.CoreTweaks;
import makamys.coretweaks.api.IWrapper;
import makamys.coretweaks.optimization.transformerproxy.ITransformerWrapper;
import makamys.coretweaks.optimization.transformerproxy.NameTransformerProxy;
import makamys.coretweaks.optimization.transformerproxy.TransformerProxy;
import makamys.coretweaks.util.PluralUtil;
import makamys.coretweaks.util.WrappedAddListenableList;
import net.minecraft.launchwrapper.IClassNameTransformer;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class TransformerProxyManager
implements WrappedAddListenableList.AdditionEventListener<IClassTransformer> {
    public static TransformerProxyManager instance = new TransformerProxyManager();
    private boolean installedListener;
    private List<ITransformerWrapperProvider> listeners = new ArrayList<ITransformerWrapperProvider>();

    public void addAdditionListener(ITransformerWrapperProvider listener, boolean installListener) {
        this.listeners.add(0, listener);
        this.hookClassLoader(installListener);
    }

    public void hookClassLoader(boolean installListener) {
        try {
            LaunchClassLoader lcl = Launch.classLoader;
            Field transformersField = LaunchClassLoader.class.getDeclaredField("transformers");
            transformersField.setAccessible(true);
            List transformers = (List)transformersField.get(lcl);
            for (int i = 0; i < transformers.size(); ++i) {
                IClassTransformer proxy = this.createCachedProxy((IClassTransformer)transformers.get(i), true);
                if (proxy == null) continue;
                transformers.set(i, proxy);
            }
            if (installListener && !this.installedListener) {
                WrappedAddListenableList<IClassTransformer> wrappedTransformers = new WrappedAddListenableList<IClassTransformer>(transformers);
                wrappedTransformers.addListener(this);
                transformersField.set(lcl, wrappedTransformers);
                this.installedListener = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private IClassTransformer createCachedProxy(IClassTransformer transformer, boolean onlyFirst) {
        IClassTransformer realTransformer = transformer;
        while (realTransformer instanceof IWrapper) {
            realTransformer = (IClassTransformer)((IWrapper)realTransformer).getOriginal();
        }
        ArrayList<ITransformerWrapper> wrappers = new ArrayList<ITransformerWrapper>();
        for (ITransformerWrapperProvider l : onlyFirst ? Collections.singletonList(this.listeners.get(0)) : this.listeners) {
            ITransformerWrapper wrapper = l.wrap(realTransformer);
            if (wrapper == null) continue;
            wrappers.add(wrapper);
        }
        if (!wrappers.isEmpty()) {
            try {
                CoreTweaks.LOGGER.info("Replacing " + transformer.getClass().getCanonicalName() + " with " + PluralUtil.pluralizeCount(wrappers.size(), "wrapper") + ": " + wrappers.stream().map(x -> x.getClass().getSimpleName()).collect(Collectors.toList()));
                TransformerProxy newTransformer = transformer instanceof TransformerProxy ? (TransformerProxy)transformer : (transformer instanceof IClassNameTransformer ? NameTransformerProxy.of(transformer) : TransformerProxy.of(transformer));
                for (ITransformerWrapper wrapper : Lists.reverse(wrappers)) {
                    newTransformer.addWrapper(wrapper);
                }
                return transformer instanceof TransformerProxy ? null : newTransformer;
            }
            catch (Exception e) {
                CoreTweaks.LOGGER.error("Failed to create proxy class for " + realTransformer.getClass().getCanonicalName());
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void onAdd(WrappedAddListenableList.AdditionEvent<IClassTransformer> event) {
        IClassTransformer proxy = this.createCachedProxy((IClassTransformer)event.element, false);
        if (proxy != null) {
            event.element = proxy;
        }
    }

    public static interface ITransformerWrapperProvider {
        public ITransformerWrapper wrap(IClassTransformer var1);
    }
}

