/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.integration;

import com.github.lunatrius.ingameinfo.integration.Plugin;
import com.github.lunatrius.ingameinfo.reference.Reference;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.util.ArrayList;
import java.util.List;

public class PluginLoader {
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private static PluginLoader instance = null;

    public static PluginLoader getInstance() {
        if (instance == null) {
            instance = new PluginLoader();
        }
        return instance;
    }

    public void preInit(FMLPreInitializationEvent event) {
        String[] names;
        for (String name : names = new String[]{"com.github.lunatrius.ingameinfo.integration.bloodmagic.BloodMagic", "com.github.lunatrius.ingameinfo.integration.simplyjetpacks.SimplyJetpacks", "com.github.lunatrius.ingameinfo.integration.terrafirmacraft.TerraFirmaCraft", "com.github.lunatrius.ingameinfo.integration.thaumcraft.Thaumcraft", "com.github.lunatrius.ingameinfo.integration.gregtech.Gregtech"}) {
            try {
                Class<?> clazzPlugin;
                Plugin plugin;
                Class<?> clazz = Class.forName(name);
                if (!Plugin.class.isAssignableFrom(clazz) || !(plugin = (Plugin)(clazzPlugin = clazz).newInstance()).canLoad()) continue;
                this.plugins.add(plugin);
            }
            catch (ClassNotFoundException cnfe) {
                Reference.logger.error("{} not found, skipping...", new Object[]{name});
            }
            catch (InstantiationException ie) {
                Reference.logger.error("{} could not be created, skipping...", new Object[]{name});
            }
            catch (IllegalAccessException iae) {
                Reference.logger.error("{} could not be accessed, skipping...", new Object[]{name});
            }
        }
        if (this.plugins.size() > 0) {
            event.getModMetadata().description = event.getModMetadata().description + "\nCompiled against " + this.plugins;
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        for (Plugin plugin : this.plugins) {
            plugin.load();
            Reference.logger.debug("Loaded {} integration.", new Object[]{plugin.getDependencyName()});
        }
        instance = null;
    }
}

