/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world.mapgen.pyramid;

import de.katzenpapst.amunra.helper.CoordHelper;
import de.katzenpapst.amunra.world.mapgen.BaseStructureComponent;
import de.katzenpapst.amunra.world.mapgen.populator.TouchBlock;
import de.katzenpapst.amunra.world.mapgen.pyramid.Pyramid;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class PyramidRoom
extends BaseStructureComponent {
    protected StructureBoundingBox entranceBB;
    protected StructureBoundingBox roomBB;
    protected boolean placeGlowstoneInEdges = true;
    private boolean roomHeightFixed = false;
    protected int floorLevel;

    public void setBoundingBoxes(StructureBoundingBox entranceBB, StructureBoundingBox roomBB) {
        this.entranceBB = entranceBB;
        this.roomBB = roomBB;
        StructureBoundingBox totalBox = new StructureBoundingBox(roomBB);
        totalBox.func_78888_b(entranceBB);
        this.setStructureBoundingBox(totalBox);
    }

    public StructureBoundingBox getEntranceBB() {
        return this.entranceBB;
    }

    @Override
    public boolean generateChunk(int chunkX, int chunkZ, Block[] arrayOfIDs, byte[] arrayOfMeta) {
        StructureBoundingBox actualRoomBB;
        StructureBoundingBox chunkBB = CoordHelper.getChunkBB(chunkX, chunkZ);
        BlockMetaPair floorMat = ((Pyramid)this.parent).getFloorMaterial();
        this.floorLevel = this.parent.getGroundLevel() + 7;
        if (!this.roomHeightFixed) {
            this.roomBB.field_78895_b += this.floorLevel;
            this.roomBB.field_78894_e += this.floorLevel;
            this.roomHeightFixed = true;
        }
        if ((actualRoomBB = PyramidRoom.intersectBoundingBoxes(chunkBB, this.roomBB)) != null) {
            for (int x = actualRoomBB.field_78897_a; x <= actualRoomBB.field_78893_d; ++x) {
                for (int y = actualRoomBB.field_78895_b - 1; y <= actualRoomBB.field_78894_e; ++y) {
                    for (int z = actualRoomBB.field_78896_c; z <= actualRoomBB.field_78892_f; ++z) {
                        if (y >= actualRoomBB.field_78895_b) {
                            PyramidRoom.placeBlockAbs(arrayOfIDs, arrayOfMeta, x, y, z, chunkX, chunkZ, Blocks.field_150350_a, 0);
                            continue;
                        }
                        PyramidRoom.placeBlockAbs(arrayOfIDs, arrayOfMeta, x, y, z, chunkX, chunkZ, floorMat.getBlock(), floorMat.getMetadata());
                    }
                }
            }
        }
        this.entranceBB.field_78895_b = this.roomBB.field_78895_b;
        this.entranceBB.field_78894_e = this.entranceBB.field_78895_b + 3;
        this.makeEntrance(arrayOfIDs, arrayOfMeta, chunkBB, chunkX, chunkZ, floorMat);
        if (this.placeGlowstoneInEdges) {
            this.drawCornerColumns(actualRoomBB.field_78895_b, actualRoomBB.field_78894_e, chunkX, chunkZ, arrayOfIDs, arrayOfMeta);
        }
        return true;
    }

    protected void drawCornerColumns(int yMin, int yMax, int chunkX, int chunkZ, Block[] arrayOfIDs, byte[] arrayOfMeta) {
        for (int y = yMin; y <= yMax; ++y) {
            if (PyramidRoom.placeBlockAbs(arrayOfIDs, arrayOfMeta, this.roomBB.field_78897_a, y, this.roomBB.field_78896_c, chunkX, chunkZ, Blocks.field_150426_aN, 0) && y == yMin) {
                this.parent.addPopulator(new TouchBlock(this.roomBB.field_78897_a, y, this.roomBB.field_78896_c));
            }
            if (PyramidRoom.placeBlockAbs(arrayOfIDs, arrayOfMeta, this.roomBB.field_78893_d, y, this.roomBB.field_78896_c, chunkX, chunkZ, Blocks.field_150426_aN, 0) && y == yMin) {
                this.parent.addPopulator(new TouchBlock(this.roomBB.field_78893_d, y, this.roomBB.field_78896_c));
            }
            if (PyramidRoom.placeBlockAbs(arrayOfIDs, arrayOfMeta, this.roomBB.field_78897_a, y, this.roomBB.field_78892_f, chunkX, chunkZ, Blocks.field_150426_aN, 0) && y == yMin) {
                this.parent.addPopulator(new TouchBlock(this.roomBB.field_78897_a, y, this.roomBB.field_78892_f));
            }
            if (!PyramidRoom.placeBlockAbs(arrayOfIDs, arrayOfMeta, this.roomBB.field_78893_d, y, this.roomBB.field_78892_f, chunkX, chunkZ, Blocks.field_150426_aN, 0) || y != yMin) continue;
            this.parent.addPopulator(new TouchBlock(this.roomBB.field_78893_d, y, this.roomBB.field_78892_f));
        }
    }

    protected void makeEntrance(Block[] arrayOfIDs, byte[] arrayOfMeta, StructureBoundingBox chunkBB, int chunkX, int chunkZ, BlockMetaPair floorMat) {
        StructureBoundingBox entrBoxIntersect = PyramidRoom.intersectBoundingBoxes(this.entranceBB, chunkBB);
        if (entrBoxIntersect != null) {
            for (int x = entrBoxIntersect.field_78897_a; x <= entrBoxIntersect.field_78893_d; ++x) {
                for (int y = entrBoxIntersect.field_78895_b - 1; y <= entrBoxIntersect.field_78894_e; ++y) {
                    for (int z = entrBoxIntersect.field_78896_c; z <= entrBoxIntersect.field_78892_f; ++z) {
                        if (y >= entrBoxIntersect.field_78895_b) {
                            PyramidRoom.placeBlockAbs(arrayOfIDs, arrayOfMeta, x, y, z, chunkX, chunkZ, Blocks.field_150350_a, 0);
                            continue;
                        }
                        PyramidRoom.placeBlockAbs(arrayOfIDs, arrayOfMeta, x, y, z, chunkX, chunkZ, floorMat.getBlock(), floorMat.getMetadata());
                    }
                }
            }
        }
    }
}

