/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.MultiPartRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gcewing.projectblue.BaseModClient;
import gcewing.projectblue.IPBRenderer;
import gcewing.projectblue.ItemMultiPartJ;
import gcewing.projectblue.ItemRendererBase;
import gcewing.projectblue.JCuboidFacePart;
import gcewing.projectblue.PBDynamicRenderer;
import gcewing.projectblue.PBStaticRenderer;
import gcewing.projectblue.Trans3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class PBFacePart
extends JCuboidFacePart {
    public String type;
    public int side;
    public int rot;

    public static Cuboid6[] newBounds(double x0, double y0, double z0, double x1, double y1, double z1) {
        Cuboid6[] bounds = new Cuboid6[6];
        for (int i = 0; i < 6; ++i) {
            Transformation t = Rotation.sideRotations[i].at(Vector3.center);
            bounds[i] = new Cuboid6(x0, y0, z0, x1, y1, z1).apply(t);
        }
        return bounds;
    }

    protected PBFacePart() {
    }

    public String getType() {
        return this.type;
    }

    public Cuboid6 getBounds() {
        return this.getBoundsArray()[this.side];
    }

    public abstract Cuboid6[] getBoundsArray();

    public int getSlotMask() {
        return 1 << this.side;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister reg) {
    }

    public boolean renderStatic(Vector3 pos, int pass) {
        return this.renderStatic(this.transformation(pos.x, pos.y, pos.z), pass, new PBStaticRenderer(this));
    }

    public void renderDynamic(Vector3 pos, float frame, int pass) {
        this.renderDynamic(this.transformation(pos.x, pos.y, pos.z), frame, pass, new PBDynamicRenderer());
    }

    public Trans3 transformation(double x, double y, double z) {
        return new Trans3(x + 0.5, y + 0.5, z + 0.5).side(this.side);
    }

    public void renderStack(ItemStack stack, IItemRenderer.ItemRenderType type) {
        this.renderStack(this.transformation(0.0, 0.0, 0.0), stack, type, new PBDynamicRenderer());
    }

    public boolean renderStatic(Trans3 t, int pass, IPBRenderer r) {
        return false;
    }

    public void renderDynamic(Trans3 t, float frame, int pass, IPBRenderer r) {
    }

    public void renderStack(Trans3 t, ItemStack stack, IItemRenderer.ItemRenderType type, IPBRenderer r) {
        this.renderStatic(t, 0, r);
    }

    public void writeDesc(MCDataOutput data) {
        data.writeByte(this.side);
        data.writeByte(this.rot);
    }

    public void readDesc(MCDataInput data) {
        this.side = data.readByte();
        this.rot = data.readByte();
    }

    public void save(NBTTagCompound nbt) {
        nbt.func_74768_a("side", this.side);
        nbt.func_74768_a("rot", this.rot);
    }

    public void load(NBTTagCompound nbt) {
        this.side = nbt.func_74762_e("side");
        this.rot = nbt.func_74762_e("rot");
    }

    public TileEntity getAdjacentTileEntity() {
        ForgeDirection d = ForgeDirection.getOrientation((int)this.side);
        return this.world().func_147438_o(this.x() + d.offsetX, this.y() + d.offsetY, this.z() + d.offsetZ);
    }

    public void markDirty() {
        this.tile().func_70296_d();
    }

    public void changed() {
        this.markDirty();
        this.sendDescUpdate();
    }

    public static class ItemRenderer
    extends ItemRendererBase {
        FaceItem item;

        public ItemRenderer(FaceItem item) {
            this.item = item;
        }

        @Override
        void renderStack(ItemStack stack, IItemRenderer.ItemRenderType type) {
            this.item.proxy.renderStack(stack, type);
        }
    }

    public static class FaceItem
    extends ItemMultiPartJ {
        static List<FaceItem> instances = new ArrayList<FaceItem>();
        Factory factory;
        PBFacePart proxy;

        public FaceItem(Factory factory) {
            this.factory = factory;
            this.proxy = factory.createPart(0, 0);
            instances.add(this);
        }

        public static void registerRenderers(BaseModClient client) {
            for (FaceItem item : instances) {
                client.addItemRenderer(item, (IItemRenderer)new ItemRenderer(item));
            }
        }

        public int func_94901_k() {
            return 0;
        }

        @SideOnly(value=Side.CLIENT)
        public void func_94581_a(IIconRegister reg) {
            this.proxy.registerIcons(reg);
        }

        @Override
        public PBFacePart newPart(ItemStack stack, EntityPlayer player, World world, BlockCoord pos, int sideHit, Vector3 vhit) {
            int side = sideHit ^ 1;
            int rot = Trans3.turnFor((Entity)player, side);
            return this.factory.createPart(side, rot);
        }
    }

    public static class Factory
    implements MultiPartRegistry.IPartFactory {
        String type;
        Class<? extends PBFacePart> cls;

        public Factory(Class<? extends PBFacePart> cls, String type) {
            this.type = type;
            this.cls = cls;
        }

        public PBFacePart createPart(String name, boolean client) {
            return this.createPart(0, 0);
        }

        public PBFacePart createPart(int side, int rot) {
            try {
                PBFacePart part = this.cls.newInstance();
                part.type = this.type;
                part.side = side;
                part.rot = rot;
                return part;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

