/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget.textfield;

import com.gtnewhorizon.gtnhlib.util.parsing.MathExpressionParser;
import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.GuiHelper;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.widget.ISyncedWidget;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.common.widget.textfield.BaseTextFieldWidget;
import java.awt.Point;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import java.util.regex.Pattern;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.MathHelper;

public class NumericWidget
extends BaseTextFieldWidget
implements ISyncedWidget {
    private double value = 0.0;
    private DoubleSupplier getter;
    private DoubleConsumer setter;
    private DoubleUnaryOperator validator;
    private double minValue = 0.0;
    private double maxValue = Double.POSITIVE_INFINITY;
    private double defaultValue = 0.0;
    private double scrollStep = 1.0;
    private double scrollStepCtrl = 0.1;
    private double scrollStepShift = 100.0;
    private boolean integerOnly = true;
    private NumberFormat numberFormat;
    private MathExpressionParser.Context ctx;
    private static final int MAX_FRACTION_DIGITS = 4;
    private static final Pattern NUMBER_PATTERN = Pattern.compile("-?[0-9., \u202f_\u2019]*");
    private boolean needsUpdate;
    private boolean syncsToServer = true;
    private boolean syncsToClient = true;

    public NumericWidget() {
        this.setTextAlignment(Alignment.CenterLeft);
        this.handler.setMaxLines(1);
        this.numberFormat = new NumberFormatMUI();
        this.numberFormat.setMaximumFractionDigits(4);
        if (ModularUI.isGTNHLibLoaded) {
            this.handler.setPattern(MathExpressionParser.EXPRESSION_PATTERN);
            this.ctx = new MathExpressionParser.Context();
            this.ctx.setNumberFormat(this.numberFormat);
        } else {
            this.handler.setPattern(NUMBER_PATTERN);
        }
    }

    @Override
    public void draw(float partialTicks) {
        Point draggableTranslate = this.getDraggableTranslate();
        GuiHelper.useScissor(this.pos.x + draggableTranslate.x, this.pos.y + draggableTranslate.y, this.size.width, this.size.height, () -> {
            GlStateManager.pushMatrix();
            GlStateManager.translate(1.0f, 1.0f, 0.0f);
            this.renderer.setSimulate(false);
            this.renderer.setScale(this.scale);
            this.renderer.setAlignment(this.textAlignment, this.size.width - 2, this.size.height - 2);
            this.renderer.draw(this.handler.getText());
            GlStateManager.popMatrix();
        });
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double newValue) {
        this.value = newValue;
        String displayValue = this.numberFormat.format(this.value);
        if (this.handler.getText().isEmpty()) {
            this.handler.getText().add(displayValue);
        } else {
            this.handler.getText().set(0, displayValue);
        }
    }

    private boolean validateAndSetValue(double newValue) {
        newValue = MathHelper.func_151237_a((double)newValue, (double)this.minValue, (double)this.maxValue);
        if (this.integerOnly) {
            newValue = Math.round(newValue);
        }
        if (this.validator != null) {
            newValue = this.validator.applyAsDouble(newValue);
        }
        boolean changed = newValue != this.value;
        this.setValue(newValue);
        return changed;
    }

    private double parseValueFromTextField() {
        if (this.handler.getText().isEmpty()) {
            this.handler.getText().add("");
        }
        if (this.handler.getText().size() > 1) {
            throw new IllegalStateException("NumericWidget can only have one line!");
        }
        if (ModularUI.isGTNHLibLoaded) {
            double newValue = MathExpressionParser.parse((String)this.handler.getText().get(0), (MathExpressionParser.Context)this.ctx);
            return this.ctx.wasSuccessful() ? newValue : this.value;
        }
        if (this.handler.getText().get(0) == null || this.handler.getText().get(0).isEmpty()) {
            return this.defaultValue;
        }
        try {
            return this.numberFormat.parse(this.handler.getText().get(0)).doubleValue();
        }
        catch (ParseException ignore) {
            return this.value;
        }
    }

    public NumericWidget setMinValue(double minValue) {
        this.minValue = minValue;
        return this;
    }

    public NumericWidget setMaxValue(double maxValue) {
        this.maxValue = maxValue;
        if (ModularUI.isGTNHLibLoaded) {
            this.ctx.setHundredPercent(maxValue);
        }
        return this;
    }

    public NumericWidget setBounds(double minValue, double maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        if (ModularUI.isGTNHLibLoaded) {
            this.ctx.setHundredPercent(maxValue);
        }
        return this;
    }

    public NumericWidget setDefaultValue(double defaultValue) {
        this.defaultValue = defaultValue;
        if (ModularUI.isGTNHLibLoaded) {
            this.ctx.setDefaultValue(defaultValue);
        }
        return this;
    }

    public NumericWidget setScrollValues(double baseStep, double ctrlStep, double shiftStep) {
        this.scrollStep = baseStep;
        this.scrollStepCtrl = ctrlStep;
        this.scrollStepShift = shiftStep;
        return this;
    }

    public NumericWidget setIntegerOnly(boolean integerOnly) {
        this.integerOnly = integerOnly;
        return this;
    }

    public NumericWidget setPlainOnly(boolean plainOnly) {
        if (ModularUI.isGTNHLibLoaded) {
            this.ctx.setPlainOnly(plainOnly);
            this.handler.setPattern(plainOnly ? NUMBER_PATTERN : MathExpressionParser.EXPRESSION_PATTERN);
        }
        return this;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public NumericWidget modifyNumberFormat(Consumer<NumberFormat> consumer) {
        consumer.accept(this.numberFormat);
        return this;
    }

    public NumericWidget setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        if (ModularUI.isGTNHLibLoaded) {
            this.ctx.setNumberFormat(numberFormat);
        }
        return this;
    }

    public NumericWidget setGetter(DoubleSupplier getter) {
        this.getter = getter;
        return this;
    }

    public NumericWidget setSetter(DoubleConsumer setter) {
        this.setter = setter;
        return this;
    }

    public NumericWidget setValidator(DoubleUnaryOperator validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void onRemoveFocus() {
        super.onRemoveFocus();
        double newValue = this.parseValueFromTextField();
        if (this.validateAndSetValue(newValue)) {
            if (this.setter != null) {
                this.setter.accept(this.value);
            }
            if (this.syncsToServer()) {
                this.syncToServer(1, buffer -> buffer.writeDouble(this.value));
            }
        }
    }

    @Override
    public boolean onMouseScroll(int direction) {
        if (!this.isFocused()) {
            return false;
        }
        double newValue = this.parseValueFromTextField();
        newValue = Interactable.hasControlDown() ? (newValue += (double)direction * this.scrollStepCtrl) : (Interactable.hasShiftDown() ? (newValue += (double)direction * this.scrollStepShift) : (newValue += (double)direction * this.scrollStep));
        if (this.validateAndSetValue(newValue)) {
            if (this.setter != null) {
                this.setter.accept(this.value);
            }
            if (this.syncsToServer()) {
                this.syncToServer(1, buffer -> buffer.writeDouble(this.value));
            }
        }
        return true;
    }

    public boolean syncsToClient() {
        return this.syncsToClient;
    }

    public boolean syncsToServer() {
        return this.syncsToServer;
    }

    public NumericWidget setSynced(boolean syncsToClient, boolean syncsToServer) {
        this.syncsToClient = syncsToClient;
        this.syncsToServer = syncsToServer;
        return this;
    }

    @Override
    public void detectAndSendChanges(boolean init) {
        double newValue;
        if (this.syncsToClient() && this.getter != null && (this.validateAndSetValue(newValue = this.getter.getAsDouble()) || init)) {
            this.syncToClient(1, buffer -> {
                buffer.writeBoolean(init);
                buffer.writeDouble(this.value);
            });
            this.markForUpdate();
        }
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) {
        boolean init;
        if (id == 1 && ((init = buf.readBoolean()) || !this.isFocused())) {
            this.validateAndSetValue(buf.readDouble());
            if (init) {
                this.lastText = new ArrayList<String>(this.handler.getText());
                if (this.focusOnGuiOpen) {
                    this.forceFocus();
                }
            }
            if (this.setter != null && (this.getter == null || this.getter.getAsDouble() != this.value)) {
                this.setter.accept(this.value);
            }
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) {
        if (id == 1 && this.validateAndSetValue(buf.readDouble())) {
            if (this.setter != null) {
                this.setter.accept(this.value);
            }
            this.markForUpdate();
        }
    }

    @Override
    public void markForUpdate() {
        this.needsUpdate = true;
    }

    @Override
    public void unMarkForUpdate() {
        this.needsUpdate = false;
    }

    @Override
    public boolean isMarkedForUpdate() {
        return this.needsUpdate;
    }
}

