/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.google.gson.JsonObject;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.drawable.TextRenderer;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.Theme;
import com.gtnewhorizons.modularui.common.widget.DynamicTextWidget;
import java.util.function.Supplier;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.NotNull;

public class TextWidget
extends Widget {
    private Text text;
    protected String localised;
    protected Supplier<Text> textSupplier = null;
    protected Integer defaultColor;
    protected EnumChatFormatting defaultFormat;
    private int maxWidth = -1;
    private Alignment textAlignment = Alignment.Center;
    private final TextRenderer textRenderer = new TextRenderer();
    protected boolean isDynamic = false;

    public TextWidget() {
        this(new Text(""));
    }

    public TextWidget(Text text) {
        this.text = text;
    }

    public TextWidget(String text) {
        this(new Text(text));
    }

    public static DynamicTextWidget dynamicText(Supplier<Text> supplier) {
        return new DynamicTextWidget(supplier);
    }

    public static DynamicTextWidget dynamicString(Supplier<String> supplier) {
        return new DynamicTextWidget(() -> new Text((String)supplier.get()));
    }

    public static TextWidget localised(String key, Object ... data) {
        return new TextWidget(Text.localised(key, data));
    }

    @Override
    public void readJson(JsonObject json, String type) {
        super.readJson(json, type);
    }

    @Override
    public void onRebuild() {
        if (this.localised == null) {
            this.localised = this.getText().getFormatted();
        }
    }

    @Override
    @NotNull
    protected Size determineSize(int maxWidth, int maxHeight) {
        this.localised = this.getText().getFormatted();
        int width = this.maxWidth > 0 ? this.maxWidth : maxWidth - this.getPos().x;
        this.textRenderer.setSimulate(true);
        this.textRenderer.setAlignment(this.textAlignment, width, maxHeight);
        this.textRenderer.draw(this.localised);
        this.textRenderer.setSimulate(false);
        return this.textRenderer.getLastSize().grow(1, 1);
    }

    @Override
    public void onScreenUpdate() {
        String l;
        if (this.textSupplier != null) {
            this.text = this.textSupplier.get();
            if (this.defaultColor != null) {
                this.text.color(this.defaultColor);
            }
            if (this.defaultFormat != null) {
                this.text.format(this.defaultFormat);
            }
        }
        if ((this.isDynamic || this.isAutoSized()) && !(l = this.getText().getFormatted()).equals(this.localised)) {
            this.checkNeedsRebuild();
            this.localised = l;
        }
    }

    @Override
    public void draw(float partialTicks) {
        Text text = this.getText();
        if (this.localised == null) {
            this.localised = text.getFormatted();
        }
        this.textRenderer.setPos(0, 0);
        this.textRenderer.setShadow(text.hasShadow());
        this.textRenderer.setAlignment(this.textAlignment, this.size.width, this.size.height);
        this.textRenderer.setColor(text.hasColor() ? text.getColor() : Theme.INSTANCE.getText());
        this.textRenderer.draw(this.localised);
    }

    public Text getText() {
        return this.text;
    }

    public TextWidget setTextSupplier(Supplier<Text> textSupplier) {
        this.textSupplier = textSupplier;
        this.isDynamic = textSupplier != null;
        return this;
    }

    public TextWidget setStringSupplier(Supplier<String> stringSupplier) {
        if (stringSupplier != null) {
            this.textSupplier = () -> new Text((String)stringSupplier.get());
            this.isDynamic = true;
        } else {
            this.isDynamic = false;
        }
        return this;
    }

    public TextWidget setDefaultColor(int color) {
        this.defaultColor = color;
        this.text.color(color);
        return this;
    }

    public TextWidget setDefaultColor(EnumChatFormatting color) {
        this.defaultFormat = color;
        this.text.format(color);
        return this;
    }

    public TextWidget setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public TextWidget setTextAlignment(Alignment textAlignment) {
        this.textAlignment = textAlignment;
        return this;
    }

    public TextWidget setScale(float scale) {
        this.textRenderer.setScale(scale);
        return this;
    }
}

