/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.load.gui;

import alexiil.mods.load.gui.FrameEditor;
import alexiil.mods.load.gui.GuiPreview;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FramePreview
extends JFrame {
    private JPanel contentPane;
    private JTextField textField;

    public FramePreview(final GuiPreview gui) {
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 450, 300);
        this.setTitle("Preview editor");
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        JPanel pnlButtons = new JPanel();
        this.contentPane.add((Component)pnlButtons, "South");
        pnlButtons.setLayout(new FlowLayout(1, 5, 5));
        JButton btnEditor = new JButton("Open Editor");
        pnlButtons.add(btnEditor);
        btnEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameEditor editor = new FrameEditor(gui);
                editor.setVisible(true);
            }
        });
        JButton btnClose = new JButton("Exit");
        pnlButtons.add(btnClose);
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                gui.close();
            }
        });
        JPanel pnlVariables = new JPanel();
        pnlVariables.setLayout(new BoxLayout(pnlVariables, 1));
        this.contentPane.add((Component)pnlVariables, "Center");
        JPanel pnlTextField = new JPanel();
        pnlVariables.add(pnlTextField);
        this.textField = new JTextField();
        this.textField.setColumns(30);
        this.textField.setToolTipText("message to display");
        this.textField.setText("Random Text");
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                gui.debugText = FramePreview.this.textField.getText();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                gui.debugText = FramePreview.this.textField.getText();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                gui.debugText = FramePreview.this.textField.getText();
            }
        });
        pnlTextField.add(this.textField);
        final JScrollBar scrollBar = new JScrollBar();
        scrollBar.setValue(20);
        scrollBar.setOrientation(0);
        scrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                gui.debugPercent = (float)scrollBar.getValue() / 100.0f;
            }
        });
        pnlVariables.add(scrollBar);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                gui.close();
            }
        });
    }
}

