/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.saves;

import de.eydamos.backpack.Backpack;
import de.eydamos.backpack.item.ItemBackpackBase;
import de.eydamos.backpack.misc.ConfigurationBackpack;
import de.eydamos.backpack.saves.AbstractSave;
import de.eydamos.backpack.util.BackpackUtil;
import de.eydamos.backpack.util.NBTItemStackUtil;
import de.eydamos.backpack.util.NBTUtil;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class BackpackSave
extends AbstractSave {
    public BackpackSave(String uuid) {
        super(uuid);
    }

    public BackpackSave(NBTTagCompound data) {
        super(data);
        if (NBTUtil.hasTag(this.nbtTagCompound, "backpack-UID")) {
            this.UID = NBTUtil.getString(this.nbtTagCompound, "backpack-UID");
        }
    }

    public BackpackSave(ItemStack backpack) {
        this(backpack, false);
    }

    public BackpackSave(ItemStack backpack, boolean force) {
        super(new NBTTagCompound());
        if (!NBTItemStackUtil.hasTag(backpack, "backpack-UID")) {
            this.initialize(backpack);
        } else if (backpack.func_77973_b() instanceof ItemBackpackBase) {
            this.load(NBTItemStackUtil.getString(backpack, "backpack-UID"));
            if (force) {
                this.initialize(backpack);
            }
        }
    }

    public boolean isUninitialized() {
        return this.nbtTagCompound.func_82582_d();
    }

    public void initialize(ItemStack backpack) {
        if (backpack.func_77973_b() instanceof ItemBackpackBase && BackpackUtil.isServerSide()) {
            NBTItemStackUtil.setString(backpack, "name", backpack.func_77973_b().func_77667_c(backpack) + ".name");
            if (!NBTItemStackUtil.hasTag(backpack, "backpack-UID")) {
                this.UID = UUID.randomUUID().toString();
                NBTItemStackUtil.setString(backpack, "backpack-UID", this.UID);
            }
            int size = BackpackSave.getSize(backpack);
            this.setManualSaving();
            this.setSize(size);
            this.setType(BackpackUtil.getType(backpack));
            if (!NBTUtil.hasTag(this.nbtTagCompound, "backpackInventories")) {
                NBTUtil.setCompoundTag(this.nbtTagCompound, "backpackInventories", new NBTTagCompound());
            }
            this.save();
        }
    }

    private static int getSize(ItemStack backpack) {
        int damage = backpack.func_77960_j();
        int tier = damage / 100;
        int meta = damage % 100;
        if (tier >= 3) {
            tier = 0;
        }
        if (meta == 99) {
            return 27;
        }
        if (meta == 17) {
            if (tier == 2) {
                return 18;
            }
            if (tier == 0) {
                return 9;
            }
        }
        if (meta < 17) {
            switch (tier) {
                case 2: {
                    return ConfigurationBackpack.BACKPACK_SLOTS_L;
                }
                case 1: {
                    return ConfigurationBackpack.BACKPACK_SLOTS_M;
                }
                case 0: {
                    return ConfigurationBackpack.BACKPACK_SLOTS_S;
                }
            }
        }
        return 0;
    }

    public String getUUID() {
        return this.UID;
    }

    public static String getUUID(ItemStack backpack) {
        if (NBTItemStackUtil.hasTag(backpack, "backpack-UID")) {
            return NBTItemStackUtil.getString(backpack, "backpack-UID");
        }
        return new BackpackSave(backpack).getUUID();
    }

    public boolean isIntelligent() {
        return NBTUtil.getBoolean(this.nbtTagCompound, "intelligent");
    }

    public void setIntelligent() {
        NBTUtil.setBoolean(this.nbtTagCompound, "intelligent", true);
        if (!this.manualSaving) {
            this.save();
        }
    }

    public int getSize() {
        return NBTUtil.getInteger(this.nbtTagCompound, "size");
    }

    public void setSize(int size) {
        NBTUtil.setInteger(this.nbtTagCompound, "size", size);
        if (!this.manualSaving) {
            this.save();
        }
    }

    public int getSlotsPerRow() {
        int size = this.getSize();
        if (size <= 63) {
            return 9;
        }
        int MIN_ROWS = 3;
        int MAX_ROWS = 7;
        int MIN_COLS = 9;
        int MAX_COLS = 19;
        for (int rows = 7; rows >= 3; --rows) {
            int columns;
            if (size % rows != 0 || (columns = size / rows) < 9 || columns > 19) continue;
            return columns;
        }
        for (int columns = 9; columns <= 19; ++columns) {
            int rows = (size + columns - 1) / columns;
            if (rows > 7) continue;
            return columns;
        }
        throw new IllegalArgumentException("Inventory too large to fit in a 7x19 grid (" + size + " slots)");
    }

    @Override
    public byte getType() {
        return NBTUtil.getByte(this.nbtTagCompound, "type");
    }

    @Override
    public void setType(byte type) {
        NBTUtil.setByte(this.nbtTagCompound, "type", type);
        if (!this.manualSaving) {
            this.save();
        }
    }

    public NBTTagList getInventory(String inventory) {
        NBTTagCompound inventories = NBTUtil.getCompoundTag(this.nbtTagCompound, "backpackInventories");
        return NBTUtil.getTagList(inventories, inventory, 10);
    }

    public void setInventory(String inventoryName, NBTTagList inventory) {
        NBTTagCompound inventories = NBTUtil.getCompoundTag(this.nbtTagCompound, "backpackInventories");
        NBTUtil.setTagList(inventories, inventoryName, inventory);
        if (!this.manualSaving) {
            this.save();
        }
    }

    @Override
    public void save() {
        if (this.UID != null && BackpackUtil.isServerSide()) {
            Backpack.saveFileHandler.saveBackpack(this.nbtTagCompound, this.UID);
        }
        this.manualSaving = false;
    }

    @Override
    protected void load(String UUID2) {
        if (UUID2 != null && BackpackUtil.isServerSide()) {
            this.UID = UUID2;
            this.nbtTagCompound = Backpack.saveFileHandler.loadBackpack(this.UID);
        }
    }
}

