/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.alignment.constructable;

import com.gtnewhorizon.structurelib.ConfigurationHandler;
import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructableProvider;
import com.gtnewhorizon.structurelib.alignment.constructable.IMultiblockInfoContainer;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import java.util.WeakHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class ConstructableUtility {
    private static final WeakHashMap<EntityPlayerMP, Long> lastUse = new WeakHashMap();
    private static long clientSideLastUse = 0L;

    private ConstructableUtility() {
    }

    public static boolean handle(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide) {
        StructureLibAPI.startHinting(aWorld);
        boolean ret = ConstructableUtility.handle0(aStack, aPlayer, aWorld, aX, aY, aZ, aSide);
        StructureLibAPI.endHinting(aWorld);
        return ret;
    }

    private static boolean handle0(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity == null || aPlayer instanceof FakePlayer) {
            return aPlayer instanceof EntityPlayerMP;
        }
        if (aPlayer instanceof EntityPlayerMP) {
            if (!aPlayer.func_70093_af()) {
                return true;
            }
            long timePast = System.currentTimeMillis() - ConstructableUtility.getLastUseMilis(aPlayer);
            if (timePast < (long)ConfigurationHandler.INSTANCE.getAutoPlaceInterval()) {
                aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("item.structurelib.constructableTrigger.too_fast", new Object[]{(long)ConfigurationHandler.INSTANCE.getAutoPlaceInterval() - timePast}));
                return true;
            }
        } else if (!StructureLib.isCurrentPlayer(aPlayer)) {
            return false;
        }
        IConstructable constructable = null;
        if (tTileEntity instanceof IConstructableProvider) {
            constructable = ((IConstructableProvider)tTileEntity).getConstructable();
        } else if (tTileEntity instanceof IConstructable) {
            constructable = (IConstructable)tTileEntity;
        } else if (IMultiblockInfoContainer.contains(tTileEntity.getClass())) {
            ExtendedFacing facing = tTileEntity instanceof IAlignment ? ((IAlignment)tTileEntity).getExtendedFacing() : ExtendedFacing.of(ForgeDirection.getOrientation((int)aSide));
            constructable = IMultiblockInfoContainer.get(tTileEntity.getClass()).toConstructable(tTileEntity, facing);
        }
        if (constructable == null) {
            return false;
        }
        if (aPlayer instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)aPlayer;
            if (aPlayer.field_71075_bZ.field_75098_d) {
                constructable.construct(aStack, false);
            } else if (constructable instanceof ISurvivalConstructable) {
                int built = ((ISurvivalConstructable)constructable).survivalConstruct(aStack, ConfigurationHandler.INSTANCE.getAutoPlaceBudget(), ISurvivalBuildEnvironment.create(IItemSource.fromPlayer(playerMP), (EntityPlayer)playerMP));
                if (built > 0) {
                    playerMP.func_145747_a((IChatComponent)new ChatComponentTranslation("structurelib.autoplace.built_stat", new Object[]{built}));
                } else if (built == -1) {
                    playerMP.func_145747_a((IChatComponent)new ChatComponentTranslation("structurelib.autoplace.complete", new Object[0]));
                }
                ConstructableUtility.setLastUseMilis(aPlayer);
            } else {
                playerMP.func_145747_a((IChatComponent)new ChatComponentTranslation("structurelib.autoplace.error.not_enabled", new Object[0]));
            }
            return true;
        }
        constructable.construct(aStack, true);
        if (System.currentTimeMillis() - ConstructableUtility.getLastUseMilis(aPlayer) >= 300L) {
            StructureLib.addClientSideChatMessages(constructable.getStructureDescription(aStack));
        }
        ConstructableUtility.setLastUseMilis(aPlayer);
        return false;
    }

    private static void setLastUseMilis(EntityPlayer aPlayer) {
        if (!(aPlayer instanceof EntityPlayerMP)) {
            clientSideLastUse = System.currentTimeMillis();
        } else {
            lastUse.put((EntityPlayerMP)aPlayer, System.currentTimeMillis());
        }
    }

    private static long getLastUseMilis(EntityPlayer aPlayer) {
        if (!(aPlayer instanceof EntityPlayerMP)) {
            return clientSideLastUse;
        }
        return lastUse.getOrDefault(aPlayer, 0L);
    }
}

