/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.modules.infusionRecipe;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.data.IData;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.mc1710.data.NBTConverter;
import minetweaker.mc1710.item.MCItemStack;
import net.glease.tc4tweak.api.InfusionExtAPI;
import net.glease.tc4tweak.modules.infusionRecipe.InfusionRecipeGetOutput;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.crafting.InfusionRecipe;

@ZenClass(value="mods.tc4tweaks.InfusionExt")
public class MTCompatForInfusionExt {
    @ZenMethod
    public static void registerCustomBehavior(IIngredient output, RecipeNBTBehaviorFunction behavior) {
        MineTweakerAPI.apply((IUndoableAction)new CustomBehavior<IIngredient>(output, behavior){

            @Override
            Stream<InfusionRecipe> findMatches() {
                List craftingRecipes = ThaumcraftApi.getCraftingRecipes();
                return craftingRecipes.stream().filter(r -> r instanceof InfusionRecipe).map(r -> (InfusionRecipe)r).filter(r -> r.getRecipeOutput() instanceof ItemStack && ((IIngredient)this.needle).matches((IItemStack)new MCItemStack((ItemStack)r.getRecipeOutput())));
            }
        });
    }

    public static void registerCustomBehavior(IData output, RecipeNBTBehaviorFunction behavior) {
        NBTTagCompound tag = (NBTTagCompound)NBTConverter.from((IData)output);
        MineTweakerAPI.apply((IUndoableAction)new CustomBehavior<NBTTagCompound>(tag, behavior){

            @Override
            Stream<InfusionRecipe> findMatches() {
                List craftingRecipes = ThaumcraftApi.getCraftingRecipes();
                return craftingRecipes.stream().filter(r -> r instanceof InfusionRecipe).map(r -> (InfusionRecipe)r).filter(r -> r.getRecipeOutput() instanceof NBTTagCompound && ((NBTTagCompound)this.needle).equals(r.getRecipeOutput()));
            }
        });
    }

    static abstract class CustomBehavior<T>
    implements IUndoableAction {
        protected final T needle;
        private final InfusionExtAPI.RecipeNBTBehavior behavior;
        private final List<WeakReference<InfusionRecipe>> matchedRecipes = new ArrayList<WeakReference<InfusionRecipe>>();

        public CustomBehavior(T output, RecipeNBTBehaviorFunction behavior) {
            this.needle = output;
            this.behavior = behavior;
        }

        public void apply() {
            this.findMatches().peek(r -> InfusionRecipeGetOutput.overrides.put((InfusionRecipe)r, this.behavior)).map(WeakReference::new).forEach(this.matchedRecipes::add);
        }

        abstract Stream<InfusionRecipe> findMatches();

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            this.matchedRecipes.stream().map(Reference::get).filter(Objects::nonNull).forEach(InfusionRecipeGetOutput.overrides::remove);
            this.matchedRecipes.clear();
        }

        public String describe() {
            return "Add custom recipe NBT behavior for " + this.needle;
        }

        public String describeUndo() {
            return "Unset custom recipe NBT behavior for " + this.needle;
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    @ZenClass(value="mods.tc4tweaks.RecipeNBTBehaviorFunction")
    public static interface RecipeNBTBehaviorFunction
    extends InfusionExtAPI.RecipeNBTBehavior {
    }
}

