/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.glease.tc4tweak.asm.LoadingPlugin;
import net.glease.tc4tweak.asm.TC4Transformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.Configuration;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

final class ASMUtils {
    private static final Configuration configHodgePodge;

    private ASMUtils() {
    }

    public static void writeOverwrite(String targetClass, String targetName, MethodVisitor mv, String clazz, String desc) {
        String targetDesc;
        int base;
        if (clazz == null) {
            base = 0;
            targetDesc = desc;
        } else {
            mv.visitVarInsn(25, 0);
            base = 1;
            targetDesc = '(' + Type.getObjectType((String)clazz).getDescriptor() + desc.substring(1);
        }
        mv.visitCode();
        Type methodType = Type.getMethodType((String)desc);
        for (Type argumentType : methodType.getArgumentTypes()) {
            mv.visitVarInsn(argumentType.getOpcode(21), base++);
        }
        mv.visitMethodInsn(184, targetClass, targetName, targetDesc, false);
        mv.visitInsn(methodType.getReturnType().getOpcode(172));
        mv.visitMaxs(base, Type.VOID_TYPE.equals((Object)methodType.getReturnType()) ? base : Math.max(1, base));
        mv.visitEnd();
    }

    public static void writeRedirect(MethodVisitor mv, String targetClass, String targetName, String clazz, String origName, String desc, Type ... append) {
        String targetDesc;
        if (append == null || append.length == 0) {
            targetDesc = clazz == null ? desc : '(' + Type.getObjectType((String)clazz).getDescriptor() + desc.substring(1);
        } else {
            Type orig = Type.getMethodType((String)desc);
            ArrayList<Type> args = new ArrayList<Type>();
            if (clazz != null) {
                args.add(Type.getObjectType((String)clazz));
            }
            Collections.addAll(args, orig.getArgumentTypes());
            Collections.addAll(args, append);
            targetDesc = Type.getMethodDescriptor((Type)orig.getReturnType(), (Type[])args.toArray(new Type[0]));
        }
        TC4Transformer.log.trace("Redirecting {}#{}{} to {}#{}{}", new Object[]{clazz, origName, desc, targetClass, targetName, targetDesc});
        mv.visitMethodInsn(184, targetClass, targetName, targetDesc, false);
    }

    static <T> T[] arrayAppend(T[] arr, T newLast) {
        T[] out = Arrays.copyOf(arr, arr.length + 1);
        out[arr.length] = newLast;
        return out;
    }

    static <T> T[] arrayPrepend(T[] arr, T newLast) {
        Object[] out = (Object[])Array.newInstance(arr.getClass().getComponentType(), arr.length + 1);
        out[0] = newLast;
        System.arraycopy(arr, 0, out, 1, arr.length);
        return out;
    }

    static boolean isHodgepodgeFixActive(String category, String configName, boolean defaultValue) {
        if (configHodgePodge == null) {
            return false;
        }
        return configHodgePodge.getBoolean(configName, category, defaultValue, "");
    }

    static {
        Configuration c;
        try {
            c = !LoadingPlugin.hodgepodge ? null : new Configuration(new File(Launch.minecraftHome, "config/hodgepodge.cfg"));
        }
        catch (Exception e) {
            TC4Transformer.log.debug("unable to load hodgepodge.cfg", (Throwable)e);
            c = null;
        }
        configHodgePodge = c;
    }
}

