/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.storage;

import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.SimpleDatabase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

abstract class LookupLogic<T> {
    protected final SimpleDatabase<T> simpleDatabase;
    protected List<DBEntry<T>> refCache = null;

    public LookupLogic(SimpleDatabase<T> simpleDatabase) {
        this.simpleDatabase = simpleDatabase;
    }

    public void onDataChange() {
        this.refCache = null;
    }

    public List<DBEntry<T>> getRefCache() {
        if (this.refCache != null) {
            return this.refCache;
        }
        this.computeRefCache();
        return this.refCache;
    }

    public abstract List<DBEntry<T>> bulkLookup(int[] var1);

    protected void computeRefCache() {
        ArrayList temp = new ArrayList();
        for (Map.Entry entry : this.simpleDatabase.mapDB.entrySet()) {
            temp.add(new DBEntry(entry.getKey(), entry.getValue()));
        }
        this.refCache = Collections.unmodifiableList(temp);
    }
}

