/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.data.holders.basetypes;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.basetypes.CoordinatesBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;

public final class CoordinatesChunk
implements ISerializable {
    public final int dim;
    public final int x;
    public final int y;
    public final int z;
    public final int chunkX;
    public final int chunkZ;
    public final byte metadata;
    public static final CoordinatesChunk INVALID = new CoordinatesChunk(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);

    public CoordinatesChunk(CoordinatesBlock coord) {
        this.dim = coord.dim;
        this.chunkX = coord.chunkX;
        this.chunkZ = coord.chunkZ;
        this.x = this.chunkX << 4;
        this.y = 0;
        this.z = this.chunkZ << 4;
        this.metadata = 0;
    }

    public CoordinatesChunk(int dim, int chunkX, int chunkZ) {
        this.dim = dim;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.x = chunkX << 4;
        this.y = 0;
        this.z = chunkZ << 4;
        this.metadata = 0;
    }

    public CoordinatesChunk(int dim, int chunkX, int chunkZ, byte metadata) {
        this.dim = dim;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.x = chunkX << 4;
        this.y = 0;
        this.z = chunkZ << 4;
        this.metadata = metadata;
    }

    public CoordinatesChunk(int dim, ChunkCoordIntPair coord) {
        this.dim = dim;
        this.chunkX = coord.field_77276_a;
        this.chunkZ = coord.field_77275_b;
        this.x = this.chunkX << 4;
        this.y = 0;
        this.z = this.chunkZ << 4;
        this.metadata = 0;
    }

    public CoordinatesChunk(int dim, ChunkCoordIntPair coord, byte metadata) {
        this.dim = dim;
        this.chunkX = coord.field_77276_a;
        this.chunkZ = coord.field_77275_b;
        this.x = this.chunkX << 4;
        this.y = 0;
        this.z = this.chunkZ << 4;
        this.metadata = metadata;
    }

    public CoordinatesChunk(TileEntity te) {
        this.dim = te.func_145831_w().field_73011_w.field_76574_g;
        this.chunkX = te.field_145851_c >> 4;
        this.chunkZ = te.field_145849_e >> 4;
        this.x = this.chunkX << 4;
        this.y = 0;
        this.z = this.chunkZ << 4;
        this.metadata = 0;
    }

    public boolean isInvalid() {
        return this.equals(INVALID);
    }

    public String toString() {
        return String.format("[%6d %6d %6d]", this.dim, this.chunkX, this.chunkZ);
    }

    public boolean equals(Object o) {
        CoordinatesChunk c = (CoordinatesChunk)o;
        return this.dim == c.dim && this.chunkX == c.chunkX && this.chunkZ == c.chunkZ;
    }

    public int hashCode() {
        return this.dim + 31 * this.chunkX + 877 * this.chunkZ;
    }

    public ChunkCoordIntPair toChunkCoordIntPair() {
        return new ChunkCoordIntPair(this.chunkX, this.chunkZ);
    }

    public CoordinatesBlock asCoordinatesBlock() {
        return new CoordinatesBlock(this);
    }

    @Override
    public void writeToStream(ByteArrayDataOutput stream) {
        stream.writeInt(this.dim);
        stream.writeInt(this.chunkX);
        stream.writeInt(this.chunkZ);
        stream.writeByte((int)this.metadata);
    }

    public static CoordinatesChunk readFromStream(ByteArrayDataInput stream) {
        return new CoordinatesChunk(stream.readInt(), stream.readInt(), stream.readInt(), stream.readByte());
    }
}

