/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech.machines;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTUtility;
import gttweaker.mods.AddMultipleRecipeAction;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.VacuumFreezer")
@ModOnly(value={"gregtech"})
public class VacuumFreezer {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, int durationTicks) {
        MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding vacuum freezer recipe for " + output, new Object[]{input, output, durationTicks}){

            @Override
            protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                ItemStack input = i.nextItem();
                ItemStack output = i.nextItem();
                int duration = i.nextInt();
                GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{input}).itemOutputs(new ItemStack[]{output}).duration(duration).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.vacuumFreezerRecipes);
                FluidStack fluidInput = GTUtility.getFluidForFilledItem((ItemStack)input, (boolean)true);
                FluidStack fluidOutput = GTUtility.getFluidForFilledItem((ItemStack)output, (boolean)true);
                if (fluidInput != null && fluidOutput != null) {
                    GTValues.RA.stdBuilder().fluidInputs(new FluidStack[]{fluidInput}).fluidOutputs(new FluidStack[]{fluidOutput}).duration(duration).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.vacuumFreezerRecipes);
                }
            }
        });
    }
}

