/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.packets;

import gcewing.sg.packets.BaseDataChannel;
import gcewing.sg.packets.ClassCache;
import gcewing.sg.packets.MethodCache;
import java.lang.reflect.Method;

enum HandlerMap {
    SERVER(BaseDataChannel.ServerMessageHandler.class){

        @Override
        protected String annotationValue(Object a) {
            return ((BaseDataChannel.ServerMessageHandler)a).value();
        }
    }
    ,
    CLIENT(BaseDataChannel.ClientMessageHandler.class){

        @Override
        protected String annotationValue(Object a) {
            return ((BaseDataChannel.ClientMessageHandler)a).value();
        }
    };

    protected Class type;
    protected ClassCache classCache = new ClassCache();

    private HandlerMap(Class type) {
        this.type = type;
    }

    protected abstract String annotationValue(Object var1);

    public Method get(Object handler, String message) {
        Class<?> cls = handler.getClass();
        MethodCache cache = this.classCache.get(cls);
        Method meth = (Method)cache.get(message);
        if (meth == null) {
            for (Method m : cls.getMethods()) {
                Object a = m.getAnnotation(this.type);
                if (a == null || !this.annotationValue(a).equals(message)) continue;
                cache.put(message, m);
                meth = m;
                break;
            }
        }
        return meth;
    }
}

