/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseMod;
import gcewing.sg.SGCraft;
import gcewing.sg.tileentities.BaseTileEntity;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class BaseTEChunkManager
implements ForgeChunkManager.LoadingCallback {
    public boolean debug = false;
    BaseMod base;

    public BaseTEChunkManager(BaseMod mod) {
        this.base = mod;
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)mod, (ForgeChunkManager.LoadingCallback)this);
        if (this.debug) {
            SGCraft.log.debug(String.format("%s: BaseTEChunkManager: Chunk loading callback installed", this.base.modPackage));
        }
    }

    protected ForgeChunkManager.Ticket newTicket(World world) {
        if (this.debug) {
            SGCraft.log.debug(String.format("%s: BaseTEChunkManager.newTicket for %s", this.base.modPackage, world));
        }
        return ForgeChunkManager.requestTicket((Object)this.base, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        if (this.debug) {
            SGCraft.log.debug(String.format("%s: BaseTEChunkManager.ticketsLoaded for %s", this.base.modPackage, world));
        }
        for (ForgeChunkManager.Ticket ticket : tickets) {
            NBTTagCompound nbt = ticket.getModData();
            if (nbt == null || !nbt.func_74779_i("type").equals("TileEntity")) continue;
            int x = nbt.func_74762_e("xCoord");
            int y = nbt.func_74762_e("yCoord");
            int z = nbt.func_74762_e("zCoord");
            TileEntity te = world.func_147438_o(x, y, z);
            if (this.debug) {
                SGCraft.log.debug(String.format("%s: BaseTEChunkManager.ticketsLoaded: Ticket for %s at (%d, %d, %d)", this.base.modPackage, te, x, y, z));
            }
            if (te instanceof BaseTileEntity && this.reinstateChunkTicket((BaseTileEntity)te, ticket)) continue;
            if (this.debug) {
                SGCraft.log.debug(String.format("%s: BaseTEChunkManager.ticketsLoaded: : Unable to reinstate ticket", this.base.modPackage));
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
    }

    public void setForcedChunkRange(BaseTileEntity te, int minX, int minZ, int maxX, int maxZ) {
        te.releaseChunkTicket();
        ForgeChunkManager.Ticket ticket = this.getChunkTicket(te);
        if (ticket == null) {
            return;
        }
        NBTTagCompound nbt = ticket.getModData();
        nbt.func_74778_a("type", "TileEntity");
        nbt.func_74768_a("xCoord", te.field_145851_c);
        nbt.func_74768_a("yCoord", te.field_145848_d);
        nbt.func_74768_a("zCoord", te.field_145849_e);
        nbt.func_74768_a("rangeMinX", minX);
        nbt.func_74768_a("rangeMinZ", minZ);
        nbt.func_74768_a("rangeMaxX", maxX);
        nbt.func_74768_a("rangeMaxZ", maxZ);
        this.forceChunkRangeOnTicket(te, ticket);
    }

    public void clearForcedChunkRange(BaseTileEntity te) {
        te.releaseChunkTicket();
    }

    protected void forceChunkRangeOnTicket(BaseTileEntity te, ForgeChunkManager.Ticket ticket) {
        NBTTagCompound nbt = ticket.getModData();
        int minX = nbt.func_74762_e("rangeMinX");
        int minZ = nbt.func_74762_e("rangeMinZ");
        int maxX = nbt.func_74762_e("rangeMaxX");
        int maxZ = nbt.func_74762_e("rangeMaxZ");
        if (this.debug) {
            SGCraft.log.debug(String.format("BaseChunkLoadingTE: Forcing range (%s,%s)-(%s,%s) in dimension %s", minX, minZ, maxX, maxZ, te.func_145831_w().field_73011_w.field_76574_g));
        }
        int chunkX = te.field_145851_c >> 4;
        int chunkZ = te.field_145849_e >> 4;
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minZ; j <= maxZ; ++j) {
                int x = chunkX + i;
                int z = chunkZ + j;
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(x, z));
            }
        }
    }

    protected ForgeChunkManager.Ticket getChunkTicket(BaseTileEntity te) {
        if (te.chunkTicket == null) {
            te.chunkTicket = this.newTicket(te.func_145831_w());
        }
        return te.chunkTicket;
    }

    public boolean reinstateChunkTicket(BaseTileEntity te, ForgeChunkManager.Ticket ticket) {
        if (te.chunkTicket != null) {
            return false;
        }
        if (this.debug) {
            SGCraft.log.debug(String.format("BaseChunkLoadingTE: Reinstating chunk ticket %s", ticket));
        }
        te.chunkTicket = ticket;
        this.forceChunkRangeOnTicket(te, ticket);
        return true;
    }
}

