/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.data;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import makeo.gadomancy.common.data.AbstractData;
import makeo.gadomancy.common.data.DataAchromatic;
import makeo.gadomancy.common.data.DataFamiliar;
import makeo.gadomancy.common.network.PacketHandler;
import makeo.gadomancy.common.network.packets.PacketSyncData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class SyncDataHolder {
    private static Map<String, AbstractData> serverData = new HashMap<String, AbstractData>();
    private static Map<String, AbstractData> clientData = new HashMap<String, AbstractData>();
    private static List<String> dirtyData = new ArrayList<String>();
    private static byte providerCounter;

    public static void register(AbstractData.AbstractDataProvider<? extends AbstractData> provider) {
        AbstractData.Registry.register(provider);
        AbstractData ad = provider.provideNewInstance();
        ad.setProviderId(provider.getProviderId());
        serverData.put(provider.getKey(), ad);
        ad = provider.provideNewInstance();
        ad.setProviderId(provider.getProviderId());
        clientData.put(provider.getKey(), ad);
    }

    public static byte allocateNewId() {
        byte pId = providerCounter;
        providerCounter = (byte)(providerCounter + 1);
        return pId;
    }

    public static <T extends AbstractData> T getDataServer(String key) {
        return (T)serverData.get(key);
    }

    public static <T extends AbstractData> T getDataClient(String key) {
        return (T)clientData.get(key);
    }

    public static void markForUpdate(String key) {
        if (!dirtyData.contains(key)) {
            dirtyData.add(key);
        }
    }

    public static void syncAllDataTo(EntityPlayer player) {
        PacketSyncData dataSync = new PacketSyncData(serverData, true);
        PacketHandler.INSTANCE.sendTo((IMessage)dataSync, (EntityPlayerMP)player);
    }

    public static void receiveServerPacket(Map<String, AbstractData> data) {
        for (String key : data.keySet()) {
            AbstractData dat = clientData.get(key);
            if (dat == null) continue;
            dat.handleIncomingData(data.get(key));
        }
    }

    public static void doNecessaryUpdates() {
        if (dirtyData.isEmpty()) {
            return;
        }
        HashMap<String, AbstractData> pktData = new HashMap<String, AbstractData>();
        for (String s : dirtyData) {
            Object d = SyncDataHolder.getDataServer(s);
            if (!((AbstractData)d).needsUpdate()) continue;
            pktData.put(s, (AbstractData)d);
        }
        dirtyData.clear();
        PacketSyncData dataSync = new PacketSyncData(pktData, false);
        PacketHandler.INSTANCE.sendToAll((IMessage)dataSync);
    }

    public static void initialize() {
        SyncDataHolder.register(new DataFamiliar.Provider("FamiliarData"));
        SyncDataHolder.register(new DataAchromatic.Provider("AchromaticData"));
    }
}

