/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.aura;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import makeo.gadomancy.common.aura.AuraEffectHandler;
import makeo.gadomancy.common.data.config.ModConfig;
import makeo.gadomancy.common.network.PacketHandler;
import makeo.gadomancy.common.network.packets.PacketTCNotificationText;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.StatCollector;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.research.ResearchManager;

public class AuraResearchManager {
    public static final String TC_AURA_RESEARCH_STR = "GADOMANCY.AURA.%s";

    public static void tryUnlockAuraEffect(EntityPlayer player, Aspect aspect) {
        if (!AuraEffectHandler.registeredEffects.containsKey(aspect)) {
            return;
        }
        if (AuraResearchManager.isBlacklisted(aspect)) {
            return;
        }
        if (!ResearchManager.isResearchComplete((String)player.func_70005_c_(), (String)("gadomancy".toUpperCase() + ".AURA_EFFECTS"))) {
            return;
        }
        if (!Thaumcraft.proxy.getPlayerKnowledge().hasDiscoveredAspect(player.func_70005_c_(), aspect)) {
            return;
        }
        String res = String.format(TC_AURA_RESEARCH_STR, aspect.getTag());
        if (ResearchManager.isResearchComplete((String)player.func_70005_c_(), (String)res)) {
            return;
        }
        Thaumcraft.proxy.getResearchManager().completeResearch(player, res);
        PacketTCNotificationText text = new PacketTCNotificationText("gadomancy.aura.research.unlock", aspect.getTag());
        PacketHandler.INSTANCE.sendTo((IMessage)text, (EntityPlayerMP)player);
    }

    public static List<String> getLines(String aspectTag) {
        ArrayList<String> lines = new ArrayList<String>();
        String base = "gadomancy.aura.effect." + aspectTag;
        if (StatCollector.func_94522_b((String)base)) {
            lines.add(StatCollector.func_74838_a((String)base));
            return lines;
        }
        int count = 0;
        while (StatCollector.func_94522_b((String)(base + "_" + count))) {
            lines.add(StatCollector.func_74838_a((String)(base + "_" + count)));
            ++count;
        }
        return lines;
    }

    public static List<String> getKnowledge(EntityPlayer player) {
        ArrayList<String> lines = new ArrayList<String>();
        for (Aspect a : AuraEffectHandler.registeredEffects.keySet()) {
            if (!ResearchManager.isResearchComplete((String)player.func_70005_c_(), (String)String.format(TC_AURA_RESEARCH_STR, a.getTag())) || AuraResearchManager.isBlacklisted(a)) continue;
            lines.add(a.getTag());
        }
        return lines;
    }

    public static boolean isBlacklisted(Aspect a) {
        for (String aspectTag : ModConfig.blacklistAuraEffects) {
            if (aspectTag == null || !aspectTag.equals(a.getTag())) continue;
            return true;
        }
        return false;
    }

    public static void registerAuraResearches() {
        for (Aspect a : AuraEffectHandler.registeredEffects.keySet()) {
            new ResearchItem(String.format(TC_AURA_RESEARCH_STR, a.getTag()), "gadomancy").registerResearchItem();
        }
    }
}

