/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class AssemblyMachineRecipeHandler
extends TemplateRecipeHandler {
    private final Set<Pair<List<PositionedStack>, PositionedStack>> recipes = new HashSet<Pair<List<PositionedStack>, PositionedStack>>();
    private static final ResourceLocation TEXTURE = new ResourceLocation("galaxyspace", "textures/gui/assembly_machine.png");
    private static int ticksPassed;

    void addRecipe(List<PositionedStack> inputs, PositionedStack output) {
        this.recipes.add((Pair<List<PositionedStack>, PositionedStack>)Pair.of(inputs, (Object)output));
    }

    private String getRecipeId() {
        return "galaxyspace.assemblymachine";
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((ResourceLocation)TEXTURE);
        GuiDraw.drawTexturedModalRect((int)20, (int)25, (int)18, (int)17, (int)137, (int)54);
        if (ticksPassed % 70 > 26) {
            GuiDraw.drawTexturedModalRect((int)93, (int)39, (int)176, (int)0, (int)17, (int)13);
        }
        GuiDraw.drawTexturedModalRect((int)79, (int)46, (int)176, (int)13, (int)Math.min(ticksPassed % 70, 53), (int)17);
    }

    public void drawForeground(int recipe) {
    }

    public String getGuiTexture() {
        return "galaxyspacetextures/gui/assembly_machine.png";
    }

    public String getRecipeName() {
        return "Assembly Machine";
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Pair<List<PositionedStack>, PositionedStack> recipe : this.recipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((PositionedStack)recipe.getValue()).item, (ItemStack)result)) continue;
            this.arecipes.add(new AssemblyMachineRecipe(recipe));
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Pair<List<PositionedStack>, PositionedStack> recipe : this.recipes) {
                this.arecipes.add(new AssemblyMachineRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Pair<List<PositionedStack>, PositionedStack> recipe : this.recipes) {
            for (PositionedStack input : (List)recipe.getKey()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)input.item)) continue;
                this.arecipes.add(new AssemblyMachineRecipe(recipe));
            }
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(0, 0, 40, 40), this.getRecipeId(), new Object[0]));
    }

    public void onUpdate() {
        ++ticksPassed;
        super.onUpdate();
    }

    public int recipiesPerPage() {
        return 1;
    }

    private class AssemblyMachineRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private List<PositionedStack> input;
        private PositionedStack output;

        private AssemblyMachineRecipe(List<PositionedStack> input, PositionedStack output) {
            super((TemplateRecipeHandler)AssemblyMachineRecipeHandler.this);
            this.input = input;
            this.output = output;
        }

        private AssemblyMachineRecipe(Pair<List<PositionedStack>, PositionedStack> recipe) {
            this((List)recipe.getLeft(), (PositionedStack)recipe.getRight());
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(AssemblyMachineRecipeHandler.this.cycleticks / 20, this.input);
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

