/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.mca;

import galaxyspace.core.mca.common.Utils;
import galaxyspace.core.utils.math.Matrix4f;
import galaxyspace.core.utils.math.Quaternion;
import galaxyspace.core.utils.math.Vector3f;
import java.nio.FloatBuffer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import org.lwjgl.opengl.GL11;

public class MCAModelRenderer
extends ModelRenderer {
    private Matrix4f rotationMatrix = new Matrix4f();
    private Matrix4f prevRotationMatrix = new Matrix4f();
    private float defaultRotationPointX;
    private float defaultRotationPointY;
    private float defaultRotationPointZ;
    private Matrix4f defaultRotationMatrix = new Matrix4f();
    private Quaternion defaultRotationAsQuaternion;

    public MCAModelRenderer(ModelBase baseModel, String boxName, int xTextureOffset, int yTextureOffset) {
        super(baseModel, boxName);
        this.func_78787_b(baseModel.field_78090_t, baseModel.field_78089_u);
        this.func_78784_a(xTextureOffset, yTextureOffset);
    }

    public ModelRenderer func_78786_a(String p_78786_1_, float originX, float originY, float originZ, int width, int height, int depth) {
        p_78786_1_ = this.field_78802_n + "." + p_78786_1_;
        this.field_78804_l.add(new ModelBox((ModelRenderer)this, this.field_78803_o, this.field_78813_p, originX, originY, originZ, width, height, depth, 0.0f).func_78244_a(p_78786_1_));
        return this;
    }

    public ModelRenderer func_78789_a(float originX, float originY, float originZ, int width, int height, int depth) {
        this.field_78804_l.add(new ModelBox((ModelRenderer)this, this.field_78803_o, this.field_78813_p, originX, originY, originZ, width, height, depth, 0.0f));
        return this;
    }

    public void func_78790_a(float originX, float originY, float originZ, int width, int height, int depth, float scaleFactor) {
        this.field_78804_l.add(new ModelBox((ModelRenderer)this, this.field_78803_o, this.field_78813_p, originX, originY, originZ, width, height, depth, scaleFactor));
    }

    public void func_78785_a(float partialTickTime) {
        if (this.field_78807_k || !this.field_78806_j) {
            return;
        }
        if (!this.field_78812_q) {
            this.func_78788_d(partialTickTime);
        }
        GL11.glTranslatef((float)this.field_82906_o, (float)this.field_82908_p, (float)this.field_82907_q);
        if (this.rotationMatrix.isEmptyRotationMatrix()) {
            if (this.field_78800_c == 0.0f && this.field_78797_d == 0.0f && this.field_78798_e == 0.0f) {
                GL11.glCallList((int)this.field_78811_r);
                if (this.field_78805_m != null) {
                    for (ModelRenderer element : this.field_78805_m) {
                        element.func_78785_a(partialTickTime);
                    }
                }
            } else {
                GL11.glTranslatef((float)(this.field_78800_c * partialTickTime), (float)(this.field_78797_d * partialTickTime), (float)(this.field_78798_e * partialTickTime));
                GL11.glCallList((int)this.field_78811_r);
                if (this.field_78805_m != null) {
                    for (ModelRenderer element : this.field_78805_m) {
                        element.func_78785_a(partialTickTime);
                    }
                }
                GL11.glTranslatef((float)(-this.field_78800_c * partialTickTime), (float)(-this.field_78797_d * partialTickTime), (float)(-this.field_78798_e * partialTickTime));
            }
        } else {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.field_78800_c * partialTickTime), (float)(this.field_78797_d * partialTickTime), (float)(this.field_78798_e * partialTickTime));
            FloatBuffer buf = Utils.makeFloatBuffer(this.rotationMatrix.intoArray());
            GL11.glMultMatrix((FloatBuffer)buf);
            GL11.glCallList((int)this.field_78811_r);
            if (this.field_78805_m != null) {
                for (ModelRenderer element : this.field_78805_m) {
                    element.func_78785_a(partialTickTime);
                }
            }
            GL11.glPopMatrix();
        }
        GL11.glTranslatef((float)(-this.field_82906_o), (float)(-this.field_82908_p), (float)(-this.field_82907_q));
        this.prevRotationMatrix = this.rotationMatrix;
    }

    public void func_78791_b(float partialTickTime) {
    }

    public void func_78794_c(float partialTickTime) {
        if (!this.field_78807_k && this.field_78806_j) {
            if (!this.field_78812_q) {
                this.func_78788_d(partialTickTime);
            }
            if (this.rotationMatrix.equals(this.prevRotationMatrix)) {
                if (this.field_78800_c != 0.0f || this.field_78797_d != 0.0f || this.field_78798_e != 0.0f) {
                    GL11.glTranslatef((float)(this.field_78800_c * partialTickTime), (float)(this.field_78797_d * partialTickTime), (float)(this.field_78798_e * partialTickTime));
                }
            } else {
                GL11.glTranslatef((float)(this.field_78800_c * partialTickTime), (float)(this.field_78797_d * partialTickTime), (float)(this.field_78798_e * partialTickTime));
                GL11.glMultMatrix((FloatBuffer)FloatBuffer.wrap(this.rotationMatrix.intoArray()));
            }
        }
    }

    public void setInitialRotationPoint(float defaultRotationPointX, float defaultRotationPointY, float defaultRotationPointZ) {
        this.defaultRotationPointX = defaultRotationPointX;
        this.defaultRotationPointY = defaultRotationPointY;
        this.defaultRotationPointZ = defaultRotationPointZ;
        this.func_78793_a(this.defaultRotationPointX, this.defaultRotationPointY, this.defaultRotationPointZ);
    }

    public void resetRotationPoint() {
        this.field_78800_c = this.defaultRotationPointX;
        this.field_78797_d = this.defaultRotationPointY;
        this.field_78798_e = this.defaultRotationPointZ;
    }

    public Vector3f getPositionAsVector() {
        return new Vector3f(this.field_78800_c, this.field_78797_d, this.field_78798_e);
    }

    public void setInitialRotationMatrix(Matrix4f matrix) {
        this.defaultRotationMatrix = matrix;
        this.setRotationMatrix(this.defaultRotationMatrix);
        this.defaultRotationAsQuaternion = Utils.getQuaternionFromMatrix(this.rotationMatrix);
    }

    public void setRotationMatrix(Matrix4f matrix) {
        this.rotationMatrix.m00 = matrix.m00;
        this.rotationMatrix.m01 = matrix.m01;
        this.rotationMatrix.m02 = matrix.m02;
        this.rotationMatrix.m03 = matrix.m03;
        this.rotationMatrix.m10 = matrix.m10;
        this.rotationMatrix.m11 = matrix.m11;
        this.rotationMatrix.m12 = matrix.m12;
        this.rotationMatrix.m13 = matrix.m13;
        this.rotationMatrix.m20 = matrix.m20;
        this.rotationMatrix.m21 = matrix.m21;
        this.rotationMatrix.m22 = matrix.m22;
        this.rotationMatrix.m23 = matrix.m23;
        this.rotationMatrix.m30 = matrix.m30;
        this.rotationMatrix.m31 = matrix.m31;
        this.rotationMatrix.m32 = matrix.m32;
        this.rotationMatrix.m33 = matrix.m33;
    }

    public void resetRotationMatrix() {
        this.setRotationMatrix(this.defaultRotationMatrix);
    }

    public Matrix4f getRotationMatrix() {
        return this.rotationMatrix;
    }

    public Quaternion getDefaultRotationAsQuaternion() {
        return this.defaultRotationAsQuaternion;
    }
}

