/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import galaxyspace.SolarSystem.moons.callisto.dimension.WorldProviderCallisto;
import galaxyspace.SolarSystem.moons.deimos.dimension.WorldProviderDeimos;
import galaxyspace.SolarSystem.moons.enceladus.dimension.WorldProviderEnceladus;
import galaxyspace.SolarSystem.moons.europa.dimension.WorldProviderEuropa;
import galaxyspace.SolarSystem.moons.ganymede.dimension.WorldProviderGanymede;
import galaxyspace.SolarSystem.moons.io.dimension.WorldProviderIo;
import galaxyspace.SolarSystem.moons.miranda.dimension.WorldProviderMiranda;
import galaxyspace.SolarSystem.moons.oberon.dimension.WorldProviderOberon;
import galaxyspace.SolarSystem.moons.phobos.dimension.WorldProviderPhobos;
import galaxyspace.SolarSystem.moons.proteus.dimension.WorldProviderProteus;
import galaxyspace.SolarSystem.moons.titan.dimension.WorldProviderTitan;
import galaxyspace.SolarSystem.moons.triton.dimension.WorldProviderTriton;
import galaxyspace.SolarSystem.planets.ceres.dimension.WorldProviderCeres;
import galaxyspace.SolarSystem.planets.haumea.dimension.WorldProviderHaumea;
import galaxyspace.SolarSystem.planets.jupiter.dimension.WorldProviderJupiter;
import galaxyspace.SolarSystem.planets.kuiperbelt.dimension.TeleportTypeKuiper;
import galaxyspace.SolarSystem.planets.kuiperbelt.dimension.WorldProviderKuiper;
import galaxyspace.SolarSystem.planets.makemake.dimension.WorldProviderMakemake;
import galaxyspace.SolarSystem.planets.mercury.dimension.WorldProviderMercury;
import galaxyspace.SolarSystem.planets.neptune.dimension.WorldProviderNeptune;
import galaxyspace.SolarSystem.planets.pluto.dimension.TeleportTypePluto;
import galaxyspace.SolarSystem.planets.pluto.dimension.WorldProviderPluto;
import galaxyspace.SolarSystem.planets.saturn.dimension.WorldProviderSaturn;
import galaxyspace.SolarSystem.planets.uranus.dimension.WorldProviderUranus;
import galaxyspace.SolarSystem.planets.venus.dimension.WorldProviderVenus;
import galaxyspace.SolarSystem.satellites.jupiter.dimension.WorldProviderJupiterSS;
import galaxyspace.SolarSystem.satellites.mars.dimension.WorldProviderMarsSS;
import galaxyspace.SolarSystem.satellites.neptune.dimension.WorldProviderNeptuneSS;
import galaxyspace.SolarSystem.satellites.saturn.dimension.WorldProviderSaturnSS;
import galaxyspace.SolarSystem.satellites.uranus.dimension.WorldProviderUranusSS;
import galaxyspace.SolarSystem.satellites.venus.dimension.WorldProviderVenusSS;
import galaxyspace.core.config.GSConfigCore;
import galaxyspace.core.config.GSConfigDimensions;
import galaxyspace.core.dimension.TeleportTypeGS;
import galaxyspace.core.dimension.TeleportTypeSpaceStationGS;
import galaxyspace.core.register.GSBlocks;
import galaxyspace.core.render.GSResources;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.world.gen.OverworldGenerator;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;

public class SolarSystemPlanets {
    public static Planet planetMercury;
    public static Planet planetVenus;
    public static Planet planetCeres;
    public static Planet planetJupiter;
    public static Planet planetSaturn;
    public static Planet planetUranus;
    public static Planet planetNeptune;
    public static Planet planetPluto;
    public static Planet planetKuiperBelt;
    public static Planet planetHaumea;
    public static Planet planetMakemake;
    public static Planet planetEris;
    @Deprecated
    public static Planet planetZTest;
    public static Moon phobosMars;
    public static Moon deimosMars;
    public static Moon ioJupiter;
    public static Moon europaJupiter;
    public static Moon ganymedeJupiter;
    public static Moon callistoJupiter;
    public static Moon mimasSaturn;
    public static Moon enceladusSaturn;
    public static Moon tethysSaturn;
    public static Moon dioneSaturn;
    public static Moon rheyaSaturn;
    public static Moon titanSaturn;
    public static Moon iapetusSaturn;
    public static Moon mirandaUranus;
    public static Moon arielUranus;
    public static Moon umbrielUranus;
    public static Moon titaniaUranus;
    public static Moon oberonUranus;
    public static Moon proteusNeptune;
    public static Moon tritonNeptune;
    public static Moon charonPluto;
    public static Satellite marsSpaceStation;
    public static Satellite venusSpaceStation;
    public static Satellite jupiterSpaceStation;
    public static Satellite saturnSpaceStation;
    public static Satellite uranusSpaceStation;
    public static Satellite neptuneSpaceStation;

    public static void init() {
        if (GSConfigCore.enableLeadGeneration) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OverworldGenerator(GSBlocks.LeadOre, 0, 6, 0, 45, 4), (int)4);
        }
        planetMercury = new Planet("mercury").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetMercury.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetMercury.setPhaseShift(1.45f);
        planetMercury.setTierRequired(4);
        planetMercury.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f, 0.5f));
        planetMercury.setRelativeOrbitTime(0.24096386f);
        planetMercury.setBodyIcon(GSResources.mercuryTexture);
        if (GSConfigDimensions.enableMercury) {
            planetMercury.setDimensionInfo(GSConfigDimensions.dimensionIDMercury, WorldProviderMercury.class);
            GalaxyRegistry.registerPlanet((Planet)planetMercury);
            GalacticraftRegistry.registerTeleportType(WorldProviderMercury.class, (ITeleportType)new TeleportTypeGS());
        }
        planetVenus = new Planet("venus").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetVenus.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetVenus.setPhaseShift(2.0f);
        planetVenus.setTierRequired(4);
        planetVenus.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.75f, 0.75f));
        planetVenus.setRelativeOrbitTime(0.6152793f);
        planetVenus.setBodyIcon(GSResources.venusTexture);
        planetVenus.atmosphereComponent(IAtmosphericGas.CO2).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.ARGON);
        if (GSConfigDimensions.enableVenus) {
            planetVenus.setDimensionInfo(GSConfigDimensions.dimensionIDVenus, WorldProviderVenus.class);
            GalaxyRegistry.registerPlanet((Planet)planetVenus);
            GalacticraftRegistry.registerTeleportType(WorldProviderVenus.class, (ITeleportType)new TeleportTypeGS());
        }
        venusSpaceStation = new Satellite("spaceStation.venus").setParentBody(planetVenus);
        venusSpaceStation.setRelativeSize(0.2667f);
        venusSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(10.0f, 10.0f));
        venusSpaceStation.setRelativeOrbitTime(20.0f);
        venusSpaceStation.setTierRequired(4);
        venusSpaceStation.setBodyIcon(GSResources.spaceStationTexture);
        if (GSConfigDimensions.enableVenusSS) {
            venusSpaceStation.setDimensionInfo(GSConfigDimensions.dimensionIDVenusOrbit, GSConfigDimensions.dimensionIDVenusOrbitStatic, WorldProviderVenusSS.class);
            GalaxyRegistry.registerSatellite((Satellite)venusSpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderVenusSS.class, (ITeleportType)new TeleportTypeSpaceStationGS());
            GalacticraftRegistry.registerProvider((int)GSConfigDimensions.dimensionIDVenusOrbit, WorldProviderVenusSS.class, (boolean)false, (int)-42);
            GalacticraftRegistry.registerProvider((int)GSConfigDimensions.dimensionIDVenusOrbitStatic, WorldProviderVenusSS.class, (boolean)true, (int)-43);
            planetVenus.setAllowSatellite(true);
        }
        phobosMars = new Moon("Phobos").setParentPlanet(MarsModule.planetMars);
        phobosMars.setRelativeSize(0.0017f);
        phobosMars.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(8.0f, 8.0f));
        phobosMars.setRelativeOrbitTime(100.0f);
        phobosMars.setTierRequired(2);
        phobosMars.setBodyIcon(GSResources.phobosTexture);
        if (GSConfigDimensions.enablePhobos) {
            phobosMars.setDimensionInfo(GSConfigDimensions.dimensionIDPhobos, WorldProviderPhobos.class);
            GalaxyRegistry.registerMoon((Moon)phobosMars);
            GalacticraftRegistry.registerTeleportType(WorldProviderPhobos.class, (ITeleportType)new TeleportTypeGS());
        }
        deimosMars = new Moon("Deimos").setParentPlanet(MarsModule.planetMars);
        deimosMars.setRelativeSize(0.0017f);
        deimosMars.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(16.0f, 16.0f));
        deimosMars.setRelativeOrbitTime(300.0f);
        deimosMars.setTierRequired(2);
        deimosMars.setBodyIcon(GSResources.deimosTexture);
        if (GSConfigDimensions.enableDeimos) {
            deimosMars.setDimensionInfo(GSConfigDimensions.dimensionIDDeimos, WorldProviderDeimos.class);
            GalaxyRegistry.registerMoon((Moon)deimosMars);
            GalacticraftRegistry.registerTeleportType(WorldProviderDeimos.class, (ITeleportType)new TeleportTypeGS());
        }
        marsSpaceStation = new Satellite("spaceStation.mars").setParentBody(MarsModule.planetMars);
        marsSpaceStation.setRelativeSize(0.2667f);
        marsSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(10.0f, 10.0f));
        marsSpaceStation.setRelativeOrbitTime(20.0f);
        marsSpaceStation.setTierRequired(2);
        marsSpaceStation.setBodyIcon(GSResources.spaceStationTexture);
        if (GSConfigDimensions.enableMarsSS) {
            marsSpaceStation.setDimensionInfo(GSConfigDimensions.dimensionIDMarsOrbit, GSConfigDimensions.dimensionIDMarsOrbitStatic, WorldProviderMarsSS.class);
            GalaxyRegistry.registerSatellite((Satellite)marsSpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderMarsSS.class, (ITeleportType)new TeleportTypeSpaceStationGS());
            GalacticraftRegistry.registerProvider((int)GSConfigDimensions.dimensionIDMarsOrbit, WorldProviderMarsSS.class, (boolean)false, (int)-40);
            GalacticraftRegistry.registerProvider((int)GSConfigDimensions.dimensionIDMarsOrbitStatic, WorldProviderMarsSS.class, (boolean)true, (int)-41);
            MarsModule.planetMars.setAllowSatellite(true);
        }
        planetCeres = new Planet("Ceres").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetCeres.setPhaseShift(2.0f);
        planetCeres.setTierRequired(3);
        planetCeres.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.5f, 1.5f));
        planetCeres.setRelativeOrbitTime(15.0f);
        planetCeres.setBodyIcon(GSResources.ceresTexture);
        if (GSConfigDimensions.enableCeres) {
            planetCeres.setDimensionInfo(GSConfigDimensions.dimensionIDCeres, WorldProviderCeres.class);
            GalaxyRegistry.registerPlanet((Planet)planetCeres);
            GalacticraftRegistry.registerTeleportType(WorldProviderCeres.class, (ITeleportType)new TeleportTypeGS());
        }
        AsteroidsModule.planetAsteroids.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.75f, 1.75f));
        planetJupiter = new Planet("jupiter").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetJupiter.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetJupiter.setPhaseShift((float)Math.PI);
        planetJupiter.setBodyIcon(GSResources.jupiterTexture);
        planetJupiter.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.0f, 2.0f));
        planetJupiter.setRelativeOrbitTime(11.861994f);
        planetJupiter.setDimensionInfo(GSConfigDimensions.dimensionIDJupiter, WorldProviderJupiter.class);
        GalaxyRegistry.registerPlanet((Planet)planetJupiter);
        jupiterSpaceStation = new Satellite("spaceStation.jupiter").setParentBody(planetJupiter);
        jupiterSpaceStation.setRelativeSize(0.2667f);
        jupiterSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(12.5f, 12.5f));
        jupiterSpaceStation.setRelativeOrbitTime(20.0f);
        jupiterSpaceStation.setTierRequired(3);
        jupiterSpaceStation.setBodyIcon(GSResources.spaceStationTexture);
        if (GSConfigDimensions.enableJupiterSS) {
            jupiterSpaceStation.setDimensionInfo(GSConfigDimensions.dimensionIDJupiterOrbit, GSConfigDimensions.dimensionIDJupiterOrbitStatic, WorldProviderJupiterSS.class);
            GalaxyRegistry.registerSatellite((Satellite)jupiterSpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderJupiterSS.class, (ITeleportType)new TeleportTypeSpaceStationGS());
            GalacticraftRegistry.registerProvider((int)GSConfigDimensions.dimensionIDJupiterOrbit, WorldProviderJupiterSS.class, (boolean)false, (int)-45);
            GalacticraftRegistry.registerProvider((int)GSConfigDimensions.dimensionIDJupiterOrbitStatic, WorldProviderJupiterSS.class, (boolean)true, (int)-44);
            planetJupiter.setAllowSatellite(true);
        }
        ioJupiter = new Moon("ioJupiter").setParentPlanet(planetJupiter);
        ioJupiter.setRelativeSize(0.0017f);
        ioJupiter.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(10.0f, 10.0f));
        ioJupiter.setRelativeOrbitTime(50.0f);
        ioJupiter.setTierRequired(4);
        ioJupiter.setBodyIcon(GSResources.ioTexture);
        if (GSConfigDimensions.enableIo) {
            ioJupiter.setDimensionInfo(GSConfigDimensions.dimensionIDIo, WorldProviderIo.class);
            GalaxyRegistry.registerMoon((Moon)ioJupiter);
            GalacticraftRegistry.registerTeleportType(WorldProviderIo.class, (ITeleportType)new TeleportTypeGS());
        }
        europaJupiter = new Moon("Europa").setParentPlanet(planetJupiter);
        europaJupiter.setRelativeSize(35.1f);
        europaJupiter.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(15.0f, 15.0f));
        europaJupiter.setRelativeOrbitTime(200.0f);
        europaJupiter.setTierRequired(3);
        europaJupiter.setBodyIcon(GSResources.europaTexture);
        if (GSConfigDimensions.enableEuropa) {
            europaJupiter.setDimensionInfo(GSConfigDimensions.dimensionIDEuropa, WorldProviderEuropa.class);
            GalaxyRegistry.registerMoon((Moon)europaJupiter);
            GalacticraftRegistry.registerTeleportType(WorldProviderEuropa.class, (ITeleportType)new TeleportTypeGS());
        }
        ganymedeJupiter = new Moon("Ganymed").setParentPlanet(planetJupiter);
        ganymedeJupiter.setRelativeSize(3.0517f);
        ganymedeJupiter.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(20.0f, 20.0f));
        ganymedeJupiter.setRelativeOrbitTime(350.0f);
        ganymedeJupiter.setTierRequired(3);
        ganymedeJupiter.setBodyIcon(GSResources.ganymedeTexture);
        if (GSConfigDimensions.enableGanymede) {
            ganymedeJupiter.setDimensionInfo(GSConfigDimensions.dimensionIDGanymede, WorldProviderGanymede.class);
            GalaxyRegistry.registerMoon((Moon)ganymedeJupiter);
            GalacticraftRegistry.registerTeleportType(WorldProviderGanymede.class, (ITeleportType)new TeleportTypeGS());
        }
        callistoJupiter = new Moon("Callisto").setParentPlanet(planetJupiter);
        callistoJupiter.setRelativeSize(14.5017f);
        callistoJupiter.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(30.0f, 30.0f));
        callistoJupiter.setRelativeOrbitTime(500.0f);
        callistoJupiter.setTierRequired(3);
        callistoJupiter.setBodyIcon(GSResources.callistoTexture);
        if (GSConfigDimensions.enableCallisto) {
            callistoJupiter.setDimensionInfo(GSConfigDimensions.dimensionIDCallisto, WorldProviderCallisto.class);
            GalaxyRegistry.registerMoon((Moon)callistoJupiter);
            GalacticraftRegistry.registerTeleportType(WorldProviderCallisto.class, (ITeleportType)new TeleportTypeGS());
        }
        planetSaturn = new Planet("saturn").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetSaturn.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetSaturn.setPhaseShift(5.45f);
        planetSaturn.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.25f, 2.25f));
        planetSaturn.setRelativeOrbitTime(29.463308f);
        planetSaturn.setBodyIcon(GSResources.saturnTexture);
        planetSaturn.setDimensionInfo(GSConfigDimensions.dimensionIDSaturn, WorldProviderSaturn.class);
        GalaxyRegistry.registerPlanet((Planet)planetSaturn);
        saturnSpaceStation = new Satellite("spaceStation.saturn").setParentBody(planetSaturn);
        saturnSpaceStation.setRelativeSize(0.2667f);
        saturnSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(12.5f, 12.5f));
        saturnSpaceStation.setRelativeOrbitTime(20.0f);
        saturnSpaceStation.setTierRequired(5);
        saturnSpaceStation.setBodyIcon(GSResources.spaceStationTexture);
        if (GSConfigDimensions.enableSaturnSS) {
            saturnSpaceStation.setDimensionInfo(GSConfigDimensions.dimensionIDSaturnOrbit, GSConfigDimensions.dimensionIDSaturnOrbitStatic, WorldProviderSaturnSS.class);
            GalaxyRegistry.registerSatellite((Satellite)saturnSpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderSaturnSS.class, (ITeleportType)new TeleportTypeSpaceStationGS());
            GalacticraftRegistry.registerProvider((int)GSConfigDimensions.dimensionIDSaturnOrbit, WorldProviderSaturnSS.class, (boolean)false, (int)-47);
            GalacticraftRegistry.registerProvider((int)GSConfigDimensions.dimensionIDSaturnOrbitStatic, WorldProviderSaturnSS.class, (boolean)true, (int)-46);
            planetSaturn.setAllowSatellite(true);
        }
        mimasSaturn = new Moon("Mimas").setParentPlanet(planetSaturn);
        mimasSaturn.setRelativeSize(5.0017f);
        mimasSaturn.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(10.0f, 10.0f));
        mimasSaturn.setRelativeOrbitTime(20.0f);
        mimasSaturn.setBodyIcon(GSResources.mimasTexture);
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerMoon((Moon)mimasSaturn);
        }
        enceladusSaturn = new Moon("Enceladus").setParentPlanet(planetSaturn);
        enceladusSaturn.setRelativeSize(8.0017f);
        enceladusSaturn.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(15.0f, 15.0f));
        enceladusSaturn.setRelativeOrbitTime(50.0f);
        enceladusSaturn.setTierRequired(5);
        enceladusSaturn.setBodyIcon(GSResources.enceladusTexture);
        if (GSConfigDimensions.enableEnceladus) {
            enceladusSaturn.setDimensionInfo(GSConfigDimensions.dimensionIDEnceladus, WorldProviderEnceladus.class);
            GalaxyRegistry.registerMoon((Moon)enceladusSaturn);
            GalacticraftRegistry.registerTeleportType(WorldProviderEnceladus.class, (ITeleportType)new TeleportTypeGS());
        }
        tethysSaturn = new Moon("Tethys").setParentPlanet(planetSaturn);
        tethysSaturn.setRelativeSize(15.0f);
        tethysSaturn.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(20.0f, 20.0f));
        tethysSaturn.setRelativeOrbitTime(120.0f);
        tethysSaturn.setBodyIcon(GSResources.tethysTexture);
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerMoon((Moon)tethysSaturn);
        }
        dioneSaturn = new Moon("Dione").setParentPlanet(planetSaturn);
        dioneSaturn.setRelativeSize(28.0f);
        dioneSaturn.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(25.0f, 25.0f));
        dioneSaturn.setRelativeOrbitTime(180.0f);
        dioneSaturn.setBodyIcon(GSResources.dioneTexture);
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerMoon((Moon)dioneSaturn);
        }
        rheyaSaturn = new Moon("Rheya").setParentPlanet(planetSaturn);
        rheyaSaturn.setRelativeSize(50.0f);
        rheyaSaturn.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(30.0f, 30.0f));
        rheyaSaturn.setRelativeOrbitTime(220.0f);
        rheyaSaturn.setBodyIcon(GSResources.rheyaTexture);
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerMoon((Moon)rheyaSaturn);
        }
        titanSaturn = new Moon("Titan").setParentPlanet(planetSaturn);
        titanSaturn.setRelativeSize(80.12123f);
        titanSaturn.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(35.0f, 35.0f));
        titanSaturn.setRelativeOrbitTime(280.0f);
        titanSaturn.setTierRequired(5);
        titanSaturn.setBodyIcon(GSResources.titanTexture);
        titanSaturn.atmosphereComponent(IAtmosphericGas.NITROGEN);
        if (GSConfigDimensions.enableTitan) {
            titanSaturn.setDimensionInfo(GSConfigDimensions.dimensionIDTitan, WorldProviderTitan.class);
            GalaxyRegistry.registerMoon((Moon)titanSaturn);
            GalacticraftRegistry.registerTeleportType(WorldProviderTitan.class, (ITeleportType)new TeleportTypeGS());
        }
        iapetusSaturn = new Moon("Iapetus").setParentPlanet(planetSaturn);
        iapetusSaturn.setRelativeSize(-180.0017f);
        iapetusSaturn.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(40.0f, 40.0f));
        iapetusSaturn.setRelativeOrbitTime(350.0f);
        iapetusSaturn.setBodyIcon(GSResources.iapetusTexture);
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerMoon((Moon)iapetusSaturn);
        }
        planetUranus = new Planet("uranus").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetUranus.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetUranus.setPhaseShift(1.38f);
        planetUranus.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.5f, 2.5f));
        planetUranus.setRelativeOrbitTime(84.06353f);
        planetUranus.setBodyIcon(GSResources.uranusTexture);
        planetUranus.setDimensionInfo(GSConfigDimensions.dimensionIDUranus, WorldProviderUranus.class);
        GalaxyRegistry.registerPlanet((Planet)planetUranus);
        uranusSpaceStation = new Satellite("spaceStation.uranus").setParentBody(planetUranus);
        uranusSpaceStation.setRelativeSize(0.2667f);
        uranusSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(12.5f, 12.5f));
        uranusSpaceStation.setRelativeOrbitTime(20.0f);
        uranusSpaceStation.setTierRequired(5);
        uranusSpaceStation.setBodyIcon(GSResources.spaceStationTexture);
        if (GSConfigDimensions.enableUranusSS) {
            uranusSpaceStation.setDimensionInfo(GSConfigDimensions.dimensionIDUranusOrbit, GSConfigDimensions.dimensionIDUranusOrbitStatic, WorldProviderUranusSS.class);
            GalaxyRegistry.registerSatellite((Satellite)uranusSpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderUranusSS.class, (ITeleportType)new TeleportTypeSpaceStationGS());
            GalacticraftRegistry.registerProvider((int)GSConfigDimensions.dimensionIDUranusOrbit, WorldProviderUranusSS.class, (boolean)false, (int)-49);
            GalacticraftRegistry.registerProvider((int)GSConfigDimensions.dimensionIDUranusOrbitStatic, WorldProviderUranusSS.class, (boolean)true, (int)-48);
            planetUranus.setAllowSatellite(true);
        }
        mirandaUranus = new Moon("Miranda").setParentPlanet(planetUranus);
        mirandaUranus.setRelativeSize(10.0f);
        mirandaUranus.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(10.0f, 10.0f));
        mirandaUranus.setRelativeOrbitTime(20.0f);
        mirandaUranus.setTierRequired(5);
        mirandaUranus.setBodyIcon(GSResources.mirandaTexture);
        if (GSConfigDimensions.enableMiranda) {
            mirandaUranus.setDimensionInfo(GSConfigDimensions.dimensionIDMiranda, WorldProviderMiranda.class);
            GalaxyRegistry.registerMoon((Moon)mirandaUranus);
            GalacticraftRegistry.registerTeleportType(WorldProviderMiranda.class, (ITeleportType)new TeleportTypeGS());
        }
        arielUranus = new Moon("Ariel").setParentPlanet(planetUranus);
        arielUranus.setRelativeSize(30.0f);
        arielUranus.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(15.0f, 15.0f));
        arielUranus.setRelativeOrbitTime(50.0f);
        arielUranus.setBodyIcon(GSResources.arielTexture);
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerMoon((Moon)arielUranus);
        }
        umbrielUranus = new Moon("Umbriel").setParentPlanet(planetUranus);
        umbrielUranus.setRelativeSize(70.0f);
        umbrielUranus.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(20.0f, 20.0f));
        umbrielUranus.setRelativeOrbitTime(120.0f);
        umbrielUranus.setBodyIcon(GSResources.umbrielTexture);
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerMoon((Moon)umbrielUranus);
        }
        titaniaUranus = new Moon("Titania").setParentPlanet(planetUranus);
        titaniaUranus.setRelativeSize(120.0f);
        titaniaUranus.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(25.0f, 25.0f));
        titaniaUranus.setRelativeOrbitTime(180.0f);
        titaniaUranus.setBodyIcon(GSResources.titaniaTexture);
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerMoon((Moon)titaniaUranus);
        }
        oberonUranus = new Moon("Oberon").setParentPlanet(planetUranus);
        oberonUranus.setRelativeSize(150.12123f);
        oberonUranus.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(30.0f, 30.0f));
        oberonUranus.setRelativeOrbitTime(200.0f);
        oberonUranus.setTierRequired(5);
        oberonUranus.setBodyIcon(GSResources.oberonTexture);
        if (GSConfigDimensions.enableOberon) {
            oberonUranus.setDimensionInfo(GSConfigDimensions.dimensionIDOberon, WorldProviderOberon.class);
            GalaxyRegistry.registerMoon((Moon)oberonUranus);
            GalacticraftRegistry.registerTeleportType(WorldProviderOberon.class, (ITeleportType)new TeleportTypeGS());
        }
        planetNeptune = new Planet("neptune").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetNeptune.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetNeptune.setPhaseShift(1.0f);
        planetNeptune.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.75f, 2.75f));
        planetNeptune.setRelativeOrbitTime(164.84119f);
        planetNeptune.setBodyIcon(GSResources.neptuneTexture);
        planetNeptune.setDimensionInfo(GSConfigDimensions.dimensionIDNeptune, WorldProviderNeptune.class);
        GalaxyRegistry.registerPlanet((Planet)planetNeptune);
        neptuneSpaceStation = new Satellite("spaceStation.neptune").setParentBody(planetNeptune);
        neptuneSpaceStation.setRelativeSize(0.2667f);
        neptuneSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(15.0f, 15.0f));
        neptuneSpaceStation.setRelativeOrbitTime(20.0f);
        neptuneSpaceStation.setTierRequired(6);
        neptuneSpaceStation.setBodyIcon(GSResources.spaceStationTexture);
        if (GSConfigDimensions.enableNeptuneSS) {
            neptuneSpaceStation.setDimensionInfo(GSConfigDimensions.dimensionIDNeptuneOrbit, GSConfigDimensions.dimensionIDNeptuneOrbitStatic, WorldProviderNeptuneSS.class);
            GalaxyRegistry.registerSatellite((Satellite)neptuneSpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderNeptuneSS.class, (ITeleportType)new TeleportTypeSpaceStationGS());
            GalacticraftRegistry.registerProvider((int)GSConfigDimensions.dimensionIDNeptuneOrbit, WorldProviderNeptuneSS.class, (boolean)false, (int)-51);
            GalacticraftRegistry.registerProvider((int)GSConfigDimensions.dimensionIDNeptuneOrbitStatic, WorldProviderNeptuneSS.class, (boolean)true, (int)-50);
            planetNeptune.setAllowSatellite(true);
        }
        proteusNeptune = new Moon("Proteus").setParentPlanet(planetNeptune);
        proteusNeptune.setRelativeSize(0.0017f);
        proteusNeptune.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(10.0f, 10.0f));
        proteusNeptune.setRelativeOrbitTime(50.0f);
        proteusNeptune.setTierRequired(6);
        proteusNeptune.setBodyIcon(GSResources.proteusTexture);
        if (GSConfigDimensions.enableProteus) {
            proteusNeptune.setDimensionInfo(GSConfigDimensions.dimensionIDProteus, WorldProviderProteus.class);
            GalaxyRegistry.registerMoon((Moon)proteusNeptune);
            GalacticraftRegistry.registerTeleportType(WorldProviderProteus.class, (ITeleportType)new TeleportTypeGS());
        }
        tritonNeptune = new Moon("Triton").setParentPlanet(planetNeptune);
        tritonNeptune.setRelativeSize(150.12123f);
        tritonNeptune.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(25.0f, 25.0f));
        tritonNeptune.setRelativeOrbitTime(200.0f);
        tritonNeptune.setTierRequired(6);
        tritonNeptune.setBodyIcon(GSResources.tritonTexture);
        if (GSConfigDimensions.enableTriton) {
            tritonNeptune.setDimensionInfo(GSConfigDimensions.dimensionIDTriton, WorldProviderTriton.class);
            GalaxyRegistry.registerMoon((Moon)tritonNeptune);
            GalacticraftRegistry.registerTeleportType(WorldProviderTriton.class, (ITeleportType)new TeleportTypeGS());
        }
        planetPluto = new Planet("pluto").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetPluto.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetPluto.setPhaseShift(0.1f);
        planetPluto.setTierRequired(7);
        planetPluto.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(3.0f, 3.0f));
        planetPluto.setRelativeOrbitTime(250.9f);
        planetPluto.setBodyIcon(GSResources.plutoTexture);
        if (GSConfigDimensions.enablePluto) {
            planetPluto.setDimensionInfo(GSConfigDimensions.dimensionIDPluto, WorldProviderPluto.class);
            GalaxyRegistry.registerPlanet((Planet)planetPluto);
            GalacticraftRegistry.registerTeleportType(WorldProviderPluto.class, (ITeleportType)new TeleportTypePluto());
        }
        charonPluto = new Moon("Charon").setParentPlanet(planetPluto);
        charonPluto.setRelativeSize(0.0017f);
        charonPluto.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(10.0f, 10.0f));
        charonPluto.setRelativeOrbitTime(50.0f);
        charonPluto.setBodyIcon(GSResources.charonTexture);
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerMoon((Moon)charonPluto);
        }
        planetKuiperBelt = new Planet("kuiperbelt").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetKuiperBelt.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetKuiperBelt.setPhaseShift(1.5f);
        planetKuiperBelt.setTierRequired(7);
        planetKuiperBelt.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(3.25f, 3.25f));
        planetKuiperBelt.setRelativeOrbitTime(300.9f);
        planetKuiperBelt.setBodyIcon(GSResources.kuiperBeltTexture);
        planetKuiperBelt.setDimensionInfo(GSConfigDimensions.dimensionIDKuiperBelt, WorldProviderKuiper.class);
        GalaxyRegistry.registerPlanet((Planet)planetKuiperBelt);
        GalacticraftRegistry.registerTeleportType(WorldProviderKuiper.class, (ITeleportType)new TeleportTypeKuiper());
        planetHaumea = new Planet("haumea").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetHaumea.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetHaumea.setPhaseShift(21.5f);
        planetHaumea.setTierRequired(7);
        planetHaumea.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(3.5f, 3.5f));
        planetHaumea.setRelativeOrbitTime(280.9f);
        planetHaumea.setBodyIcon(GSResources.haumeaTexture);
        if (GSConfigDimensions.enableHaumea) {
            planetHaumea.setDimensionInfo(GSConfigDimensions.dimensionIDHaumea, WorldProviderHaumea.class);
            GalaxyRegistry.registerPlanet((Planet)planetHaumea);
            GalacticraftRegistry.registerTeleportType(WorldProviderHaumea.class, (ITeleportType)new TeleportTypeGS());
        }
        planetMakemake = new Planet("makemake").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetMakemake.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetMakemake.setPhaseShift(11.5f);
        planetMakemake.setTierRequired(7);
        planetMakemake.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(3.75f, 3.75f));
        planetMakemake.setRelativeOrbitTime(300.9f);
        planetMakemake.setBodyIcon(GSResources.makemakeTexture);
        if (GSConfigDimensions.enableMakemake) {
            planetMakemake.setDimensionInfo(GSConfigDimensions.dimensionIDMakemake, WorldProviderMakemake.class);
            GalaxyRegistry.registerPlanet((Planet)planetMakemake);
            GalacticraftRegistry.registerTeleportType(WorldProviderMakemake.class, (ITeleportType)new TeleportTypeGS());
        }
        planetEris = new Planet("eris").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetEris.setRingColorRGB(0.1f, 0.9f, 0.6f);
        planetEris.setPhaseShift(41.5f);
        planetEris.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(4.0f, 4.0f));
        planetEris.setRelativeOrbitTime(360.9f);
        planetEris.setBodyIcon(GSResources.erisTexture);
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerPlanet((Planet)planetEris);
        }
    }

    public static void setUnreachables() {
        planetJupiter.setUnreachable();
        planetSaturn.setUnreachable();
        planetUranus.setUnreachable();
        planetNeptune.setUnreachable();
    }
}

