/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.items.tools;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import fox.spiteful.avaritia.Avaritia;
import fox.spiteful.avaritia.entity.EntityImmortalItem;
import fox.spiteful.avaritia.items.LudicrousItems;
import fox.spiteful.avaritia.items.tools.ToolHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemAxeInfinity
extends ItemAxe {
    private static final Item.ToolMaterial opAxe = EnumHelper.addToolMaterial((String)"INFINITY_PICKAXE", (int)32, (int)9999, (float)9999.0f, (float)20.0f, (int)200);
    private static Map<Integer, List<BlockSwapper>> blockSwappers = new HashMap<Integer, List<BlockSwapper>>();

    public ItemAxeInfinity() {
        super(opAxe);
        this.func_77655_b("infinity_axe");
        this.func_111206_d("avaritia:infinity_axe");
        this.func_77637_a(Avaritia.tab);
        FMLCommonHandler.instance().bus().register((Object)new EventHandler());
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return LudicrousItems.cosmic;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta) || block.func_149688_o() == Material.field_151584_j) {
            return this.field_77864_a;
        }
        return Math.max(this.func_150893_a(stack, block), 6.0f);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            player.func_71038_i();
            int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
            boolean silk = EnchantmentHelper.func_77502_d((EntityLivingBase)player);
            int range = 13;
            ToolHelper.removeBlocksInIteration(player, stack, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, -range, -3, -range, range, range * 2 - 3, range, null, ToolHelper.materialsAxe, silk, fortune, false);
        }
        return stack;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        MovingObjectPosition raycast = ToolHelper.raytraceFromEntity(player.field_70170_p, (Entity)player, true, 10.0);
        if (raycast != null) {
            this.breakOtherBlock(player, stack, x, y, z, x, y, z, raycast.field_72310_e);
        }
        return false;
    }

    public void breakOtherBlock(EntityPlayer player, ItemStack stack, int x, int y, int z, int originX, int originY, int originZ, int side) {
        if (player.func_70093_af()) {
            return;
        }
        ChunkCoordinates coords = new ChunkCoordinates(x, y, z);
        ItemAxeInfinity.addBlockSwapper(player.field_70170_p, player, stack, coords, coords, 32, false, true, new ArrayList<String>());
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityImmortalItem(world, location, itemstack);
    }

    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        return false;
    }

    private static BlockSwapper addBlockSwapper(World world, EntityPlayer player, ItemStack stack, ChunkCoordinates origCoords, ChunkCoordinates coords, int steps, boolean leaves, boolean force, List<String> posChecked) {
        BlockSwapper swapper = new BlockSwapper(world, player, stack, origCoords, coords, steps, leaves, force, posChecked);
        int dim = world.field_73011_w.field_76574_g;
        if (!blockSwappers.containsKey(dim)) {
            blockSwappers.put(dim, new ArrayList());
        }
        blockSwappers.get(dim).add(swapper);
        return swapper;
    }

    private static class BlockSwapper {
        final World world;
        final EntityPlayer player;
        final ItemStack stack;
        final ChunkCoordinates origCoords;
        final int steps;
        final ChunkCoordinates coords;
        final boolean leaves;
        final boolean force;
        final List<String> posChecked;

        BlockSwapper(World world, EntityPlayer player, ItemStack stack, ChunkCoordinates origCoords, ChunkCoordinates coords, int steps, boolean leaves, boolean force, List<String> posChecked) {
            this.world = world;
            this.player = player;
            this.stack = stack;
            this.origCoords = origCoords;
            this.coords = coords;
            this.steps = steps;
            this.leaves = leaves;
            this.force = force;
            this.posChecked = posChecked;
        }

        void tick() {
            Block blockat = this.world.func_147439_a(this.coords.field_71574_a, this.coords.field_71572_b, this.coords.field_71573_c);
            if (!this.force && blockat.isAir((IBlockAccess)this.world, this.coords.field_71574_a, this.coords.field_71572_b, this.coords.field_71573_c)) {
                return;
            }
            ToolHelper.removeBlockWithDrops(this.player, this.stack, this.world, this.coords.field_71574_a, this.coords.field_71572_b, this.coords.field_71573_c, null, ToolHelper.materialsAxe, EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)this.stack) > 0, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)this.stack), 0.0f, false);
            if (this.steps == 0) {
                return;
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                int x = this.coords.field_71574_a + dir.offsetX;
                int y = this.coords.field_71572_b + dir.offsetY;
                int z = this.coords.field_71573_c + dir.offsetZ;
                String pstr = this.posStr(x, y, z);
                if (this.posChecked.contains(pstr)) continue;
                Block block = this.world.func_147439_a(x, y, z);
                boolean log = block.isWood((IBlockAccess)this.world, x, y, z);
                boolean leaf = block.isLeaves((IBlockAccess)this.world, x, y, z);
                if (!log && !leaf) continue;
                int steps = this.steps - 1;
                steps = leaf ? (this.leaves ? steps : 3) : steps;
                ItemAxeInfinity.addBlockSwapper(this.world, this.player, this.stack, this.origCoords, new ChunkCoordinates(x, y, z), steps, leaf, false, this.posChecked);
                this.posChecked.add(pstr);
            }
        }

        String posStr(int x, int y, int z) {
            return x + ":" + y + ":" + z;
        }
    }

    public static class EventHandler {
        @SubscribeEvent
        public void onTickEnd(TickEvent.WorldTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                int dim = event.world.field_73011_w.field_76574_g;
                if (blockSwappers.containsKey(dim)) {
                    List swappers = (List)blockSwappers.get(dim);
                    ArrayList swappersSafe = new ArrayList(swappers);
                    swappers.clear();
                    for (BlockSwapper s : swappersSafe) {
                        if (s == null) continue;
                        s.tick();
                    }
                }
            }
        }
    }
}

