/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.items;

import com.google.common.collect.HashMultimap;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fox.spiteful.avaritia.Avaritia;
import fox.spiteful.avaritia.items.ItemStackWrapper;
import fox.spiteful.avaritia.items.LudicrousItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.OreDictionary;

public class ItemFracturedOre
extends Item {
    public static final String OREKEY = "ore";
    protected static List<ItemStack> emulatedOres = new ArrayList<ItemStack>();
    protected static Map<String, ItemStack> nameMapping = new HashMap<String, ItemStack>();
    public static IIcon unknownIcon;

    public ItemFracturedOre() {
        this.func_77637_a(Avaritia.tab);
        this.func_77655_b("avaritia_fracturedore");
        this.func_111206_d("avaritia:fracturedore");
        this.func_77627_a(true);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
    }

    public ItemStack getStackForOre(ItemStack orestack, int stacksize) {
        NBTTagCompound oretag = NameStack.saveStackToNBT(orestack);
        ItemStack outstack = new ItemStack((Item)this, stacksize, 0);
        NBTTagCompound stacktag = new NBTTagCompound();
        stacktag.func_74782_a(OREKEY, (NBTBase)oretag);
        outstack.func_77982_d(stacktag);
        outstack.func_77964_b(this.getDamage(outstack));
        return outstack;
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound tag;
        NameStack namestack;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(OREKEY) && (namestack = NameStack.loadFromNBT(tag = stack.func_77978_p().func_74775_l(OREKEY))) != null) {
            ItemStack orestack = namestack.getStack();
            Item oreitem = orestack.func_77973_b();
            return StatCollector.func_74838_a((String)"item.avaritia_fracturedore.prefix") + " " + oreitem.func_77653_i(orestack);
        }
        return super.func_77653_i(stack);
    }

    public int getDamage(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(OREKEY)) {
            NameStack nstack = NameStack.loadFromNBT(stack.func_77978_p().func_74775_l(OREKEY));
            int id = Item.func_150891_b((Item)nstack.getItem());
            int meta = nstack.damage;
            int out = meta + (id << 4);
            stack.func_77964_b(out);
            return out;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        super.func_94581_a(ir);
        unknownIcon = ir.func_94245_a("avaritia:unknown");
    }

    public static void brushUpUncomfortablyAgainstTheOreDictionary() {
        String[] names = OreDictionary.getOreNames();
        ItemFracturedOre fracore = (ItemFracturedOre)LudicrousItems.fractured_ore;
        HashMultimap toRegister = HashMultimap.create();
        HashSet<ItemStackWrapper> antiDupePool = new HashSet<ItemStackWrapper>();
        for (String name : names) {
            if (!name.startsWith(OREKEY) || name.startsWith("oreberry")) continue;
            ArrayList ores = OreDictionary.getOres((String)name);
            for (ItemStack ore : ores) {
                ItemStackWrapper compare = new ItemStackWrapper(ore);
                if (antiDupePool.contains(compare)) continue;
                antiDupePool.add(compare);
                emulatedOres.add(ore.func_77946_l());
                ItemStack frac = fracore.getStackForOre(ore, 1);
                toRegister.put((Object)name, (Object)frac);
            }
        }
        for (String name : toRegister.keySet()) {
            Collection stacks = toRegister.get((Object)name);
            for (ItemStack stack : stacks) {
                ItemStack orestack = NameStack.loadFromNBT(stack.func_77978_p().func_74775_l(OREKEY)).getStack();
                int[] oreids = OreDictionary.getOreIDs((ItemStack)orestack);
                for (int i = 0; i < oreids.length; ++i) {
                    String oreidname = OreDictionary.getOreName((int)oreids[i]);
                    OreDictionary.registerOre((String)oreidname, (ItemStack)stack);
                }
                ItemStack smeltingResult = FurnaceRecipes.func_77602_a().func_151395_a(orestack);
                if (smeltingResult == null) continue;
                float exp = FurnaceRecipes.func_77602_a().func_151398_b(orestack);
                GameRegistry.addSmelting((ItemStack)stack, (ItemStack)smeltingResult, (float)exp);
            }
        }
    }

    public static class NameStack {
        String name;
        int damage;
        NBTTagCompound tag;
        int size;

        public NameStack(ItemStack source) {
            this(source.func_77973_b().delegate.name(), source.func_77960_j(), source.field_77994_a, source.func_77978_p());
        }

        public NameStack(String name, int damage, int size, NBTTagCompound nbt) {
            this.name = name;
            this.damage = damage;
            this.tag = nbt;
            this.size = size;
        }

        public NBTTagCompound saveToNBT() {
            NBTTagCompound savetag = new NBTTagCompound();
            savetag.func_74768_a("meta", this.damage);
            if (this.tag != null) {
                savetag.func_74782_a("nbt", (NBTBase)this.tag);
            }
            savetag.func_74778_a("name", this.name);
            savetag.func_74768_a("size", this.size);
            return savetag;
        }

        public static NameStack loadFromNBT(NBTTagCompound tag) {
            NBTTagCompound stacktag = null;
            if (tag.func_74764_b("nbt")) {
                stacktag = tag.func_74775_l("nbt");
            }
            return new NameStack(tag.func_74779_i("name"), tag.func_74762_e("meta"), tag.func_74762_e("size"), stacktag);
        }

        public Item getItem() {
            return (Item)Item.field_150901_e.func_82594_a(this.name);
        }

        public static NBTTagCompound saveStackToNBT(ItemStack stack) {
            return new NameStack(stack).saveToNBT();
        }

        public ItemStack getStack() {
            ItemStack stack = new ItemStack(this.getItem(), this.size, this.damage);
            if (this.tag != null) {
                stack.func_77982_d((NBTTagCompound)this.tag.func_74737_b());
            }
            return stack;
        }

        public String toString() {
            return "NameStack: " + this.size + "x " + this.name + "@" + this.damage + ", " + this.tag;
        }
    }
}

