/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class StackTankHolder {
    private FluidStack fluidStack;
    private IFluidHandler tank;
    private ForgeDirection side;
    private int sizeLeft;

    public StackTankHolder(FluidStack fluidStack, IFluidHandler tank, ForgeDirection side) {
        this.fluidStack = fluidStack;
        this.tank = tank;
        this.side = side;
        if (fluidStack != null) {
            this.sizeLeft = fluidStack.amount;
        }
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public IFluidHandler getTank() {
        return this.tank;
    }

    public ForgeDirection getSide() {
        return this.side;
    }

    public void reduceAmount(int val) {
        this.sizeLeft -= val;
        this.fluidStack.amount -= val;
    }

    public int getSizeLeft() {
        return Math.min(this.fluidStack.amount, this.sizeLeft);
    }

    public StackTankHolder getSplitElement(int elementAmount, int id, boolean fair) {
        int amountLeft;
        StackTankHolder element = new StackTankHolder(this.fluidStack, this.tank, this.side);
        int oldAmount = this.getSizeLeft();
        int amount = oldAmount / elementAmount;
        if (!fair && id < (amountLeft = oldAmount % elementAmount)) {
            ++amount;
        }
        element.sizeLeft = amount;
        return element;
    }
}

