/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.reference;

import com.google.common.collect.Iterables;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import java.util.HashMap;

public class Mods {
    public static final String AsieLib = "asielib";
    public static final String AsieLib_NAME = "AsieLib";
    public static final String AE2 = "appliedenergistics2";
    public static final String IC2 = "IC2";
    public static final String Mekanism = "Mekanism";
    public static final String ProjectRed = "ProjRed|Core";
    public static final String RedLogic = "RedLogic";
    private static HashMap<String, ArtifactVersion> modVersionList;
    private static boolean checkedEnergyMods;
    private static boolean hasEnergyMod;

    public static boolean isLoaded(String name) {
        return Loader.isModLoaded((String)name);
    }

    public static ArtifactVersion getVersion(String name) {
        if (modVersionList == null) {
            modVersionList = new HashMap();
            for (ModContainer api : Iterables.concat((Iterable)Loader.instance().getActiveModList(), (Iterable)ModAPIManager.INSTANCE.getAPIList())) {
                modVersionList.put(api.getModId(), api.getProcessedVersion());
            }
        }
        if (modVersionList.containsKey(name)) {
            return modVersionList.get(name);
        }
        throw new IllegalArgumentException("Mod/API '" + name + "' does not exist!");
    }

    public static boolean hasVersion(String name, String version) {
        if (Mods.isLoaded(name) || API.hasAPI(name)) {
            ArtifactVersion v1 = VersionParser.parseVersionReference((String)(name + "@" + version));
            ArtifactVersion v2 = Mods.getVersion(name);
            return v1.containsVersion(v2);
        }
        return false;
    }

    public static boolean hasEnergyMod() {
        if (!checkedEnergyMods) {
            hasEnergyMod = API.hasAPI("CoFHAPI|energy") || Mods.isLoaded(IC2);
            checkedEnergyMods = true;
        }
        return hasEnergyMod;
    }

    static {
        checkedEnergyMods = false;
        hasEnergyMod = false;
    }

    public static class API {
        public static final String BuildCraftTools = "BuildCraftAPI|tools";
        public static final String CoFHBlocks = "CoFHAPI|block";
        public static final String CoFHEnergy = "CoFHAPI|energy";
        public static final String CoFHItems = "CoFHAPI|item";
        public static final String CoFHTileEntities = "CoFHAPI|tileentity";
        public static final String EiraIRC = "EiraIRC|API";
        public static final String EnderIOTools = "EnderIOAPI|Tools";
        public static final String OpenComputersInternal = "OpenComputersAPI|Internal";

        public static boolean hasAPI(String name) {
            return ModAPIManager.INSTANCE.hasAPI(name);
        }
    }
}

