/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.audio;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.GraviSuite;
import gravisuite.audio.AudioManagerClient;
import gravisuite.audio.AudioPosition;
import gravisuite.audio.PositionSpec;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import paulscode.sound.SoundSystem;

@SideOnly(value=Side.CLIENT)
public final class AudioSource
implements Comparable<AudioSource> {
    private SoundSystem soundSystem;
    private String sourceName;
    private boolean valid = false;
    private boolean culled = false;
    private Reference<Object> obj;
    private AudioPosition position;
    private PositionSpec positionSpec;
    private float configuredVolume;
    private float realVolume;
    private boolean isPlaying = false;

    public AudioSource(SoundSystem soundSystem1, String sourceName1, Object obj1, PositionSpec positionSpec1, String initialSoundFile, boolean loop, boolean priorized, float volume) {
        this.soundSystem = soundSystem1;
        this.sourceName = sourceName1;
        this.obj = new WeakReference<Object>(obj1);
        this.positionSpec = positionSpec1;
        URL url = AudioSource.class.getClassLoader().getResource("assets/gravisuite/sounds/" + initialSoundFile);
        if (url == null) {
            GraviSuite.addLog("Invalid sound file: " + initialSoundFile);
            return;
        }
        this.position = AudioPosition.getFrom(obj1, positionSpec1);
        soundSystem1.newSource(priorized, sourceName1, url, initialSoundFile, loop, this.position.x, this.position.y, this.position.z, 0, ((AudioManagerClient)GraviSuite.audioManager).fadingDistance * Math.max(volume, 1.0f));
        this.valid = true;
        this.setVolume(volume);
    }

    @Override
    public int compareTo(AudioSource x) {
        if (this.culled) {
            return (int)((this.realVolume * 0.9f - x.realVolume) * 128.0f);
        }
        return (int)((this.realVolume - x.realVolume) * 128.0f);
    }

    public void remove() {
        if (!this.check()) {
            return;
        }
        if (this.sourceName == null) {
            return;
        }
        this.stop();
        this.soundSystem.removeSource(this.sourceName);
        this.sourceName = null;
        this.valid = false;
    }

    public void play() {
        if (!this.check()) {
            return;
        }
        if (this.isPlaying) {
            return;
        }
        this.isPlaying = true;
        if (this.culled) {
            return;
        }
        this.soundSystem.play(this.sourceName);
    }

    public void pause() {
        if (!this.check()) {
            return;
        }
        if (!this.isPlaying || this.culled) {
            return;
        }
        this.isPlaying = false;
        this.soundSystem.pause(this.sourceName);
    }

    public void stop() {
        if (!this.check() || !this.isPlaying) {
            return;
        }
        this.isPlaying = false;
        if (this.culled) {
            return;
        }
        this.soundSystem.stop(this.sourceName);
    }

    public void flush() {
        if (!this.check()) {
            return;
        }
        if (!this.isPlaying || this.culled) {
            return;
        }
        this.soundSystem.flush(this.sourceName);
    }

    public void cull() {
        if (!this.check() || this.culled) {
            return;
        }
        this.soundSystem.cull(this.sourceName);
        this.culled = true;
    }

    public void activate() {
        if (!this.check() || !this.culled) {
            return;
        }
        this.soundSystem.activate(this.sourceName);
        this.culled = false;
        if (this.isPlaying) {
            this.isPlaying = false;
            this.play();
        }
    }

    public float getVolume() {
        if (!this.check()) {
            return 0.0f;
        }
        return this.soundSystem.getVolume(this.sourceName);
    }

    public float getRealVolume() {
        return this.realVolume;
    }

    public void setVolume(float volume) {
        if (!this.check()) {
            return;
        }
        this.configuredVolume = volume;
        this.soundSystem.setVolume(this.sourceName, 0.001f);
    }

    public void setPitch(float pitch) {
        if (!this.check()) {
            return;
        }
        this.soundSystem.setPitch(this.sourceName, pitch);
    }

    public void updatePosition() {
        if (!this.check()) {
            return;
        }
        this.position = AudioPosition.getFrom(this.obj.get(), this.positionSpec);
        if (this.position == null) {
            return;
        }
        this.soundSystem.setPosition(this.sourceName, this.position.x, this.position.y, this.position.z);
    }

    public void updateVolume(EntityPlayer player) {
        float distance;
        if (!this.check() || !this.isPlaying) {
            this.realVolume = 0.0f;
            return;
        }
        float maxDistance = ((AudioManagerClient)GraviSuite.audioManager).fadingDistance * Math.max(this.configuredVolume, 1.0f);
        float rolloffFactor = 1.0f;
        float referenceDistance = 1.0f;
        float x = (float)player.field_70165_t;
        float y = (float)player.field_70163_u;
        float z = (float)player.field_70161_v;
        if (this.position != null && this.position.getWorld() == player.field_70170_p) {
            float deltaX = this.position.x - x;
            float deltaY = this.position.y - y;
            float deltaZ = this.position.z - z;
            distance = (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        } else {
            distance = 1.0f;
        }
        if (distance > maxDistance) {
            this.realVolume = 0.0f;
            this.cull();
            return;
        }
        if (distance < referenceDistance) {
            distance = referenceDistance;
        }
        float gain = 1.0f - rolloffFactor * (distance - referenceDistance) / (maxDistance - referenceDistance);
        float newRealVolume = gain * this.configuredVolume * GraviSuite.audioManager.getMasterVolume();
        float dx = (this.position.x - x) / distance;
        float dy = (this.position.y - y) / distance;
        float dz = (this.position.z - z) / distance;
        if ((double)newRealVolume > 0.1) {
            int i = 0;
            while ((float)i < distance) {
                int zi;
                int yi;
                int xi = AudioSource.roundToNegInf(x);
                Block block = player.field_70170_p.func_147439_a(xi, yi = AudioSource.roundToNegInf(y), zi = AudioSource.roundToNegInf(z));
                if (!block.isAir((IBlockAccess)player.field_70170_p, xi, yi, zi)) {
                    newRealVolume = block.isNormalCube((IBlockAccess)player.field_70170_p, xi, yi, zi) ? (newRealVolume *= 0.6f) : (newRealVolume *= 0.8f);
                }
                x += dx;
                y += dy;
                z += dz;
                ++i;
            }
        }
        if ((double)Math.abs(this.realVolume / newRealVolume - 1.0f) > 0.06) {
            this.soundSystem.setVolume(this.sourceName, GraviSuite.audioManager.getMasterVolume() * Math.min(newRealVolume, 1.0f));
        }
        this.realVolume = newRealVolume;
    }

    private boolean check() {
        if (this.valid && GraviSuite.audioManager.valid()) {
            return true;
        }
        this.valid = false;
        return false;
    }

    public static int roundToNegInf(float x) {
        int ret = (int)x;
        if ((float)ret > x) {
            --ret;
        }
        return ret;
    }

    public static int roundToNegInf(double x) {
        int ret = (int)x;
        if ((double)ret > x) {
            --ret;
        }
        return ret;
    }
}

