/*
 * Decompiled with CFR 0.152.
 */
package makamys.mclib.ext.assetdirector;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import makamys.mclib.ext.assetdirector.ADConfig;
import makamys.mclib.ext.assetdirector.AssetDirectorAPI;
import makamys.mclib.ext.assetdirector.AssetFetcher;
import makamys.mclib.ext.assetdirector.mc.MCUtil;
import makamys.mclib.ext.assetdirector.mc.MultiVersionDefaultResourcePack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AssetDirector {
    static final Logger LOGGER = LogManager.getLogger((String)"AssetDirector");
    static final String NS = "AssetDirector";
    static final File AD_DIR = AssetDirector.getAssetDirectorDir();
    public static final String SOUNDS_JSON_REQUESTED = ":tmp:requested";
    static AssetDirector instance = new AssetDirector();
    private AssetFetcher fetcher = new AssetFetcher(MCUtil.getMCAssetsDir(), AD_DIR);
    private Map<String, JsonObject> soundJsons = new HashMap<String, JsonObject>();

    private void parseJson(String json, String modid) throws Exception {
        ADConfig config = (ADConfig)new Gson().fromJson(json, ADConfig.class);
        Set<Object> objectFetchQueue = new HashSet();
        HashMap<String, String> objectName = new HashMap<String, String>();
        HashSet<String> jarLoadQueue = new HashSet<String>();
        for (Map.Entry<String, ADConfig.VersionAssets> entry : config.assets.entrySet()) {
            HashSet<String> objects;
            String string = entry.getKey();
            this.fetcher.loadVersionDeps(string);
            ADConfig.VersionAssets versionAssets = entry.getValue();
            HashSet<String> hashSet = objects = versionAssets.objects != null ? versionAssets.objects : new HashSet<String>();
            if (versionAssets.soundEvents != null) {
                JsonObject soundJson = this.getOrFetchSoundJson(string);
                objects.addAll(this.getObjectsAndSetCategories(versionAssets.soundEvents, soundJson, modid));
            }
            if (versionAssets.jar) {
                jarLoadQueue.add(string);
            }
            for (String name : objects) {
                String hash = this.fetcher.getAssetHash(string, name, true);
                if (hash == null) continue;
                objectFetchQueue.add(hash);
                objectName.put(hash, name);
            }
        }
        objectFetchQueue = objectFetchQueue.stream().filter(this.fetcher::needsFetchAssetByHash).collect(Collectors.toSet());
        Set jarFetchQueue = jarLoadQueue.stream().filter(this.fetcher::needsFetchJar).collect(Collectors.toSet());
        int downloadCount = jarFetchQueue.size() + objectFetchQueue.size();
        if (downloadCount > 0) {
            LOGGER.info("Downloading resources, this may take a while...");
            MCUtil.ProgressBar downloadBar = MCUtil.ProgressBar.push("Downloading", downloadCount);
            for (String string : jarFetchQueue) {
                downloadBar.step("minecraft.jar, version " + string);
                this.fetcher.fetchJar(string);
            }
            for (String string : objectFetchQueue) {
                String name = (String)objectName.get(string);
                downloadBar.step(name.replaceFirst("minecraft/", "").replaceFirst("sounds/", ""));
                this.fetcher.fetchAssetByHash(string);
            }
            downloadBar.pop();
        }
        for (String string : jarLoadQueue) {
            this.fetcher.loadJar(string);
        }
    }

    private List<String> getObjectsAndSetCategories(Collection<ADConfig.VersionAssets.SoundEvent> soundEvents, JsonObject soundJson, String modid) {
        ArrayList<String> objects = new ArrayList<String>();
        JsonArray requested = null;
        if (!soundJson.has(SOUNDS_JSON_REQUESTED)) {
            soundJson.add(SOUNDS_JSON_REQUESTED, (JsonElement)new JsonArray());
        }
        requested = soundJson.get(SOUNDS_JSON_REQUESTED).getAsJsonArray();
        for (ADConfig.VersionAssets.SoundEvent eventObj : soundEvents) {
            String name = eventObj.name;
            String category = eventObj.category;
            JsonObject event = soundJson.getAsJsonObject(name);
            if (event == null) {
                LOGGER.warn("Mod " + modid + " requested non-existent sound event " + name);
            } else {
                for (JsonElement soundElem : event.getAsJsonArray("sounds")) {
                    String soundPath = null;
                    if (soundElem.isJsonPrimitive() && soundElem.getAsJsonPrimitive().isString()) {
                        soundPath = soundElem.getAsString();
                    } else {
                        JsonObject soundObj = soundElem.getAsJsonObject();
                        soundPath = soundObj.get("name").getAsString();
                    }
                    objects.add("minecraft/sounds/" + soundPath + ".ogg");
                }
                if (event.has("category")) {
                    String originalCategory = event.get("category").getAsString();
                    if (!originalCategory.equals(category)) {
                        LOGGER.warn("Ignoring mod " + modid + "'s category request (" + category + ") for sound event " + name + " that already has one (" + originalCategory + ").");
                    }
                } else {
                    event.addProperty("category", category);
                }
            }
            requested.add((JsonElement)new JsonPrimitive(name));
        }
        return objects;
    }

    private JsonObject getOrFetchSoundJson(String version) throws Exception {
        String assetsId = this.fetcher.versionToAssetsId(version);
        JsonObject soundJson = this.soundJsons.get(assetsId);
        if (soundJson == null) {
            if (this.fetcher.needsFetchAsset(version, "minecraft/sounds.json", true)) {
                this.fetcher.fetchAsset(version, "minecraft/sounds.json");
            }
            soundJson = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(this.fetcher.getAssetInputStream(version, "minecraft/sounds.json")), JsonObject.class);
            this.soundJsons.put(assetsId, soundJson);
        }
        return soundJson;
    }

    public JsonObject getMassagedSoundJson(String version) {
        return this.soundJsons.get(this.fetcher.versionToAssetsId(version));
    }

    public AssetFetcher getFetcher() {
        return this.fetcher;
    }

    public void preInit() {
        long t0 = System.nanoTime();
        this.fetcher.init();
        MCUtil.ProgressBar bar = MCUtil.ProgressBar.push("AssetDirector - Loading assets", AssetDirectorAPI.jsons.size());
        boolean connectionOK = true;
        for (Map.Entry<String, String> entry : AssetDirectorAPI.jsons.entrySet()) {
            String modid = entry.getKey();
            String json = entry.getValue();
            bar.step(modid);
            if (!connectionOK) continue;
            try {
                LOGGER.trace("Fetching assets of " + modid);
                this.parseJson(json, modid);
            }
            catch (Exception e) {
                LOGGER.error("Failed to fetch assets of " + modid);
                if (e instanceof UnknownHostException || e instanceof SocketTimeoutException) {
                    LOGGER.error("Aborting further asset downloads since we seem to be offline.");
                    connectionOK = false;
                }
                e.printStackTrace();
            }
        }
        bar.pop();
        MultiVersionDefaultResourcePack.inject(this);
        long t1 = System.nanoTime();
        LOGGER.debug("AssetDirector pre-init took " + (double)(t1 - t0) / 1.0E9 + "s.");
    }

    private static File getAssetDirectorDir() {
        String sharedDataDir = System.getProperty("minecraft.sharedDataDir");
        if (sharedDataDir == null) {
            sharedDataDir = System.getenv("MINECRAFT_SHARED_DATA_DIR");
        }
        if (sharedDataDir != null) {
            return new File(sharedDataDir, "asset_director");
        }
        File assetsDir = MCUtil.getMCAssetsDir();
        return !AssetDirector.isOldLauncher(assetsDir) ? new File(assetsDir, "asset_director") : new File(assetsDir, "../asset_director");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isOldLauncher(File assetsDir) {
        File launcherJson = new File(assetsDir, "../launcher_profiles.json");
        if (launcherJson.exists()) {
            try (FileReader fr = new FileReader(launcherJson);){
                JsonPrimitive name;
                JsonObject object = (JsonObject)new Gson().fromJson((Reader)fr, JsonObject.class);
                JsonObject launcherVersionObj = object.getAsJsonObject("launcherVersion");
                if (launcherVersionObj != null && (name = launcherVersionObj.getAsJsonPrimitive("name")).isString()) {
                    String launcherVersion = name.getAsString();
                    LOGGER.debug("Detected official launcher (version " + launcherVersion + "). Will use alternative directory location.");
                    boolean bl = new MCUtil.Version(launcherVersion).compareTo(new MCUtil.Version("1.6.93")) <= 0;
                    return bl;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LOGGER.debug("Couldn't read launcher_profiles.json. Assuming official launcher is not used.");
        return false;
    }
}

