/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils.helpers;

import com.google.common.collect.AbstractIterator;
import ganymedes01.etfuturum.core.utils.helpers.Vec3i;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPos
extends Vec3i {
    public static final BlockPos ORIGIN = new BlockPos(0, 0, 0);
    private static final int NUM_X_BITS = 26;
    private static final int NUM_Z_BITS = 26;
    private static final int NUM_Y_BITS = 12;
    private static final int Y_SHIFT = 26;
    private static final int X_SHIFT = 38;
    private static final long X_MASK = 0x3FFFFFFL;
    private static final long Y_MASK = 4095L;
    private static final long Z_MASK = 0x3FFFFFFL;

    public BlockPos(int x, int y, int z) {
        super(x, y, z);
    }

    public BlockPos(double x, double y, double z) {
        super(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
    }

    public BlockPos(Entity source) {
        this(source.field_70165_t, source.field_70163_u, source.field_70161_v);
    }

    public BlockPos(Vec3 source) {
        this(source.field_72450_a, source.field_72448_b, source.field_72449_c);
    }

    public BlockPos(Vec3i source) {
        this(source.getX(), source.getY(), source.getZ());
    }

    public BlockPos(ChunkCoordinates coords) {
        this(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
    }

    public BlockPos add(double x, double y, double z) {
        return new BlockPos((double)this.getX() + x, (double)this.getY() + y, (double)this.getZ() + z);
    }

    public BlockPos add(int x, int y, int z) {
        return new BlockPos(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    public BlockPos add(Vec3i vec) {
        return new BlockPos(this.getX() + vec.getX(), this.getY() + vec.getY(), this.getZ() + vec.getZ());
    }

    public BlockPos multiply(int factor) {
        return new BlockPos(this.getX() * factor, this.getY() * factor, this.getZ() * factor);
    }

    public BlockPos up() {
        return this.up(1);
    }

    public BlockPos subtract(Vec3i vec) {
        return new BlockPos(this.getX() - vec.getX(), this.getY() - vec.getY(), this.getZ() - vec.getZ());
    }

    public BlockPos up(int n) {
        return this.offset(EnumFacing.UP, n);
    }

    public BlockPos down() {
        return this.down(1);
    }

    public BlockPos down(int n) {
        return this.offset(EnumFacing.DOWN, n);
    }

    public BlockPos north() {
        return this.north(1);
    }

    public BlockPos north(int n) {
        return this.offset(EnumFacing.NORTH, n);
    }

    public BlockPos south() {
        return this.south(1);
    }

    public BlockPos south(int n) {
        return this.offset(EnumFacing.SOUTH, n);
    }

    public BlockPos west() {
        return this.west(1);
    }

    public BlockPos west(int n) {
        return this.offset(EnumFacing.WEST, n);
    }

    public BlockPos east() {
        return this.east(1);
    }

    public BlockPos east(int n) {
        return this.offset(EnumFacing.EAST, n);
    }

    public BlockPos offset(EnumFacing facing) {
        return this.offset(facing, 1);
    }

    public BlockPos offset(EnumFacing facing, int n) {
        return new BlockPos(this.getX() + facing.func_82601_c() * n, this.getY() + facing.func_96559_d() * n, this.getZ() + facing.func_82599_e() * n);
    }

    public BlockPos offset(ForgeDirection facing) {
        return this.offset(facing, 1);
    }

    public BlockPos offset(ForgeDirection facing, int n) {
        return new BlockPos(this.getX() + facing.offsetX * n, this.getY() + facing.offsetY * n, this.getZ() + facing.offsetZ * n);
    }

    public BlockPos crossProductBP(Vec3i vec) {
        return new BlockPos(this.getY() * vec.getZ() - this.getZ() * vec.getY(), this.getZ() * vec.getX() - this.getX() * vec.getZ(), this.getX() * vec.getY() - this.getY() * vec.getX());
    }

    public long toLong() {
        return ((long)this.getX() & 0x3FFFFFFL) << 38 | ((long)this.getY() & 0xFFFL) << 26 | ((long)this.getZ() & 0x3FFFFFFL) << 0;
    }

    public static BlockPos fromLong(long serialized) {
        int j = (int)(serialized << 0 >> 38);
        int k = (int)(serialized << 26 >> 52);
        int l = (int)(serialized << 38 >> 38);
        return new BlockPos(j, k, l);
    }

    @Override
    public Vec3i crossProduct(Vec3i vec) {
        return this.crossProductBP(vec);
    }

    public static AxisAlignedBB getBB(BlockPos pos1, BlockPos pos2) {
        return AxisAlignedBB.func_72330_a((double)pos1.getX(), (double)pos1.getY(), (double)pos1.getZ(), (double)pos2.getX(), (double)pos2.getY(), (double)pos2.getZ());
    }

    public static Iterable<BlockPos> iterate(BlockPos start, BlockPos end) {
        return BlockPos.iterate(Math.min(start.getX(), end.getX()), Math.min(start.getY(), end.getY()), Math.min(start.getZ(), end.getZ()), Math.max(start.getX(), end.getX()), Math.max(start.getY(), end.getY()), Math.max(start.getZ(), end.getZ()));
    }

    public static BlockPos readFromNBT(NBTTagCompound p_129240_) {
        return new BlockPos(p_129240_.func_74762_e("X"), p_129240_.func_74762_e("Y"), p_129240_.func_74762_e("Z"));
    }

    public static NBTTagCompound writeToNBT(BlockPos p_129225_) {
        NBTTagCompound compoundtag = new NBTTagCompound();
        compoundtag.func_74768_a("X", p_129225_.getX());
        compoundtag.func_74768_a("Y", p_129225_.getY());
        compoundtag.func_74768_a("Z", p_129225_.getZ());
        return compoundtag;
    }

    public TileEntity getTileEntity(World world) {
        return world.func_147438_o(this.getX(), this.getY(), this.getZ());
    }

    public Block getBlock(World world) {
        return world.func_147439_a(this.getX(), this.getY(), this.getZ());
    }

    public int getBlockMetadata(World world) {
        return world.func_72805_g(this.getX(), this.getY(), this.getZ());
    }

    public static Iterable<BlockPos> iterate(final int startX, final int startY, final int startZ, final int endX, final int endY, final int endZ) {
        return new Iterable<BlockPos>(){

            @Override
            public Iterator<BlockPos> iterator() {
                return new AbstractIterator<BlockPos>(){
                    private boolean first = true;
                    private int lastPosX;
                    private int lastPosY;
                    private int lastPosZ;

                    protected BlockPos computeNext() {
                        if (this.first) {
                            this.first = false;
                            this.lastPosX = startX;
                            this.lastPosY = startY;
                            this.lastPosZ = startZ;
                            return new BlockPos(startX, startY, startZ);
                        }
                        if (this.lastPosX == endX && this.lastPosY == endY && this.lastPosZ == endZ) {
                            return (BlockPos)this.endOfData();
                        }
                        if (this.lastPosX < endX) {
                            ++this.lastPosX;
                        } else if (this.lastPosY < endY) {
                            this.lastPosX = startX;
                            ++this.lastPosY;
                        } else if (this.lastPosZ < endZ) {
                            this.lastPosX = startX;
                            this.lastPosY = startY;
                            ++this.lastPosZ;
                        }
                        return new BlockPos(this.lastPosX, this.lastPosY, this.lastPosZ);
                    }
                };
            }
        };
    }

    public BlockPos toImmutable() {
        return this;
    }

    public Vec3 newVec3() {
        return Vec3.func_72443_a((double)this.getX(), (double)this.getY(), (double)this.getZ());
    }

    public static class MutableBlockPos
    extends BlockPos {
        protected int x;
        protected int y;
        protected int z;

        public MutableBlockPos() {
            this(0, 0, 0);
        }

        public MutableBlockPos(BlockPos pos) {
            this(pos.getX(), pos.getY(), pos.getZ());
        }

        public MutableBlockPos(int x_, int y_, int z_) {
            super(0, 0, 0);
            this.x = x_;
            this.y = y_;
            this.z = z_;
        }

        @Override
        public BlockPos add(double x, double y, double z) {
            return super.add(x, y, z).toImmutable();
        }

        @Override
        public BlockPos add(int x, int y, int z) {
            return super.add(x, y, z).toImmutable();
        }

        @Override
        public BlockPos offset(EnumFacing facing, int n) {
            return super.offset(facing, n).toImmutable();
        }

        @Override
        public BlockPos offset(EnumFacing p_190942_1_) {
            return super.offset(p_190942_1_).toImmutable();
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public int getZ() {
            return this.z;
        }

        public MutableBlockPos setPos(int xIn, int yIn, int zIn) {
            this.x = xIn;
            this.y = yIn;
            this.z = zIn;
            return this;
        }

        public MutableBlockPos setPos(Entity entityIn) {
            return this.setPos(entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v);
        }

        public MutableBlockPos setPos(double xIn, double yIn, double zIn) {
            return this.setPos(MathHelper.func_76128_c((double)xIn), MathHelper.func_76128_c((double)yIn), MathHelper.func_76128_c((double)zIn));
        }

        public MutableBlockPos setWithOffset(Vec3i p_122160_, ForgeDirection p_122161_) {
            return this.setPos(p_122160_.getX() + p_122161_.offsetX, p_122160_.getY() + p_122161_.offsetY, p_122160_.getZ() + p_122161_.offsetZ);
        }

        public MutableBlockPos setWithOffset(Vec3i p_122155_, int p_122156_, int p_122157_, int p_122158_) {
            return this.setPos(p_122155_.getX() + p_122156_, p_122155_.getY() + p_122157_, p_122155_.getZ() + p_122158_);
        }

        public MutableBlockPos setWithOffset(Vec3i p_175307_, Vec3i p_175308_) {
            return this.setPos(p_175307_.getX() + p_175308_.getX(), p_175307_.getY() + p_175308_.getY(), p_175307_.getZ() + p_175308_.getZ());
        }

        public MutableBlockPos setPos(Vec3i vec) {
            return this.setPos(vec.getX(), vec.getY(), vec.getZ());
        }

        public MutableBlockPos move(EnumFacing facing) {
            return this.move(facing, 1);
        }

        public MutableBlockPos move(EnumFacing facing, int p_189534_2_) {
            return this.setPos(this.x + facing.func_82601_c() * p_189534_2_, this.y + facing.func_96559_d() * p_189534_2_, this.z + facing.func_82599_e() * p_189534_2_);
        }

        public void setY(int yIn) {
            this.y = yIn;
        }

        @Override
        public BlockPos toImmutable() {
            return new BlockPos((Vec3i)this);
        }
    }
}

