/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class WeightedRandomList<T> {
    private final List<Entry> entries = new ArrayList<Entry>();
    private double accumulatedWeight;

    public void addEntry(T object, double weight) {
        this.accumulatedWeight += weight;
        Entry e = new Entry();
        e.object = object;
        e.accumulatedWeight = this.accumulatedWeight;
        this.entries.add(e);
    }

    public T getRandom(Random rand) {
        if (this.entries.size() == 1) {
            return this.entries.get((int)0).object;
        }
        double r = rand.nextDouble() * this.accumulatedWeight;
        for (Entry entry : this.entries) {
            if (!(entry.accumulatedWeight >= r)) continue;
            return entry.object;
        }
        return this.entries.get((int)(this.entries.size() - 1)).object;
    }

    private class Entry {
        double accumulatedWeight;
        T object;

        private Entry() {
        }
    }
}

