/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.handlers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.api.MultiBlockSoundRegistry;
import ganymedes01.etfuturum.api.mappings.MultiBlockSoundContainer;
import ganymedes01.etfuturum.blocks.BlockShulkerBox;
import ganymedes01.etfuturum.client.OpenGLHelper;
import ganymedes01.etfuturum.client.gui.GuiConfigWarning;
import ganymedes01.etfuturum.client.gui.GuiGamemodeSwitcher;
import ganymedes01.etfuturum.client.particle.CustomParticles;
import ganymedes01.etfuturum.client.renderer.entity.elytra.LayerBetterElytra;
import ganymedes01.etfuturum.client.sound.AmbienceLoop;
import ganymedes01.etfuturum.client.sound.BeeFlySound;
import ganymedes01.etfuturum.client.sound.ElytraSound;
import ganymedes01.etfuturum.client.sound.ModSounds;
import ganymedes01.etfuturum.configuration.ConfigBase;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigExperiments;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import ganymedes01.etfuturum.configuration.configs.ConfigMixins;
import ganymedes01.etfuturum.configuration.configs.ConfigSounds;
import ganymedes01.etfuturum.core.utils.Logger;
import ganymedes01.etfuturum.core.utils.RandomXoshiro256StarStar;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.elytra.IElytraPlayer;
import ganymedes01.etfuturum.entities.EntityBee;
import ganymedes01.etfuturum.entities.EntityNewBoatWithChest;
import ganymedes01.etfuturum.items.ItemHoneyBottle;
import ganymedes01.etfuturum.lib.Reference;
import ganymedes01.etfuturum.network.ChestBoatOpenInventoryMessage;
import ganymedes01.etfuturum.spectator.SpectatorMode;
import ganymedes01.etfuturum.tileentities.TileEntityShulkerBox;
import ganymedes01.etfuturum.world.nether.biome.utils.NetherBiomeManager;
import ganymedes01.etfuturum.world.nether.dimension.WorldProviderEFRNether;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockNote;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent17;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.apache.commons.lang3.tuple.MutablePair;
import org.lwjgl.input.Keyboard;

public class ClientEventHandler {
    public static final ClientEventHandler INSTANCE = new ClientEventHandler();
    private final Minecraft mc = FMLClientHandler.instance().getClient();
    private final Random rand = new RandomXoshiro256StarStar();
    private boolean showedDebugWarning;
    private int currPage;
    private static final Map<Entity, MutablePair<Float, Integer>> AMETHYST_CHIME_CACHE = new WeakHashMap<Entity, MutablePair<Float, Integer>>();
    private static final ItemStack STORAGE_STACK = new ItemStack((Item)null, 1, 0);
    private static final boolean forceHideSnapshotWarning = Boolean.parseBoolean(System.getProperty("etfuturum.hideSnapshotWarning"));
    private boolean wasShowingDebugInfo;
    private boolean wasShowingProfiler;
    private boolean eligibleForDebugInfoSwap = false;
    private final AmbienceLoop defaultNetherAmbienceLoop = new AmbienceLoop("nether_wastes", 40, 80);
    private final List<String> netherAmbienceLoopNames = ImmutableList.of((Object)"nether_wastes", (Object)"crimson_forest", (Object)"warped_forest", (Object)"soul_sand_valley", (Object)"basalt_deltas");
    private final Map<BiomeGenBase, AmbienceLoop> netherAmbienceLoops;
    private AmbienceLoop netherAmbienceLoop;
    private BiomeGenBase prevAmbientBiome;
    private BiomeGenBase currentBiome;
    PositionedSound musicOverride;
    private static final String ignore_suffix = "$etfuturum:ignore";
    private float prevYOffset;
    public static int main_menu_display_count = 0;
    private final List<ISound> soundList = Lists.newArrayList();

    private ClientEventHandler() {
        this.netherAmbienceLoops = new HashMap<BiomeGenBase, AmbienceLoop>();
        this.netherAmbienceLoops.put(NetherBiomeManager.crimsonForest, new AmbienceLoop("crimson_forest", 50, 90));
        this.netherAmbienceLoops.put(NetherBiomeManager.warpedForest, new AmbienceLoop("warped_forest", 50, 90));
        this.netherAmbienceLoops.put(NetherBiomeManager.soulSandValley, new AmbienceLoop("soul_sand_valley", 50, 90));
        this.netherAmbienceLoops.put(NetherBiomeManager.basaltDeltas, new AmbienceLoop("basalt_deltas", 50, 90));
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (ConfigFunctions.enableNewF3Behavior) {
            int key;
            if (Keyboard.getEventKey() == 61) {
                boolean pressedF3 = Keyboard.getEventKeyState();
                if (pressedF3) {
                    this.eligibleForDebugInfoSwap = true;
                }
                if (!pressedF3 && this.eligibleForDebugInfoSwap) {
                    this.mc.field_71474_y.field_74330_P = !this.mc.field_71474_y.field_74330_P;
                    this.mc.field_71474_y.field_74329_Q = GuiScreen.func_146272_n();
                }
            } else if (Keyboard.getEventKeyState() && (key = Keyboard.getEventKey()) != 42 && key != 54) {
                this.eligibleForDebugInfoSwap = false;
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        WorldClient world = FMLClientHandler.instance().getWorldClient();
        EntityClientPlayerMP player = FMLClientHandler.instance().getClientPlayerEntity();
        if (world == null || event.phase == TickEvent.Phase.START || this.mc.func_147113_T()) {
            return;
        }
        if (player.field_70173_aa == 40) {
            ChatComponentText text;
            if (!(Reference.DEV_ENVIRONMENT || ConfigExperiments.getEnabledElements().isEmpty() || this.showedDebugWarning)) {
                if (!forceHideSnapshotWarning && !Reference.TESTING) {
                    text = new ChatComponentText(I18n.func_135052_a((String)"efr.warn.experimental", (Object[])new Object[]{ConfigExperiments.buildLoadedExperimentsList(true)}));
                    player.func_146105_b((IChatComponent)text);
                    text = new ChatComponentText(I18n.func_135052_a((String)"efr.warn.experimental.bugs", (Object[])new Object[0]));
                    text.func_150256_b().func_150238_a(EnumChatFormatting.AQUA);
                    text.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Roadhog360/Et-Futurum-Requiem/issues"));
                    player.func_146105_b((IChatComponent)text);
                } else {
                    Logger.warn(I18n.func_135052_a((String)"efr.log.experimental", (Object[])new Object[]{ConfigExperiments.buildLoadedExperimentsList(false)}));
                    Logger.warn(I18n.func_135052_a((String)"efr.log.experimental.bugs", (Object[])new Object[0]));
                }
                this.showedDebugWarning = true;
            }
            if (ModItems.ELYTRA.isEnabled() && Utils.badBetterFPSAlgorithm()) {
                text = new ChatComponentText(I18n.func_135052_a((String)"efr.critical.badbetterfpsalgorithm1", (Object[])new Object[0]) + I18n.func_135052_a((String)"efr.critical.badbetterfpsalgorithm2", (Object[])new Object[0]) + I18n.func_135052_a((String)"efr.critical.badbetterfpsalgorithm3", (Object[])new Object[0]));
                player.func_146105_b((IChatComponent)text);
                text = new ChatComponentText(I18n.func_135052_a((String)"efr.elytra.flight.disabled", (Object[])new Object[0]));
                text.func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED).func_150227_a(Boolean.valueOf(true)));
                player.func_146105_b((IChatComponent)text);
            }
        }
        this.applyNextEntitySound();
        if (ConfigSounds.netherAmbience && world.field_73011_w.field_76574_g == -1 && (world.field_73011_w.getClass() == WorldProviderHell.class || world.field_73011_w.getClass() == WorldProviderEFRNether.class)) {
            Chunk chunk = world.func_72938_d(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70161_v));
            if (!chunk.field_76636_d) {
                if (this.netherAmbienceLoop != null && this.mc.func_147118_V().func_147692_c((ISound)this.netherAmbienceLoop)) {
                    this.mc.func_147118_V().func_147683_b((ISound)this.netherAmbienceLoop);
                }
                this.netherAmbienceLoop = null;
                this.currentBiome = null;
                this.prevAmbientBiome = null;
                return;
            }
            int x = MathHelper.func_76128_c((double)player.field_70165_t);
            int z = MathHelper.func_76128_c((double)player.field_70161_v);
            this.currentBiome = world.func_72807_a(x, z);
            this.handleBiomeParticles();
            if (player.field_70173_aa % 5 == 4) {
                this.handleNetherAmbienceLoop();
                this.prevAmbientBiome = this.currentBiome;
            }
        } else {
            this.netherAmbienceLoop = null;
        }
        if (ConfigFunctions.enableGamemodeSwitcher && Keyboard.isCreated() && Keyboard.isKeyDown((int)61) && Keyboard.isKeyDown((int)62) && this.mc.field_71462_r == null) {
            this.mc.func_147108_a((GuiScreen)new GuiGamemodeSwitcher());
        }
        if (ConfigFunctions.enableNewF3Behavior && this.mc.field_71474_y.field_74330_P != this.wasShowingDebugInfo && Keyboard.isKeyDown((int)61)) {
            this.mc.field_71474_y.field_74330_P = this.wasShowingDebugInfo;
            this.mc.field_71474_y.field_74329_Q = this.wasShowingProfiler;
        }
        this.wasShowingDebugInfo = this.mc.field_71474_y.field_74330_P;
        this.wasShowingProfiler = this.mc.field_71474_y.field_74329_Q;
        if (this.mc.field_71462_r == null && this.currPage > -1) {
            this.currPage = -1;
        }
    }

    private void handleBiomeParticles() {
        block16: {
            block15: {
                if (this.mc.field_71474_y.field_74362_aa != 0) break block15;
                int b0 = 16;
                for (int l = 0; l < 200; ++l) {
                    int z;
                    int y;
                    double i1 = this.mc.field_71439_g.field_70165_t + MathHelper.func_82716_a((Random)this.rand, (double)(-b0), (double)b0);
                    double j1 = this.mc.field_71439_g.field_70163_u + MathHelper.func_82716_a((Random)this.rand, (double)(-b0), (double)b0);
                    double k1 = this.mc.field_71439_g.field_70161_v + MathHelper.func_82716_a((Random)this.rand, (double)(-b0), (double)b0);
                    int x = MathHelper.func_76128_c((double)i1);
                    Block block = this.mc.field_71441_e.func_147439_a(x, y = MathHelper.func_76128_c((double)j1), z = MathHelper.func_76128_c((double)k1));
                    if (block.func_149688_o() != Material.field_151579_a || !(j1 >= 0.0) || !(j1 <= 255.0)) continue;
                    BiomeGenBase biome = this.mc.field_71441_e.func_72807_a(x, z);
                    if (biome == NetherBiomeManager.crimsonForest && this.rand.nextBoolean()) {
                        CustomParticles.spawnCrimsonSpore((World)this.mc.field_71441_e, i1, j1, k1);
                        continue;
                    }
                    if (biome == NetherBiomeManager.warpedForest && this.rand.nextFloat() <= 0.375f) {
                        CustomParticles.spawnWarpedSpore((World)this.mc.field_71441_e, i1, j1, k1);
                        continue;
                    }
                    if (biome == NetherBiomeManager.soulSandValley && this.rand.nextFloat() <= 0.005f) {
                        CustomParticles.spawnAshParticle((World)this.mc.field_71441_e, i1, j1, k1);
                        continue;
                    }
                    if (biome != NetherBiomeManager.basaltDeltas) continue;
                    CustomParticles.spawnAshParticle((World)this.mc.field_71441_e, i1, j1, k1);
                }
                break block16;
            }
            if (this.mc.field_71474_y.field_74362_aa != 1) break block16;
            int b0 = 16;
            BiomeGenBase biome = this.currentBiome;
            int density = 0;
            if (biome == NetherBiomeManager.crimsonForest) {
                density = 100;
            } else if (biome == NetherBiomeManager.warpedForest) {
                density = 75;
            } else if (biome == NetherBiomeManager.soulSandValley) {
                density = 1;
            } else if (biome == NetherBiomeManager.basaltDeltas) {
                density = 200;
            }
            for (int l = 0; l < density; ++l) {
                int z;
                int y;
                double i1 = this.mc.field_71439_g.field_70165_t + MathHelper.func_82716_a((Random)this.rand, (double)(-b0), (double)b0);
                double j1 = this.mc.field_71439_g.field_70163_u + MathHelper.func_82716_a((Random)this.rand, (double)(-b0), (double)b0);
                double k1 = this.mc.field_71439_g.field_70161_v + MathHelper.func_82716_a((Random)this.rand, (double)(-b0), (double)b0);
                int x = MathHelper.func_76128_c((double)i1);
                Block block = this.mc.field_71441_e.func_147439_a(x, y = MathHelper.func_76128_c((double)j1), z = MathHelper.func_76128_c((double)k1));
                if (block.func_149688_o() != Material.field_151579_a || !(j1 >= 0.0) || !(j1 <= 255.0)) continue;
                if (biome == NetherBiomeManager.crimsonForest) {
                    CustomParticles.spawnCrimsonSpore((World)this.mc.field_71441_e, i1, j1, k1);
                    continue;
                }
                if (biome == NetherBiomeManager.warpedForest) {
                    CustomParticles.spawnWarpedSpore((World)this.mc.field_71441_e, i1, j1, k1);
                    continue;
                }
                if (biome == NetherBiomeManager.basaltDeltas) {
                    CustomParticles.spawnAshParticle((World)this.mc.field_71441_e, i1, j1, k1);
                    continue;
                }
                if (biome != NetherBiomeManager.soulSandValley) continue;
                CustomParticles.spawnAshParticle((World)this.mc.field_71441_e, i1, j1, k1);
            }
        }
    }

    private void handleNetherAmbienceLoop() {
        if (this.netherAmbienceLoop == null || !this.mc.func_147118_V().func_147692_c((ISound)this.netherAmbienceLoop)) {
            if (this.netherAmbienceLoop != null) {
                this.mc.func_147118_V().func_147683_b((ISound)this.netherAmbienceLoop);
            }
            this.netherAmbienceLoop = this.netherAmbienceLoops.getOrDefault(this.currentBiome, this.defaultNetherAmbienceLoop).createNew();
            this.netherAmbienceLoop.skipFadeIn();
            this.mc.func_147118_V().func_147682_a((ISound)this.netherAmbienceLoop);
            return;
        }
        if (this.prevAmbientBiome != this.currentBiome) {
            this.netherAmbienceLoop.fadeOut();
            this.netherAmbienceLoop = this.netherAmbienceLoops.getOrDefault(this.currentBiome, this.defaultNetherAmbienceLoop).createNew();
            this.mc.func_147118_V().func_147682_a((ISound)this.netherAmbienceLoop);
        }
    }

    private String getAmbienceMood() {
        if (this.netherAmbienceLoop == null || !this.netherAmbienceLoop.hasCaveSoundOverride()) {
            return null;
        }
        if (this.netherAmbienceLoopNames.contains(this.netherAmbienceLoop.getName())) {
            return "minecraft_1.21:ambient." + this.netherAmbienceLoop.getName() + ".mood";
        }
        return null;
    }

    private String getAmbientMusicOverride() {
        if (this.netherAmbienceLoop == null || !this.netherAmbienceLoop.hasMusicOverride()) {
            return null;
        }
        if (this.netherAmbienceLoopNames.contains(this.netherAmbienceLoop.getName())) {
            return "minecraft_1.21:music.nether." + this.netherAmbienceLoop.getName();
        }
        return null;
    }

    @SubscribeEvent
    public void toolTipEvent(ItemTooltipEvent event) {
        if (ConfigFunctions.enableExtraF3HTooltips && event.showAdvancedItemTooltips) {
            event.toolTip.add("\u00a78" + Item.field_150901_e.func_148750_c((Object)event.itemStack.func_77973_b()));
            if (event.itemStack.field_77990_d != null && !event.itemStack.field_77990_d.func_82582_d()) {
                event.toolTip.add("\u00a78NBT: " + event.itemStack.field_77990_d.func_150296_c().size() + " Tag(s)");
            }
        }
    }

    @SubscribeEvent
    public void renderPlayerEventPre(RenderPlayerEvent.Pre event) {
        if (ConfigFunctions.enableTransparentAmour) {
            OpenGLHelper.enableBlend();
            OpenGLHelper.blendFunc(770, 771);
        }
    }

    @SubscribeEvent
    public void renderPlayerSetArmour(RenderPlayerEvent.SetArmorModel event) {
        if (event.entityPlayer instanceof IElytraPlayer) {
            LayerBetterElytra.doRenderLayer(event.entityLiving, event.entityPlayer.field_70754_ba, event.entityPlayer.field_70721_aZ, Minecraft.func_71410_x().field_71428_T.field_74281_c, event.entityPlayer.func_70654_ax(), 0.0625f);
        }
        if (SpectatorMode.isSpectator(event.entityPlayer)) {
            event.result = 0;
        } else if (ConfigFunctions.enableTransparentAmour) {
            OpenGLHelper.enableBlend();
            OpenGLHelper.blendFunc(770, 771);
        }
    }

    @SubscribeEvent
    public void renderPlayerEventPost(RenderPlayerEvent.Post event) {
        if (ConfigFunctions.enableTransparentAmour) {
            OpenGLHelper.disableBlend();
        }
    }

    @SubscribeEvent
    public void onPlaySoundEvent(PlaySoundEvent17 event) {
        if (event.sound != null && event.name != null && FMLClientHandler.instance().getWorldClient() != null) {
            Object blockName;
            String s;
            WorldClient world = FMLClientHandler.instance().getWorldClient();
            float soundX = event.sound.func_147649_g();
            float soundY = event.sound.func_147654_h();
            float soundZ = event.sound.func_147651_i();
            int x = MathHelper.func_76141_d((float)soundX);
            int y = MathHelper.func_76141_d((float)soundY);
            int z = MathHelper.func_76141_d((float)soundZ);
            Block block = world.func_147439_a(x, y, z);
            boolean hitSound = block.field_149762_H.func_150498_e().endsWith(event.name);
            boolean breakSound = block.field_149762_H.func_150495_a().endsWith(event.name);
            boolean placeSound = block.field_149762_H.func_150496_b().endsWith(event.name);
            if (MultiBlockSoundRegistry.multiBlockSounds.containsKey(block) && (hitSound || breakSound || placeSound)) {
                MultiBlockSoundContainer obj = MultiBlockSoundRegistry.multiBlockSounds.get(block);
                MultiBlockSoundRegistry.BlockSoundType type = hitSound ? MultiBlockSoundRegistry.BlockSoundType.HIT : (placeSound ? MultiBlockSoundRegistry.BlockSoundType.PLACE : MultiBlockSoundRegistry.BlockSoundType.BREAK);
                String newSoundString = obj.getSound((World)world, x, y, z, event.name, type);
                float volume = obj.getVolume((World)world, x, y, z, event.sound.func_147653_e(), type);
                float pitch = obj.getPitch((World)world, x, y, z, event.sound.func_147655_f(), type);
                if (newSoundString != null || volume != -1.0f || pitch != -1.0f) {
                    if (newSoundString == null) {
                        newSoundString = event.name;
                    }
                    if (volume == -1.0f) {
                        volume = event.sound.func_147653_e();
                    }
                    if (pitch == -1.0f) {
                        pitch = event.sound.func_147655_f();
                    }
                    event.result = new PositionedSoundRecord(new ResourceLocation(newSoundString), volume, pitch, soundX, soundY, soundZ);
                    return;
                }
            }
            if (ConfigSounds.doorOpenClose && event.name.contains("random.door")) {
                event.result = new PositionedSoundRecord(new ResourceLocation(this.getReplacementDoorSound(block, event.name)), event.sound.func_147653_e(), event.sound.func_147655_f(), (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
                return;
            }
            if (ConfigSounds.chestOpenClose && event.name.contains("random.chest")) {
                s = event.name;
                String blockID = Block.field_149771_c.func_148750_c((Object)block).split(":")[1].toLowerCase();
                if (blockID.contains("chest") && (event.name.contains("open") || event.name.contains("close"))) {
                    if (blockID.contains("ender") && block.func_149688_o().equals(Material.field_151576_e)) {
                        s = "minecraft_1.21:block.ender_chest." + (event.name.contains("close") ? "close" : "open");
                    } else if (block.func_149688_o().equals(Material.field_151575_d) && event.name.contains("close")) {
                        s = "minecraft_1.21:block.chest.close";
                    }
                }
                if (!s.equals(event.name)) {
                    event.result = new PositionedSoundRecord(new ResourceLocation(s), event.sound.func_147653_e(), event.sound.func_147655_f(), (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
                    return;
                }
            }
            if (ConfigSounds.pressurePlateButton) {
                if (block instanceof BlockButton && event.name.equals("random.click")) {
                    s = null;
                    if (block.field_149762_H == Block.field_149766_f) {
                        s = "minecraft_1.21:block.wooden_button.click";
                    } else if (block.field_149762_H == ModSounds.soundNetherWood) {
                        s = "minecraft_1.21:block.nether_wood_button.click";
                    } else if (block.field_149762_H == ModSounds.soundCherryWood) {
                        s = "minecraft_1.21:block.cherry_wood_button.click";
                    } else if (block.field_149762_H == ModSounds.soundBambooWood) {
                        s = "minecraft_1.21:block.bamboo_wood_button.click";
                    }
                    if (s != null) {
                        event.result = new PositionedSoundRecord(new ResourceLocation(s + "_" + (event.sound.func_147655_f() > 0.5f ? "on" : "off")), 1.0f, 1.0f, soundX, soundY, soundZ);
                    }
                    return;
                }
                if (block instanceof BlockBasePressurePlate && event.name.equals("random.click")) {
                    s = null;
                    if (block.field_149762_H == Block.field_149777_j) {
                        s = "minecraft_1.21:block.metal_pressure_plate.click";
                    } else if (block.field_149762_H == Block.field_149766_f) {
                        s = "minecraft_1.21:block.wooden_pressure_plate.click";
                    } else if (block.field_149762_H == ModSounds.soundNetherWood) {
                        s = "minecraft_1.21:block.nether_wood_pressure_plate.click";
                    } else if (block.field_149762_H == ModSounds.soundCherryWood) {
                        s = "minecraft_1.21:block.cherry_wood_pressure_plate.click";
                    } else if (block.field_149762_H == ModSounds.soundBambooWood) {
                        s = "minecraft_1.21:block.bamboo_wood_pressure_plate.click";
                    }
                    if (s != null) {
                        event.result = new PositionedSoundRecord(new ResourceLocation(s + "_" + (event.sound.func_147655_f() > 0.5f ? "on" : "off")), 1.0f, 1.0f, soundX, soundY, soundZ);
                    }
                    return;
                }
            }
            if (ConfigSounds.noteBlockNotes && world.func_147439_a(MathHelper.func_76141_d((float)soundX), MathHelper.func_76141_d((float)soundY), MathHelper.func_76141_d((float)soundZ)) instanceof BlockNote && (event.name.equals("note.harp") || event.name.equals("note.snare") || event.name.equals("note.hat") || event.name.equals("note.bd"))) {
                String instrumentToPlay = event.name;
                blockName = "";
                Block blockBeneath = world.func_147439_a(MathHelper.func_76141_d((float)soundX), MathHelper.func_76141_d((float)soundY) - 1, MathHelper.func_76141_d((float)soundZ));
                Item item = Item.func_150898_a((Block)blockBeneath);
                if (item != null && item.func_77614_k()) {
                    try {
                        STORAGE_STACK.func_150996_a(item);
                        STORAGE_STACK.func_77964_b(world.func_72805_g(MathHelper.func_76141_d((float)soundX), MathHelper.func_76141_d((float)soundY), MathHelper.func_76141_d((float)soundZ)));
                        blockName = item.func_77667_c(STORAGE_STACK).toLowerCase();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (((String)blockName).equals("")) {
                    blockName = blockBeneath.func_149739_a().toLowerCase();
                }
                if (blockBeneath == Blocks.field_150425_aM) {
                    instrumentToPlay = "minecraft_1.21:block.note_block.cow_bell";
                } else if (((String)blockName).contains("hay")) {
                    instrumentToPlay = "minecraft_1.21:block.note_block.banjo";
                } else if (EtFuturum.hasDictTag(blockBeneath, "blockGold")) {
                    instrumentToPlay = "minecraft_1.21:block.note_block.bell";
                } else if (EtFuturum.hasDictTag(blockBeneath, "blockEmerald")) {
                    instrumentToPlay = "minecraft_1.21:block.note_block.bit";
                } else if (((String)blockName).contains("packed") && ((String)blockName).contains("ice")) {
                    instrumentToPlay = "minecraft_1.21:block.note_block.chime";
                } else if (((String)blockName).contains("pumpkin")) {
                    instrumentToPlay = "minecraft_1.21:block.note_block.didgeridoo";
                } else if (blockBeneath.func_149688_o() == Material.field_151571_B) {
                    instrumentToPlay = "minecraft_1.21:block.note_block.flute";
                } else if (EtFuturum.hasDictTag(blockBeneath, "blockIron")) {
                    instrumentToPlay = "minecraft_1.21:block.note_block.iron_xylophone";
                } else if (blockBeneath.func_149688_o() == Material.field_151580_n) {
                    instrumentToPlay = "minecraft_1.21:block.note_block.guitar";
                } else if (((String)blockName).contains("bone") || ((String)blockName).contains("ivory")) {
                    instrumentToPlay = "minecraft_1.21:block.note_block.xylophone";
                }
                if (event.name.equals(instrumentToPlay)) {
                    return;
                }
                event.result = new PositionedSoundRecord(new ResourceLocation(instrumentToPlay), instrumentToPlay.equals("minecraft_1.21:block.note_block.iron_xylophone") ? 1.0f : event.sound.func_147653_e(), event.sound.func_147655_f(), soundX, soundY, soundZ);
                return;
            }
            blockName = this.mc.field_71462_r;
            if (blockName instanceof GuiScreenBook) {
                GuiScreenBook gui = (GuiScreenBook)blockName;
                if (event.name.equals("gui.button.press") && gui.field_146484_x != this.currPage) {
                    this.currPage = gui.field_146484_x;
                    EntityClientPlayerMP player = this.mc.field_71439_g;
                    player.func_85030_a("minecraft_1.21:item.book.page_turn", 1.0f, 1.0f);
                    event.result = null;
                    return;
                }
            }
            if (ConfigSounds.rainSounds && event.name.equals("ambient.weather.rain")) {
                event.result = new PositionedSoundRecord(new ResourceLocation("minecraft_1.21:weather.rain" + (event.sound.func_147655_f() < 1.0f ? ".above" : "")), event.sound.func_147653_e(), event.sound.func_147655_f(), (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
            }
            if (event.name.startsWith("music.game")) {
                if (this.musicOverride == null || !this.mc.func_147118_V().func_147692_c((ISound)this.musicOverride)) {
                    String music = this.getAmbientMusicOverride();
                    if (music != null) {
                        this.musicOverride = PositionedSoundRecord.func_147673_a((ResourceLocation)new ResourceLocation(music));
                        event.result = this.musicOverride;
                    }
                } else {
                    event.result = null;
                }
            }
            if (event.name.equals("ambient.cave.cave") && this.getAmbienceMood() != null) {
                event.result = new PositionedSoundRecord(new ResourceLocation(this.getAmbienceMood()), event.sound.func_147653_e(), event.sound.func_147655_f(), (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
            }
        }
    }

    private String getReplacementDoorSound(Block block, String string) {
        String closeOrOpen;
        Random random = new Random();
        String string2 = closeOrOpen = random.nextBoolean() ? "open" : "close";
        if (block instanceof BlockDoor) {
            if (block.func_149688_o() == Material.field_151575_d) {
                if (block.field_149762_H == ModSounds.soundNetherWood) {
                    return "minecraft_1.21:block.nether_wood_door." + closeOrOpen;
                }
                if (block.field_149762_H == ModSounds.soundCherryWood) {
                    return "minecraft_1.21:block.cherry_wood_door." + closeOrOpen;
                }
                if (block.field_149762_H == ModSounds.soundBambooWood) {
                    return "minecraft_1.21:block.bamboo_wood_door." + closeOrOpen;
                }
                return "minecraft_1.21:block.wooden_door." + closeOrOpen;
            }
            if (block.func_149688_o() == Material.field_151573_f) {
                if (block.field_149762_H == ModSounds.soundCopper) {
                    return "minecraft_1.21:block.copper_door." + closeOrOpen;
                }
                return "minecraft_1.21:block.iron_door." + closeOrOpen;
            }
        }
        if (block instanceof BlockTrapDoor) {
            if (block.func_149688_o() == Material.field_151575_d) {
                if (block.field_149762_H == ModSounds.soundNetherWood) {
                    return "minecraft_1.21:block.nether_wood_trapdoor." + closeOrOpen;
                }
                if (block.field_149762_H == ModSounds.soundCherryWood) {
                    return "minecraft_1.21:block.cherry_wood_trapdoor." + closeOrOpen;
                }
                if (block.field_149762_H == ModSounds.soundBambooWood) {
                    return "minecraft_1.21:block.bamboo_wood_trapdoor." + closeOrOpen;
                }
                return "minecraft_1.21:block.wooden_trapdoor." + closeOrOpen;
            }
            if (block.func_149688_o() == Material.field_151573_f) {
                if (block.field_149762_H == ModSounds.soundCopper) {
                    return "minecraft_1.21:block.copper_trapdoor." + closeOrOpen;
                }
                return "minecraft_1.21:block.iron_trapdoor." + closeOrOpen;
            }
        }
        if (block instanceof BlockFenceGate && block.func_149688_o() == Material.field_151575_d) {
            if (block.field_149762_H == ModSounds.soundNetherWood) {
                return "minecraft_1.21:block.nether_wood_fence_gate." + closeOrOpen;
            }
            if (block.field_149762_H == ModSounds.soundCherryWood) {
                return "minecraft_1.21:block.cherry_wood_fence_gate." + closeOrOpen;
            }
            if (block.field_149762_H == ModSounds.soundBambooWood) {
                return "minecraft_1.21:block.bamboo_wood_fence_gate." + closeOrOpen;
            }
            return "minecraft_1.21:block.fence_gate." + closeOrOpen;
        }
        return string;
    }

    @SubscribeEvent
    public void onPlaySoundAtEntityEvent(PlaySoundAtEntityEvent event) {
        if (event.name == null) {
            return;
        }
        if (event.name.endsWith(ignore_suffix)) {
            event.name = event.name.replace(ignore_suffix, "");
            return;
        }
        Entity entity = event.entity;
        if (!entity.field_70170_p.field_72995_K) {
            if (ConfigSounds.horseEatCowMilk && entity instanceof EntityHorse && event.name.equals("eating")) {
                event.name = "minecraft_1.21:entity.horse.eat";
            }
            return;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (event.name.equals("random.drink") && player.func_71039_bw() && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemHoneyBottle) {
                entity.func_85030_a("minecraft_1.21:item.honey_bottle.drink$etfuturum:ignore", 1.0f, 1.0f);
                event.setCanceled(true);
                return;
            }
        }
        if (ConfigSounds.heavyWaterSplashing && event.name.equals("game.player.swim.splash")) {
            float doWaterSplashEffect_f1 = MathHelper.func_76133_a((double)(entity.field_70159_w * entity.field_70159_w * (double)0.2f + entity.field_70181_x * entity.field_70181_x + entity.field_70179_y * entity.field_70179_y * (double)0.2f)) * (entity.field_70153_n == null ? 0.2f : 0.9f);
            if (doWaterSplashEffect_f1 > 1.0f) {
                doWaterSplashEffect_f1 = 1.0f;
            }
            if ((double)doWaterSplashEffect_f1 >= 0.25) {
                event.name = "minecraft_1.21:entity.player.splash.high_speed";
                return;
            }
        }
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)(entity.field_70163_u - (double)0.2f - (double)entity.field_70129_M));
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        WorldClient world = FMLClientHandler.instance().getWorldClient();
        Block block = world.func_147439_a(x, y, z);
        if (MultiBlockSoundRegistry.multiBlockSounds.containsKey(block) && block.field_149762_H.func_150498_e().equals(event.name)) {
            MultiBlockSoundContainer obj = MultiBlockSoundRegistry.multiBlockSounds.get(block);
            String newSoundString = obj.getSound((World)world, x, y, z, event.name, MultiBlockSoundRegistry.BlockSoundType.WALK);
            float volume = obj.getVolume((World)world, x, y, z, event.volume, MultiBlockSoundRegistry.BlockSoundType.WALK);
            float pitch = obj.getPitch((World)world, x, y, z, event.volume, MultiBlockSoundRegistry.BlockSoundType.WALK);
            if (newSoundString != null || volume != -1.0f || pitch != -1.0f) {
                if (newSoundString == null) {
                    newSoundString = event.name;
                }
                if (volume == -1.0f) {
                    volume = event.volume;
                }
                if (pitch == -1.0f) {
                    pitch = event.pitch;
                }
                entity.func_85030_a(newSoundString + ignore_suffix, volume, pitch);
                event.setCanceled(true);
            }
        } else if (ConfigSounds.newBlockSounds && ModSounds.soundAmethystBlock.func_150498_e().equals(event.name)) {
            MutablePair pair = AMETHYST_CHIME_CACHE.get(entity);
            if (pair == null) {
                pair = new MutablePair((Object)Float.valueOf(0.0f), (Object)0);
            }
            float field_26997 = ((Float)pair.getLeft()).floatValue();
            int lastChimeAge = (Integer)pair.getRight();
            if (entity.field_70173_aa >= lastChimeAge + 20) {
                field_26997 = (float)((double)field_26997 * Math.pow(0.997f, entity.field_70173_aa - lastChimeAge));
                field_26997 = Math.min(1.0f, field_26997 + 0.07f);
                float f = 0.5f + field_26997 * entity.field_70170_p.field_73012_v.nextFloat() * 1.2f;
                float g = 0.1f + field_26997 * 1.2f;
                entity.func_85030_a("minecraft_1.21:block.amethyst_block.chime", g, f);
                lastChimeAge = entity.field_70173_aa;
                pair.setLeft((Object)Float.valueOf(field_26997));
                pair.setRight((Object)lastChimeAge);
                AMETHYST_CHIME_CACHE.put(entity, (MutablePair<Float, Integer>)pair);
            }
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (!ConfigMixins.enableElytra) {
            return;
        }
        EntityClientPlayerMP player = this.mc.field_71439_g;
        if (!(player instanceof IElytraPlayer)) {
            return;
        }
        if (((IElytraPlayer)player).etfu$isElytraFlying()) {
            if (event.phase == TickEvent.Phase.START) {
                this.prevYOffset = player.field_70129_M;
                if (this.mc.field_71474_y.field_74320_O == 0) {
                    player.field_70129_M = 3.02f;
                }
            } else {
                player.field_70129_M = this.prevYOffset;
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        TileEntityShulkerBox TE;
        int z;
        int y;
        int x;
        IElytraPlayer e;
        EntityLivingBase entity = event.entityLiving;
        World world = entity.field_70170_p;
        if (ConfigMixins.enableElytra && entity instanceof EntityPlayerSP && (e = (IElytraPlayer)entity).etfu$isElytraFlying() && !e.etfu$lastElytraFlying()) {
            this.mc.func_147118_V().func_147682_a((ISound)new ElytraSound((EntityPlayerSP)entity));
        }
        if (entity.field_70122_E && (entity.field_70159_w != 0.0 || entity.field_70179_y != 0.0) && entity.field_70170_p.func_147439_a(x = MathHelper.func_76128_c((double)entity.field_70165_t), y = MathHelper.func_76128_c((double)(entity.field_70163_u - (double)0.2f - (double)entity.field_70129_M)), z = MathHelper.func_76128_c((double)entity.field_70161_v)) instanceof BlockShulkerBox && (TE = (TileEntityShulkerBox)entity.field_70170_p.func_147438_o(x, y, z)) != null && world.field_72995_K && entity.func_70051_ag() && !entity.func_70090_H()) {
            EntityDiggingFX dig = new EntityDiggingFX(world, entity.field_70165_t + ((double)entity.field_70170_p.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, entity.field_70121_D.field_72338_b + 0.1, entity.field_70161_v + ((double)entity.field_70170_p.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0, TE.func_145838_q(), 0);
            dig.func_110125_a(((BlockShulkerBox)TE.func_145838_q()).colorIcons[TE.color]);
            this.mc.field_71452_i.func_78873_a((EntityFX)dig.func_70596_a(x, y, z));
        }
    }

    @SubscribeEvent
    public void openMainMenu(GuiOpenEvent event) {
        if (event.gui instanceof GuiMainMenu) {
            this.showedDebugWarning = false;
            if (Reference.launchConfigWarning && main_menu_display_count++ < 20) {
                Reference.launchConfigWarning = false;
                Configuration oldConfig = new Configuration(new File(Launch.minecraftHome, ConfigBase.configDir + "etfuturum.cfg"));
                oldConfig.setCategoryComment("warned", "This is added if we've warned you this file exists.\nUsed by versions that split the config into different files, rendering this file unused.\nThis was done because the current file was becoming difficult to navigate.");
                if (!oldConfig.getBoolean("configWarningShown", "warned", false, "")) {
                    event.gui = new GuiConfigWarning(event.gui, oldConfig);
                }
                oldConfig.getCategory((String)"warned").get((String)"configWarningShown").comment = "";
                oldConfig.save();
            }
        } else if (ConfigBlocksItems.enableNewBoats && event.gui instanceof GuiInventory && this.mc.field_71439_g.field_70154_o instanceof EntityNewBoatWithChest) {
            event.setCanceled(true);
            EtFuturum.networkWrapper.sendToServer((IMessage)new ChestBoatOpenInventoryMessage());
        }
    }

    private void applyNextEntitySound() {
        if (!this.soundList.isEmpty()) {
            this.mc.func_147118_V().func_147682_a(this.soundList.remove(0));
        }
    }

    @SubscribeEvent
    public void spawnEvent(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityBee) {
            this.soundList.add((ISound)new BeeFlySound((EntityBee)event.entity));
        }
    }
}

