/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.compat.cthandlers;

import ganymedes01.etfuturum.api.EnchantingFuelRegistry;
import ganymedes01.etfuturum.compat.CompatCraftTweaker;
import ganymedes01.etfuturum.core.utils.ItemStackSet;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.mc1710.item.MCItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.etfuturum.enchantingFuel")
public class CTEnchantingFuels {
    @ZenMethod
    public static void remove(IIngredient fuel) {
        Object internal = CompatCraftTweaker.getInternal(fuel);
        if (internal instanceof String && EnchantingFuelRegistry.isFuel((String)internal) || internal instanceof ItemStack && EnchantingFuelRegistry.isFuel((ItemStack)internal)) {
            ItemStackSet toRemove = new ItemStackSet();
            for (ItemStack stack : EnchantingFuelRegistry.getFuels().keySet()) {
                if (!fuel.matches((IItemStack)new MCItemStack(stack))) continue;
                toRemove.add(stack);
            }
            MineTweakerAPI.apply((IUndoableAction)new RemoveAction(toRemove));
        } else {
            MineTweakerAPI.logWarning((String)("No enchanting fuels for " + fuel));
        }
    }

    @ZenMethod
    public static void addFuel(IIngredient fuel) {
        List items = fuel.getItems();
        if (items == null) {
            MineTweakerAPI.logError((String)("Cannot turn " + fuel + " into a enchanting fuel"));
            return;
        }
        ItemStack[] toAdd = CompatCraftTweaker.getItemStacks(items);
        MineTweakerAPI.apply((IUndoableAction)new AddAction(fuel, toAdd));
    }

    private static class RemoveAction
    implements IUndoableAction {
        private final ItemStackSet items;

        public RemoveAction(ItemStackSet items) {
            this.items = items;
        }

        public void apply() {
            for (ItemStack item : this.items.keySet()) {
                EnchantingFuelRegistry.remove(item);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (ItemStack stack : this.items.keySet()) {
                EnchantingFuelRegistry.registerFuel(stack);
            }
        }

        public String describe() {
            return "Removing " + this.items.size() + " enchanting fuels";
        }

        public String describeUndo() {
            return "Restoring " + this.items.size() + " enchanting fuels";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddAction
    implements IUndoableAction {
        private final IIngredient ingredient;
        private final ItemStack[] fuels;

        public AddAction(IIngredient ingredient, ItemStack[] fuels) {
            this.ingredient = ingredient;
            this.fuels = fuels;
        }

        public void apply() {
            for (ItemStack inputStack : this.fuels) {
                EnchantingFuelRegistry.registerFuel(inputStack);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (ItemStack inputStack : this.fuels) {
                EnchantingFuelRegistry.remove(inputStack);
            }
        }

        public String describe() {
            return "Adding enchanting fuel for " + this.ingredient;
        }

        public String describeUndo() {
            return "Removing enchanting fuel for " + this.ingredient;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

