/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.blocks.IBlockObserver;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.ducks.IObserverWorldExtension;
import ganymedes01.etfuturum.lib.RenderIDs;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableInt;

public class BlockObserver
extends Block
implements IBlockObserver {
    private IIcon observerFront;
    private IIcon observerBack;
    private IIcon observerTop;
    private IIcon observerBackLit;
    private static final ThreadLocal<MutableInt> timesDisabled = ThreadLocal.withInitial(MutableInt::new);

    public BlockObserver() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149752_b(3.0f);
        this.func_149663_c(Utils.getUnlocalisedName("observer"));
        this.func_149658_d("observer");
        this.func_149647_a(EtFuturum.creativeTabBlocks);
    }

    public IIcon func_149691_a(int side, int meta) {
        int topSide;
        boolean powered;
        int k = BlockPistonBase.func_150076_b((int)meta);
        boolean bl = powered = (meta & 8) != 0;
        if (side == k) {
            return this.observerFront;
        }
        if (side == Facing.field_71588_a[k]) {
            return powered ? this.observerBackLit : this.observerBack;
        }
        switch (k) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                topSide = 1;
                break;
            }
            default: {
                topSide = 2;
            }
        }
        return side == topSide || side == Facing.field_71588_a[topSide] ? this.observerTop : this.field_149761_L;
    }

    public void func_149689_a(World worldIn, int x, int y, int z, EntityLivingBase placer, ItemStack itemIn) {
        int l = BlockPistonBase.func_150071_a((World)worldIn, (int)x, (int)y, (int)z, (EntityLivingBase)placer);
        worldIn.func_72921_c(x, y, z, Facing.field_71588_a[l], 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a("observer_side");
        this.observerFront = reg.func_94245_a("observer_front");
        this.observerTop = reg.func_94245_a("observer_top");
        this.observerBack = reg.func_94245_a("observer_back");
        this.observerBackLit = reg.func_94245_a("observer_back_lit");
    }

    public int func_149645_b() {
        return RenderIDs.OBSERVER;
    }

    @Override
    public void observedNeighborChange(World world, int observerX, int observerY, int observerZ, Block changedBlock, int changedX, int changedY, int changedZ) {
        if (world.field_72995_K) {
            return;
        }
        int myMeta = world.func_72805_g(observerX, observerY, observerZ);
        int facing = BlockPistonBase.func_150076_b((int)myMeta);
        int observedX = observerX + Facing.field_71586_b[facing];
        int observedY = observerY + Facing.field_71587_c[facing];
        int observedZ = observerZ + Facing.field_71585_d[facing];
        if (observedX == changedX && observedY == changedY && observedZ == changedZ && (myMeta & 8) == 0 && !((IObserverWorldExtension)world).etfu$hasScheduledUpdate(observerX, observerY, observerZ, this)) {
            world.func_147464_a(observerX, observerY, observerZ, (Block)this, 2);
        }
    }

    protected void updateNeighborsInFront(World worldIn, int x, int y, int z) {
        int facing = BlockPistonBase.func_150076_b((int)worldIn.func_72805_g(x, y, z));
        int opposite = Facing.field_71588_a[facing];
        int newX = x + Facing.field_71586_b[opposite];
        int newY = y + Facing.field_71587_c[opposite];
        int newZ = z + Facing.field_71585_d[opposite];
        worldIn.func_147460_e(newX, newY, newZ, (Block)this);
        worldIn.func_147441_b(newX, newY, newZ, (Block)this, facing);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int meta = world.func_72805_g(x, y, z);
        if ((meta & 8) != 0) {
            world.func_72921_c(x, y, z, meta & 7, 2);
        } else {
            world.func_72921_c(x, y, z, meta | 8, 2);
            world.func_147464_a(x, y, z, (Block)this, 2);
        }
        this.updateNeighborsInFront(world, x, y, z);
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149748_c(IBlockAccess worldIn, int x, int y, int z, int side) {
        return this.func_149709_b(worldIn, x, y, z, side);
    }

    public int func_149709_b(IBlockAccess worldIn, int x, int y, int z, int side) {
        int metadata = worldIn.func_72805_g(x, y, z);
        if ((metadata & 8) == 0) {
            return 0;
        }
        return BlockPistonBase.func_150076_b((int)metadata) == side ? 15 : 0;
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public static void disableNotifications() {
        timesDisabled.get().increment();
    }

    public static void enableNotifications() {
        MutableInt timesDisabledMut = timesDisabled.get();
        int timesDisabledInt = timesDisabledMut.intValue();
        timesDisabledInt = Math.max(0, timesDisabledInt - 1);
        timesDisabledMut.setValue(timesDisabledInt);
    }

    public static boolean areNotificationsEnabled() {
        return timesDisabled.get().intValue() == 0;
    }
}

