/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.api;

import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.api.mappings.RawOreDropMapping;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.items.rawore.modded.ItemGeneralModdedRawOre;
import ganymedes01.etfuturum.recipes.ModRecipes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class RawOreRegistry {
    public static final Map<String, RawOreDropMapping> rawOreRegistry = new HashMap<String, RawOreDropMapping>();

    public static void addOre(String oreDict, Item ore) {
        RawOreRegistry.addOre(oreDict, ore, 0);
    }

    public static void addOre(String oreDict, Item ore, int meta) {
        if (ModRecipes.validateItems(ore)) {
            RawOreDropMapping mapping = new RawOreDropMapping(ore, meta);
            if (ArrayUtils.contains((Object[])ConfigFunctions.extraDropRawOres, (Object)oreDict)) {
                mapping.setDropsExtra(true);
            }
            RawOreRegistry.addOre(oreDict, mapping);
        }
    }

    private static void addOre(String oreDict, RawOreDropMapping map) {
        rawOreRegistry.put(oreDict, map);
    }

    public static boolean hasOre(String oreDict) {
        return rawOreRegistry.containsKey(oreDict);
    }

    public static RawOreDropMapping getOre(String oreDict) {
        return rawOreRegistry.get(oreDict);
    }

    public static Map<String, RawOreDropMapping> getOreMap() {
        return rawOreRegistry;
    }

    public static void init() {
        if (ModItems.RAW_ORE.isEnabled()) {
            if (ConfigBlocksItems.enableCopper || OreDictionary.doesOreNameExist((String)"ingotCopper")) {
                RawOreRegistry.addOre("oreCopper", ModItems.RAW_ORE.get());
            }
            RawOreRegistry.addOre("oreIron", ModItems.RAW_ORE.get(), 1);
            RawOreRegistry.addOre("oreGold", ModItems.RAW_ORE.get(), 2);
        }
        if (Utils.enableModdedRawOres()) {
            for (ItemGeneralModdedRawOre oreItem : ItemGeneralModdedRawOre.loaded) {
                for (int i = 0; i < oreItem.ores.length; ++i) {
                    String type = oreItem.ores[i];
                    for (int j = 0; j < 1; ++j) {
                        if (Utils.listGeneralModdedRawOre(type.replace("ingot", "ore"))) {
                            RawOreRegistry.addOre(type.replace("ingot", "ore"), ModItems.MODDED_RAW_ORE.get(), i);
                        }
                        if (!type.endsWith("Mythril")) continue;
                        type = type.replace("Mythril", "Mithril");
                        j = -1;
                    }
                }
            }
        }
    }
}

