/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.trapdoor.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TrapDoorMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        int dir = tileEntity.getDirection();
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float X = 1.0f;
        float Y = 1.0f;
        float Z = 1.0f;
        if (!tileEntity.isOpened()) {
            if (topBlock) {
                y = 0.8125f;
            } else {
                Y = 0.1875f;
            }
        } else {
            if (dir == 1) {
                Z = 0.1875f;
            }
            if (dir == 0) {
                z = 0.8125f;
            }
            if (dir == 2) {
                x = 0.8125f;
            }
            if (dir == 3) {
                X = 0.1875f;
            }
        }
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)X, (double)Y, (double)Z);
    }

    private Transformation getTransformation(DoorTileEntity tileEntity) {
        float f = 0.40625f;
        float fromAngle = 0.0f;
        float toAngle = 90.0f;
        if (tileEntity.isTopBlock(0, 0, 0)) {
            toAngle = -toAngle;
        }
        if (tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED) {
            float tmp = toAngle;
            toAngle = fromAngle;
            fromAngle = tmp;
        }
        return new Rotation(fromAngle, toAngle).aroundAxis(1.0f, 0.0f, 0.0f).offset(0.0f, -f, f).forTicks(tileEntity.getDescriptor().getOpeningTime());
    }

    @Override
    public Animation[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        return new Animation[]{new Animation(model, this.getTransformation(tileEntity))};
    }

    @Override
    public boolean isSpecial() {
        return true;
    }
}

