/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.lang.ref.WeakReference;
import net.malisis.core.util.BlockPos;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockState {
    private static BlockStateFunction toBlockState = new BlockStateFunction();
    private static BlockPredicate blockFilter = new BlockPredicate();
    protected BlockPos pos;
    protected Block block;
    protected int metadata;

    public BlockState(BlockPos pos, Block block, int metadata) {
        this.pos = pos;
        this.block = block;
        this.metadata = metadata;
    }

    public BlockState(BlockPos pos, Block block) {
        this(pos, block, 0);
    }

    public BlockState(int x, int y, int z, Block block, int metadata) {
        this(new BlockPos(x, y, z), block, metadata);
    }

    public BlockState(int x, int y, int z, Block block) {
        this(new BlockPos(x, y, z), block, 0);
    }

    public BlockState(Block block, int metadata) {
        this(null, block, metadata);
    }

    public BlockState(Block block) {
        this(null, block, 0);
    }

    public BlockState(IBlockAccess world, BlockPos pos) {
        this(pos, world.func_147439_a(pos.getX(), pos.getY(), pos.getZ()), world.func_72805_g(pos.getX(), pos.getY(), pos.getZ()));
    }

    public BlockState(IBlockAccess world, int x, int y, int z) {
        this(new BlockPos(x, y, z), world.func_147439_a(x, y, z), world.func_72805_g(x, y, z));
    }

    public BlockState(IBlockAccess world, long coord) {
        this(world, BlockPos.fromLong(coord));
    }

    public BlockState(BlockPos pos, BlockState state) {
        this(pos, state.getBlock(), state.getMetadata());
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getMetadata() {
        return this.metadata;
    }

    public int getX() {
        return this.pos.getX();
    }

    public int getY() {
        return this.pos.getY();
    }

    public int getZ() {
        return this.pos.getZ();
    }

    public boolean isAir() {
        return this.getBlock().func_149688_o() == Material.field_151579_a;
    }

    public BlockState offset(BlockPos pos) {
        return new BlockState(this.pos.add(pos), this);
    }

    public BlockState rotate(int rotation) {
        return new BlockState(this.pos.rotate(rotation), this);
    }

    public void rotateInWorld(World world, int rotation) {
        ForgeDirection[] dirs = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};
        this.block.rotateBlock(world, this.getX(), this.getY(), this.getZ(), dirs[rotation / 90]);
    }

    public void placeBlock(World world) {
        world.func_147465_d(this.getX(), this.getY(), this.getZ(), this.block, this.metadata, 3);
    }

    public void placeBlock(World world, int flag) {
        world.func_147465_d(this.getX(), this.getY(), this.getZ(), this.block, this.metadata, flag);
    }

    public void breakBlock(World world, int flag) {
        world.func_147465_d(this.getX(), this.getY(), this.getZ(), Blocks.field_150350_a, 0, flag);
    }

    public boolean matchesWorld(IBlockAccess world) {
        return new BlockState(world, this.pos).equals(this);
    }

    public static Iterable<BlockState> getAllInBox(IBlockAccess world, BlockPos from, BlockPos to, Block block, boolean skipAir) {
        FluentIterable it = FluentIterable.from(new BlockPos.BlockIterator(from, to).asIterable()).transform((Function)toBlockState.set(world));
        if (block != null || skipAir) {
            it.filter((Predicate)blockFilter.set(block, skipAir));
        }
        return it;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockState)) {
            return false;
        }
        BlockState bs = (BlockState)obj;
        return this.pos.equals(bs.pos) && this.block == bs.block && this.metadata == bs.metadata;
    }

    public String toString() {
        return "[" + this.pos + "] " + (this.block != null ? this.block.func_149739_a().substring(5) + " (" + this.metadata + ")" : "");
    }

    public static BlockState fromNBT(NBTTagCompound nbt) {
        return BlockState.fromNBT(nbt, "block", "metadata");
    }

    public static BlockState fromNBT(NBTTagCompound nbt, String blockName, String metadataName) {
        if (nbt == null) {
            return null;
        }
        Block block = nbt.func_150297_b(blockName, 3) ? Block.func_149729_e((int)nbt.func_74762_e(blockName)) : Block.func_149684_b((String)nbt.func_74779_i(blockName));
        if (block == null) {
            return null;
        }
        return new BlockState(block, nbt.func_74762_e(metadataName));
    }

    public static NBTTagCompound toNBT(NBTTagCompound nbt, BlockState state) {
        return BlockState.toNBT(nbt, state, "block", "metadata");
    }

    public static NBTTagCompound toNBT(NBTTagCompound nbt, BlockState state, String blockName, String metadataName) {
        if (state == null) {
            return nbt;
        }
        nbt.func_74778_a(blockName, Block.field_149771_c.func_148750_c((Object)state.getBlock()).toString());
        nbt.func_74768_a(metadataName, state.getMetadata());
        return nbt;
    }

    public static class BlockStateFunction
    implements Function<BlockPos, BlockState> {
        public WeakReference<IBlockAccess> world;

        public BlockStateFunction set(IBlockAccess world) {
            this.world = new WeakReference<IBlockAccess>(world);
            return this;
        }

        public BlockState apply(BlockPos pos) {
            return new BlockState((IBlockAccess)this.world.get(), pos);
        }
    }

    public static class BlockPredicate
    implements Predicate<BlockState> {
        public Block block;
        public boolean skipAir;

        public BlockPredicate set(Block block, boolean skipAir) {
            this.block = block;
            this.skipAir = skipAir;
            return this;
        }

        public boolean apply(BlockState state) {
            if (this.block == null) {
                return state.getBlock() != Blocks.field_150350_a;
            }
            return state.getBlock() == this.block;
        }
    }
}

