/*
 * Decompiled with CFR 0.152.
 */
package thaumicinsurgence.tileentity;

import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.common.tiles.TileInfusionMatrix;

public class TileEntityInfusionIntercepter
extends TileEntity
implements IAspectContainer,
IEssentiaTransport {
    public static final String tileEntityName = "thaumicinsurgence.infusionIntercepter";
    private AspectList myAspects = new AspectList();
    private AspectList matrixAspects = new AspectList();
    private Aspect currentSuction = null;
    private TileInfusionMatrix matrix = null;
    private IEssentiaTransport essentiaEntity = null;
    public boolean addedStability;
    public boolean stabilityHasBeenAdded;

    public void setAspects(AspectList aspects) {
        this.myAspects = aspects;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.matrix == null) {
            this.setMatrix();
        }
        if (this.essentiaEntity == null) {
            this.setInput();
        }
        if (this.matrix != null && this.essentiaEntity != null) {
            this.grabAllAspects();
        }
    }

    public void grabAllAspects() {
        if (this.matrix.getAspects().size() != 0) {
            this.matrixAspects = this.matrix.getAspects().copy();
            Aspect[] aspectArray = this.matrixAspects.getAspects();
            int n = aspectArray.length;
            for (int i = 0; i < n; ++i) {
                Aspect aspect;
                this.currentSuction = aspect = aspectArray[i];
                int desiredAmount = this.matrixAspects.getAmount(aspect);
                int removedAmount = this.removeFromSource(desiredAmount);
                if (removedAmount > 0) {
                    this.moveEssentiaToMatrix(desiredAmount);
                }
                if (removedAmount == desiredAmount) {
                    continue;
                }
                break;
            }
        } else if (this.myAspects.size() != 0) {
            this.myAspects = new AspectList();
        }
    }

    public void addStability() {
        this.matrix.instability -= 20;
        this.addedStability = true;
        this.stabilityHasBeenAdded = true;
    }

    public void removeStability() {
        this.matrix.instability += 20;
        this.addedStability = false;
        this.stabilityHasBeenAdded = false;
    }

    public void setInput() {
        try {
            TileEntity inputCandidate = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            if (inputCandidate instanceof IEssentiaTransport) {
                this.essentiaEntity = (IEssentiaTransport)inputCandidate;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMatrix() {
        try {
            TileEntity matrixCandidate = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e);
            if (matrixCandidate instanceof TileInfusionMatrix) {
                this.matrix = (TileInfusionMatrix)matrixCandidate;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int removeFromSource(int desiredAmount) {
        int sourceAmount = this.essentiaEntity.getEssentiaAmount(ForgeDirection.UP);
        Aspect tubeAspect = this.essentiaEntity.getEssentiaType(ForgeDirection.UP);
        if (tubeAspect != null && tubeAspect.equals(this.currentSuction) && sourceAmount > 0) {
            int usedAmount = Math.min(sourceAmount, desiredAmount);
            this.essentiaEntity.takeEssentia(tubeAspect, usedAmount, ForgeDirection.UP);
            this.myAspects.add(tubeAspect, usedAmount);
            return usedAmount;
        }
        return 0;
    }

    private void moveEssentiaToMatrix(int desiredAmount) {
        int heldAmount = this.myAspects.getAmount(this.currentSuction);
        this.matrix.getAspects().remove(this.currentSuction, heldAmount);
        this.myAspects.remove(this.currentSuction);
        if (heldAmount >= desiredAmount) {
            this.currentSuction = null;
        }
    }

    public AspectList getAspects() {
        return this.myAspects;
    }

    public boolean doesContainerAccept(Aspect tag) {
        return true;
    }

    public int addToContainer(Aspect tag, int am) {
        if (am != 0) {
            this.myAspects.add(tag, am);
            am = 0;
        }
        return am;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return this.myAspects.getAmount(tag) > amount;
    }

    public boolean doesContainerContain(AspectList ot) {
        boolean hasIt = true;
        ot.aspects.keySet().iterator();
        for (Aspect next : ot.aspects.keySet()) {
            if (this.myAspects.getAmount(next) >= ot.getAmount(next)) continue;
            hasIt = false;
        }
        return hasIt;
    }

    public int containerContains(Aspect tag) {
        return this.myAspects.getAmount(tag);
    }

    public boolean isConnectable(ForgeDirection face) {
        return face != ForgeDirection.UP;
    }

    public boolean canInputFrom(ForgeDirection face) {
        return face != ForgeDirection.UP;
    }

    public boolean canOutputTo(ForgeDirection face) {
        return false;
    }

    public void setSuction(Aspect aspect, int amount) {
        this.currentSuction = aspect;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection arg2) {
        return this.canOutputTo(arg2) && this.takeFromContainer(aspect, amount) ? amount : 0;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public boolean renderExtendedTube() {
        return false;
    }

    public Aspect getSuctionType(ForgeDirection face) {
        return this.currentSuction;
    }

    public int getSuctionAmount(ForgeDirection face) {
        return this.currentSuction != null ? 128 : 0;
    }

    public Aspect getEssentiaType(ForgeDirection face) {
        return this.myAspects.visSize() > 0 && face == ForgeDirection.UNKNOWN ? this.myAspects.getAspects()[0] : null;
    }

    public int getEssentiaAmount(ForgeDirection face) {
        return this.myAspects.visSize();
    }

    public int addEssentia(Aspect arg0, int arg1, ForgeDirection arg2) {
        if (arg0 == this.currentSuction) {
            return this.canInputFrom(arg2) ? arg1 - this.addToContainer(arg0, arg1) : 0;
        }
        return 0;
    }

    private float tagAmount() {
        int amount = 0;
        for (Aspect next : this.myAspects.aspects.keySet()) {
            amount += this.myAspects.getAmount(next);
        }
        return amount;
    }
}

